package com.wb.tool;

import com.wb.tool.Route;
import com.wb.util.DbUtil;
import com.wb.util.JsonUtil;
import com.wb.util.SysUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.Date;
import java.util.HashSet;
import org.json.JSONArray;
import org.json.JSONObject;

public class Flow {

   public static Route start(String workflowId) throws Exception {
      return start(workflowId, (String[])null);
   }

   public static Route start(String workflowId, String[] startNodes) throws Exception {
      String workflow = getContent(workflowId, true);
      Date date = new Date();
      if(workflow == null) {
         throw new Exception("Workflow \"" + workflowId + "\" does not exist.");
      } else {
         JSONObject template = new JSONObject(workflow);
         JSONObject jo = new JSONObject();
         JSONArray nodes;
         if(startNodes == null) {
            nodes = getStartNodes(template);
         } else {
            nodes = new JSONArray(startNodes);
         }

         if(nodes.length() == 0) {
            throw new Exception("Please select some nodes to start the route.");
         } else {
            Route route = new Route(jo, template);
            route.set("CURRENT_NODES", nodes);
            route.set("ACTIVE_NODE", nodes.optString(0));
            route.set("ROUTE_ID", SysUtil.getId());
            route.set("FLOW_ID", workflowId);
            route.set("CREATE_DATE", date);
            route.set("MODIFY_DATE", date);
            return route;
         }
      }
   }

   private static JSONArray getStartNodes(JSONObject template) throws Exception {
      JSONArray list = template.getJSONArray("list");
      JSONArray currentNodes = new JSONArray();
      JSONObject obj = JsonUtil.findObject(list, "label", "开始");
      if(obj == null) {
         HashSet nodes = new HashSet();
         JSONArray conn = template.getJSONArray("conn");
         int j = conn.length();

         int i;
         for(i = 0; i < j; ++i) {
            obj = conn.getJSONObject(i);
            nodes.add(obj.getString("dst"));
         }

         j = list.length();

         for(i = 0; i < j; ++i) {
            obj = list.getJSONObject(i);
            if(obj.getBoolean("isObj")) {
               String name = obj.getString("label");
               if(!nodes.contains(name)) {
                  currentNodes.put(name);
               }
            }
         }
      } else {
         currentNodes.put("开始");
      }

      return currentNodes;
   }

   public static Route create(String routeId) throws Exception {
      String route = getContent(routeId, false);
      if(route == null) {
         throw new Exception("Route \"" + routeId + "\" does not exist.");
      } else {
         JSONObject routeObj = new JSONObject(route);
         String tpl = routeObj.optString("FLOW_XTPL");
         if(tpl == null) {
            throw new Exception("The workflow does not exist.");
         } else {
            return new Route(routeObj, new JSONObject(tpl));
         }
      }
   }

   public static Route create(String routeText, JSONObject flowJson) {
      return new Route(new JSONObject(routeText), flowJson);
   }

   public static void remove(String routeId) throws Exception {
      Connection conn = null;
      PreparedStatement st = null;

      try {
         conn = DbUtil.getConnection();
         st = conn.prepareStatement("delete from WB_ROUTE where ROUTE_ID=?");
         st.setString(1, routeId);
         st.executeUpdate();
      } finally {
         DbUtil.close(st);
         DbUtil.close(conn);
      }

   }

   public static JSONObject get(String id) {
      return new JSONObject(getContent(id, true));
   }

   public static String getContent(String id, boolean isFlow) {
      Connection conn = null;
      PreparedStatement st = null;
      ResultSet rs = null;

      try {
         conn = DbUtil.getConnection();
         if(isFlow) {
            st = conn.prepareStatement("select FLOW_CONTENT from WB_FLOW where FLOW_ID=?");
         } else {
            st = conn.prepareStatement("select ROUTE_CONTENT from WB_ROUTE where ROUTE_ID=?");
         }

         st.setString(1, id);
         rs = st.executeQuery();
         if(rs.next()) {
            String var7 = (String)DbUtil.getObject(rs, 1, 2005);
            return var7;
         }
      } catch (Throwable var10) {
         throw new RuntimeException(var10);
      } finally {
         DbUtil.close(rs);
         DbUtil.close(st);
         DbUtil.close(conn);
      }

      return null;
   }
}
