package com.wb.tool;

import com.wb.common.Var;
import com.wb.tool.QueueWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class Console {

   public static void log(HttpServletRequest request, Object object) {
      print(request, object, "log");
   }

   public static void debug(HttpServletRequest request, Object object) {
      print(request, object, "debug");
   }

   public static void info(HttpServletRequest request, Object object) {
      print(request, object, "info");
   }

   public static void warn(HttpServletRequest request, Object object) {
      print(request, object, "warn");
   }

   public static void error(HttpServletRequest request, Object object) {
      print(request, object, "error");
   }

   public static void print(HttpServletRequest request, Object object, String type, boolean encoded) {
      if(Var.consolePrint) {
         try {
            HttpSession session = request.getSession(false);
            if(session != null) {
               QueueWriter out = (QueueWriter)session.getAttribute("sys.out");
               if(out != null) {
                  out.print(object, type, encoded);
               }
            }
         } catch (Throwable var6) {
            ;
         }
      }

   }

   public static void print(HttpServletRequest request, Object object, String type) {
      print(request, object, type, false);
   }
}
