package com.wb.task;

import com.rw.dao.BaseDAO;
import com.rw.email.service.EmailService;
import com.rw.model.FileModel;
import com.rw.util.PropKit;
import com.rw.util.SpringContextHolder;
import com.wb.common.Base;
import com.wb.tool.MailSender;
import com.wb.util.DateUtil;
import com.wb.util.LogUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class MailTask implements Job {

   public void execute(JobExecutionContext context) throws JobExecutionException {
      MailSender mailSender = null;
      long start = System.currentTimeMillis();
      String jobDesc = context.getJobDetail().getDescription();

      try {
         LogUtil.info("Start job " + jobDesc);
         String e = PropKit.getProperty("mail.smtp.host");
         boolean stmp_auth = Boolean.parseBoolean(PropKit.getProperty("mail.smtp.auth"));
         String username = PropKit.getProperty("mail.username");
         String password = PropKit.getProperty("mail.password");
         String fromUser = PropKit.getProperty("mail.fromUser");
         int max_retry_count = Integer.parseInt(StringUtils.defaultIfBlank(PropKit.getProperty("mail.maxRetryCount"), "5"));
         mailSender = new MailSender(e, username, password, stmp_auth);
         String queryNoSendedSql = "SELECT mail.MAIL_ID,mail.MAIL_SUBJECT,mail.MAIL_CONTENT,mail.IS_HTML,mail.SRC,mail.OBJECT_ID,mail.CREATOR,mail.CREATE_TIME,mailreceiver.TO_USER,mailreceiver.RECV_ADDR,mailreceiver.SEND_TYPE,mailreceiver.RETRY_TIMES,mailreceiver.MAIL_ATTACHMENT FROM T_MAIL mail LEFT JOIN T_MAIL_RECEIVER mailreceiver on mail.MAIL_ID = mailreceiver.MAIL_ID WHERE mailreceiver.STATUS = 0 AND mail.IS_VALID = 1 AND mail.EXPIRED_TIME > GETDATE()";
         String updateSendedStateSql = "UPDATE T_MAIL_RECEIVER SET STATUS = ? , RETRY_TIMES = ?, LAST_PROCESS_TIME = GETDATE() WHERE MAIL_ID = ?";
         EmailService emailService = (EmailService)SpringContextHolder.getBean("emailService");
         BaseDAO baseDAO = (BaseDAO)SpringContextHolder.getBean("baseDAO");
         List mailList = emailService.getEmails(queryNoSendedSql);
         Iterator var26 = mailList.iterator();

         while(var26.hasNext()) {
            Map mail = (Map)var26.next();
            String mailId = (String)mail.get("MAIL_ID");
            String to = (String)mail.get("RECV_ADDR");
            String subject = (String)mail.get("MAIL_SUBJECT");
            String content = (String)mail.get("MAIL_CONTENT");
            String isHtml = (String)mail.get("IS_HTML");
            String attachment = ObjectUtils.toString(mail.get("MAIL_ATTACHMENT"), "");
            int hasRetryCount = mail.get("RETRY_TIMES") == null?0:Integer.parseInt(mail.get("RETRY_TIMES").toString());

            byte status;
            try {
               if(StringUtils.isNotBlank(attachment)) {
                  String[] e1 = StringUtils.split(attachment.trim(), ",");
                  ArrayList attachementFileList = new ArrayList(e1.length);
                  FileModel fileModel = null;
                  String fileName = null;
                  File file = null;
                  String[] var35 = e1;
                  int var34 = e1.length;

                  for(int var33 = 0; var33 < var34; ++var33) {
                     String id = var35[var33];
                     if(StringUtils.isNotBlank(id)) {
                        fileModel = baseDAO.getFileFromDB(id);
                        if(fileModel != null) {
                           fileName = fileModel.getName() + "." + fileModel.getExtension();
                           file = new File(System.getProperty("java.io.tmpdir"), fileModel.getId());
                           File destFile = new File(Base.path, fileModel.getName() + "." + fileModel.getExtension());
                           FileUtils.copyFile(file, destFile);
                           attachementFileList.add(fileName);
                        }
                     }
                  }

                  mailSender.send(fromUser, to, "", "", subject, content, StringUtils.join(attachementFileList, ","), (HttpServletRequest)null, (String)null, (String)null);
               } else {
                  mailSender.send(fromUser, to, "", "", subject, content);
               }

               status = 1;
               LogUtil.info(StringUtil.concat(new String[]{"send mail  for (subject=\'" + subject + "\', to=\'" + to + "发送成功！", " in ", DateUtil.format(System.currentTimeMillis() - start)}));
            } catch (Exception var48) {
               LogUtil.error("send mail error for (subject=\'" + subject + "\', to=\'" + to + "\')  is " + var48.getMessage());
               status = 2;
               if(hasRetryCount + 1 < max_retry_count) {
                  status = 0;
               }
            }

            ++hasRetryCount;
            emailService.updateSendedState(updateSendedStateSql, new Object[]{Integer.valueOf(status), Integer.valueOf(hasRetryCount), mailId});
         }
      } catch (IOException var49) {
         var49.printStackTrace();
         LogUtil.error(StringUtil.concat(new String[]{"Execute mail job ", jobDesc, " failed with error ", SysUtil.getRootError(var49), " in ", DateUtil.format(System.currentTimeMillis() - start)}));
      } catch (Exception var50) {
         var50.printStackTrace();
         LogUtil.error(StringUtil.concat(new String[]{"Execute mail job ", jobDesc, " failed with error ", SysUtil.getRootError(var50), " in ", DateUtil.format(System.currentTimeMillis() - start)}));
      } finally {
         try {
            mailSender.close();
         } catch (Exception var47) {
            LogUtil.error("关闭邮件服务器失败:" + var47.getMessage());
            var47.printStackTrace();
         }

      }

   }
}
