package com.wb.interact;

import com.wb.common.Base;
import com.wb.common.KVBuffer;
import com.wb.common.Session;
import com.wb.common.XwlBuffer;
import com.wb.interact.DBE;
import com.wb.interact.IDE;
import com.wb.util.DbUtil;
import com.wb.util.FileUtil;
import com.wb.util.JsonUtil;
import com.wb.util.SortUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import java.io.File;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map.Entry;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public class Tools {

   public static void getDictTree(HttpServletRequest request, HttpServletResponse response) throws Exception {
      String jndi = request.getParameter("jndi");
      if(StringUtil.isEmpty(jndi)) {
         WebUtil.send(response, DBE.getDbList());
      } else {
         String dbName = request.getParameter("dbName");
         boolean hasDbName = !"default".equals(dbName);
         boolean hasSchem = Boolean.parseBoolean(request.getParameter("hasSchem"));
         HashSet tables = new HashSet();
         ResultSet rs = (ResultSet)DbUtil.run(request, "select distinct TABLE_NAME from WB_DICT");
         dbName = dbName.toUpperCase() + '.';
         int dbNameLen = dbName.length();

         while(rs.next()) {
            String tableName = rs.getString(1).toUpperCase();
            if(hasDbName) {
               if(tableName.startsWith(dbName)) {
                  tables.add(tableName.substring(dbNameLen));
               }
            } else if(tableName.indexOf(46) == -1) {
               tables.add(tableName);
            }
         }

         WebUtil.send(response, DBE.getTableList(jndi, hasSchem, tables));
      }

   }

   public static void loadKeyNames(HttpServletRequest request, HttpServletResponse response) {
      boolean isFirst = true;
      StringBuilder buf = new StringBuilder();
      ArrayList keys = SortUtil.sortKey(KVBuffer.buffer);
      buf.append("[");

      Entry key;
      for(Iterator var6 = keys.iterator(); var6.hasNext(); buf.append(StringUtil.quote((String)key.getKey()))) {
         key = (Entry)var6.next();
         if(isFirst) {
            isFirst = false;
         } else {
            buf.append(",");
         }
      }

      buf.append("]");
      request.setAttribute("keyNameList", StringUtil.quote(buf.toString(), false));
   }

   public static void getModulesPerm(HttpServletRequest request, HttpServletResponse response) throws Exception {
      JSONObject perms = new JSONObject();
      scanModulePerm(Base.modulePath, perms);
      WebUtil.send(response, perms);
   }

   private static void scanModulePerm(File path, JSONObject perms) throws Exception {
      File[] files = FileUtil.listFiles(path);
      File[] var9 = files;
      int var8 = files.length;

      for(int var7 = 0; var7 < var8; ++var7) {
         File file = var9[var7];
         if(file.isDirectory()) {
            scanModulePerm(file, perms);
         } else {
            String filename = file.getName();
            if(filename.endsWith(".xwl")) {
               JSONObject jo = JsonUtil.readObject(file);
               JSONObject roles = (JSONObject)jo.opt("roles");
               perms.put(FileUtil.getModulePath(file), roles);
            }
         }
      }

   }

   public static void delModulesPerm(HttpServletRequest request, HttpServletResponse response) throws Exception {
      JSONArray destroy = new JSONArray(request.getParameter("destroy"));
      int j = destroy.length();
      if(j != 0) {
         String[] roles = new String[j];

         for(int i = 0; i < j; ++i) {
            roles[i] = destroy.getJSONObject(i).getString("ROLE_ID");
         }

         doDelPerm(Base.modulePath, roles);
      }
   }

   private static void doDelPerm(File path, String[] delRoles) throws Exception {
      File[] files = FileUtil.listFiles(path);
      File[] var7 = files;
      int var6 = files.length;

      for(int var5 = 0; var5 < var6; ++var5) {
         File file = var7[var5];
         if(file.isDirectory()) {
            doDelPerm(file, delRoles);
         } else {
            String filename = file.getName();
            if(filename.endsWith(".xwl")) {
               IDE.updateModule(file, (JSONObject)null, delRoles, false);
            }
         }
      }

   }

   public static void setModulesPerm(HttpServletRequest request, HttpServletResponse response) throws Exception {
      String[] roles = new String[1];
      String[] userRoles = Session.getRoles(request);
      boolean checked = Boolean.parseBoolean(request.getParameter("checked"));
      JSONArray pathList = new JSONArray(request.getParameter("path"));
      int j = pathList.length();
      roles[0] = request.getParameter("role");

      for(int i = 0; i < j; ++i) {
         File file = new File(Base.modulePath, pathList.getString(i));
         if(!file.isDirectory()) {
            if(!XwlBuffer.canAccess(XwlBuffer.get(FileUtil.getModulePath(file), false), userRoles)) {
               SysUtil.accessDenied();
            }

            IDE.updateModule(file, (JSONObject)null, roles, checked);
         }
      }

   }
}
