package com.wb.interact;

import com.wb.common.Base;
import com.wb.common.Resource;
import com.wb.common.Session;
import com.wb.common.Str;
import com.wb.common.Value;
import com.wb.common.XwlBuffer;
import com.wb.interact.IDE;
import com.wb.util.DbUtil;
import com.wb.util.FileUtil;
import com.wb.util.JsonUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map.Entry;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class Portal {

   private static JSONArray getModuleList(HttpServletRequest request, String path, String[] roles, int type) throws Exception {
      int displayType = type == 1?1:3;
      File base;
      if(path == null) {
         base = Base.modulePath;
      } else {
         base = new File(Base.modulePath, path);
         if(!FileUtil.isAncestor(Base.modulePath, base)) {
            SysUtil.accessDenied();
         }
      }

      path = path + "/";
      ArrayList fileNames = IDE.getSortedFile(base);
      JSONObject content = null;
      JSONArray fileArray = new JSONArray();
      Iterator var19 = fileNames.iterator();

      while(var19.hasNext()) {
         Entry entry = (Entry)var19.next();
         String fileName = (String)entry.getKey();
         File file = new File(base, fileName);
         if(file.exists() && XwlBuffer.canDisplay(file, roles, displayType)) {
            boolean isFolder = file.isDirectory();
            if(isFolder) {
               if(type != 1 && !hasLoginModule(file)) {
                  continue;
               }

               File configFile = new File(file, "folder.json");
               if(configFile.exists()) {
                  content = JsonUtil.readObject(configFile);
               } else {
                  content = new JSONObject();
               }
            } else {
               if(type != 1 && !file.getName().endsWith(".xwl")) {
                  continue;
               }

               content = XwlBuffer.get(path + fileName, false);
               if(type != 1 && Boolean.FALSE.equals(content.opt("loginRequired"))) {
                  continue;
               }
            }

            JSONObject fileObject = new JSONObject();
            String title = content.optString("title");
            String qtip = content.optString("qtip");
            if(title.startsWith("Str.")) {
               title = Str.format(request, title.substring(4), new Object[0]);
            }

            fileObject.put("text", StringUtil.select(new String[]{title, fileName}));
            fileObject.put("qtip", qtip);
            String relPath = FileUtil.getModulePath(file);
            fileObject.put("path", relPath);
            fileObject.put("fileName", fileName);
            fileObject.put("inframe", Boolean.TRUE.equals(content.opt("inframe")));
            if(isFolder) {
               fileObject.put("children", getModuleList(request, relPath, roles, type));
            } else {
               String pageLink = (String)content.opt("pageLink");
               if(!StringUtil.isEmpty(pageLink)) {
                  fileObject.put("pageLink", pageLink);
               }

               fileObject.put("leaf", true);
            }

            fileObject.put("cls", "wb_pointer");
            String iconCls = content.optString("iconCls");
            if(!StringUtil.isEmpty(iconCls)) {
               fileObject.put("iconCls", iconCls);
            }

            if(type == 2 && !isFolder) {
               fileObject.put("checked", false);
            }

            fileArray.put(fileObject);
         }
      }

      return fileArray;
   }

   private static boolean hasLoginModule(File path) throws IOException {
      File[] files = FileUtil.listFiles(path);
      File[] var5 = files;
      int var4 = files.length;

      for(int var3 = 0; var3 < var4; ++var3) {
         File file = var5[var3];
         if(file.isDirectory()) {
            if(hasLoginModule(file)) {
               return true;
            }
         } else if(file.getName().endsWith(".xwl")) {
            JSONObject content = XwlBuffer.get(FileUtil.getModulePath(file), true);
            if(Boolean.TRUE.equals(content.opt("loginRequired"))) {
               return true;
            }
         }
      }

      return false;
   }

   public static void initHome(HttpServletRequest request, HttpServletResponse response) throws Exception {
      String desktopString = Resource.getString(request, "desktop", (String)null);
      if(desktopString == null) {
         desktopString = Resource.getString("sys.home.desktop", (String)null);
      }

      int treeWidth;
      int viewIndex;
      boolean treeCollapsed;
      boolean treeHidden;
      if(desktopString != null) {
         JSONObject desktop = new JSONObject(desktopString);
         treeWidth = desktop.optInt("treeWidth", 200);
         viewIndex = desktop.optInt("viewIndex", 0);
         treeCollapsed = desktop.optBoolean("treeCollapsed", false);
         treeHidden = desktop.optBoolean("treeHidden", false);
         JSONArray pages = desktop.optJSONArray("pages");
         int i;
         int j;
         String url;
         String title;
         String pageLink;
         String qtip;
         JSONObject portlet;
         JSONObject module;
         if(pages != null) {
            i = pages.length();
            j = desktop.optInt("active", 0);
            JSONArray tabItems = new JSONArray();

            for(int portlets = 0; portlets < i; ++portlets) {
               JSONObject cols = pages.optJSONObject(portlets);
               pageLink = cols.optString("url");
               String k = FileUtil.getModuleFile(pageLink, true);
               portlet = XwlBuffer.get(k, true);
               if(portlet == null) {
                  if(portlets <= j) {
                     --j;
                  }
               } else {
                  module = new JSONObject();
                  module.put("url", pageLink);
                  String l = (String)portlet.opt("title");
                  if(l.startsWith("Str.")) {
                     l = Str.format(request, l.substring(4), new Object[0]);
                  }

                  module.put("title", StringUtil.select(new String[]{l, FileUtil.getFilename(k)}));
                  module.put("iconCls", (String)portlet.opt("iconCls"));
                  module.put("useIFrame", Boolean.TRUE.equals(portlet.opt("inframe")));
                  title = cols.optString("params");
                  if(!StringUtil.isEmpty(title)) {
                     module.put("params", new JSONObject(title));
                  }

                  url = (String)portlet.opt("pageLink");
                  if(!StringUtil.isEmpty(url)) {
                     JsonUtil.apply(module, new JSONObject(url));
                  }

                  qtip = ObjectUtils.toString(portlet.opt("qtip"), "");
                  if(StringUtils.isNotBlank(qtip)) {
                     module.put("qtip", qtip);
                  }

                  tabItems.put(module);
               }
            }

            request.setAttribute("activeIndex", Integer.valueOf(j));
            request.setAttribute("tabItems", StringUtil.text(tabItems.toString()));
         }

         JSONArray var22 = desktop.optJSONArray("portlets");
         if(var22 != null) {
            j = var22.length();

            for(i = 0; i < j; ++i) {
               JSONArray var25 = var22.optJSONArray(i);
               int var24 = var25.length();

               for(int var23 = 0; var23 < var24; ++var23) {
                  portlet = var25.optJSONObject(var23);
                  url = FileUtil.getModuleFile(portlet.optString("url"), true);
                  module = XwlBuffer.get(url, true);
                  if(module == null) {
                     var25.remove(var23);
                     --var23;
                     --var24;
                  } else {
                     title = (String)module.opt("title");
                     if(title.startsWith("Str.")) {
                        title = Str.format(request, title.substring(4), new Object[0]);
                     }

                     portlet.put("title", StringUtil.select(new String[]{title, FileUtil.getFilename(url)}));
                     portlet.put("iconCls", (String)module.opt("iconCls"));
                     portlet.put("useIFrame", Boolean.TRUE.equals(module.opt("inframe")));
                     pageLink = (String)module.opt("pageLink");
                     if(!StringUtil.isEmpty(pageLink)) {
                        JsonUtil.apply(portlet, new JSONObject(pageLink));
                     }

                     qtip = ObjectUtils.toString(module.opt("qtip"), "");
                     if(StringUtils.isNotBlank(qtip)) {
                        portlet.put("qtip", qtip);
                     }
                  }
               }
            }

            request.setAttribute("portlets", StringUtil.text(var22.toString()));
         }
      } else {
         treeWidth = 200;
         viewIndex = 0;
         treeCollapsed = false;
         treeHidden = false;
      }

      request.setAttribute("treeWidth", Integer.valueOf(treeWidth));
      request.setAttribute("viewIndex", Integer.valueOf(viewIndex));
      request.setAttribute("treeCollapsed", Boolean.valueOf(treeCollapsed));
      request.setAttribute("treeHidden", Boolean.valueOf(treeHidden));
      request.setAttribute("hideSetDefaultDesktop", Boolean.valueOf(!XwlBuffer.canAccess(request, "m?xwl=sys/portal/home/save-default-desktop")));
      request.setAttribute("hideSetAllDesktop", Boolean.valueOf(!XwlBuffer.canAccess(request, "m?xwl=sys/portal/home/save-all-desktop")));
   }

   public static void saveDesktop(HttpServletRequest request, HttpServletResponse response) throws Exception {
      doSaveDesktop(request, 1);
   }

   public static void saveAsDefaultDesktop(HttpServletRequest request, HttpServletResponse response) throws Exception {
      doSaveDesktop(request, 2);
   }

   public static void saveAsAllDesktop(HttpServletRequest request, HttpServletResponse response) throws Exception {
      doSaveDesktop(request, 3);
   }

   private static void doSaveDesktop(HttpServletRequest request, int type) throws Exception {
      JSONObject desktop = new JSONObject();
      desktop.put("treeWidth", Integer.parseInt(request.getParameter("treeWidth")));
      desktop.put("viewIndex", Integer.parseInt(request.getParameter("viewIndex")));
      desktop.put("treeCollapsed", Boolean.parseBoolean(request.getParameter("treeCollapsed")));
      desktop.put("treeHidden", Boolean.parseBoolean(request.getParameter("treeHidden")));
      desktop.put("pages", new JSONArray(request.getParameter("pages")));
      desktop.put("portlets", new JSONArray(request.getParameter("portlets")));
      desktop.put("active", Integer.parseInt(request.getParameter("active")));
      if(type == 1) {
         Resource.set(request, "desktop", desktop.toString());
      } else {
         if(type == 3) {
            DbUtil.run(request, "delete from WB_RESOURCE where RES_ID like \'desktop@%\'");
         }

         Resource.set("sys.home.desktop", desktop.toString());
      }

   }

   public static void getAppList(HttpServletRequest request, HttpServletResponse response) throws Exception {
      WebUtil.send(response, (new JSONObject()).put("children", getModuleList(request, request.getParameter("path"), Session.getRoles(request), 1)));
   }

   public static void getPermList(HttpServletRequest request, HttpServletResponse response) throws Exception {
      WebUtil.send(response, (new JSONObject()).put("children", getModuleList(request, request.getParameter("path"), Session.getRoles(request), 2)));
   }

   public static void getUserPermList(HttpServletRequest request, HttpServletResponse response) throws Exception {
      WebUtil.send(response, (new JSONObject()).put("children", getModuleList(request, request.getParameter("path"), Session.getRoles(request), 3)));
   }

   public static void setTheme(HttpServletRequest request, HttpServletResponse response) throws Exception {
      String theme = request.getParameter("theme");
      Value.set(request, "theme", theme);
      WebUtil.setSessionValue(request, "sys.theme", theme);
   }

   public static void setTouchTheme(HttpServletRequest request, HttpServletResponse response) throws Exception {
      String theme = request.getParameter("theme");
      Value.set(request, "touchTheme", theme);
      WebUtil.setSessionValue(request, "sys.touchTheme", theme);
   }

   public static void initTouchHome(HttpServletRequest request, HttpServletResponse response) throws Exception {
      HttpSession session = request.getSession(false);
      boolean isNotLogin = session == null || session.getAttribute("sys.logined") == null;
      request.setAttribute("isNotLogin", Integer.valueOf(isNotLogin?1:0));
   }

   private static void searchModule(HttpServletRequest request, HttpServletResponse response, boolean isPerm) throws Exception {
      JSONArray array = new JSONArray();
      String query = request.getParameter("query").toLowerCase();
      String[] roles = Session.getRoles(request);
      if(query.isEmpty()) {
         query = ".xwl";
      }

      doSearchFile(request, Base.modulePath, query.toLowerCase(), "", "", array, isPerm, roles);
      WebUtil.send(response, (new JSONObject()).put("rows", array));
   }

   public static void searchAppModule(HttpServletRequest request, HttpServletResponse response) throws Exception {
      searchModule(request, response, false);
   }

   public static void searchPermModule(HttpServletRequest request, HttpServletResponse response) throws Exception {
      searchModule(request, response, true);
   }

   private static boolean doSearchFile(HttpServletRequest request, File folder, String searchName, String parentText, String parentFile, JSONArray array, boolean isPerm, String[] roles) throws Exception {
      File[] files = FileUtil.listFiles(folder);
      File[] var14 = files;
      int var13 = files.length;

      for(int var12 = 0; var12 < var13; ++var12) {
         File file = var14[var12];
         if(XwlBuffer.canDisplay(file, roles, isPerm?3:1)) {
            if(file.isDirectory()) {
               File var19 = new File(file, "folder.json");
               String folderFile = file.getName();
               JSONObject jo1;
               String var20;
               if(var19.exists()) {
                  jo1 = JsonUtil.readObject(var19);
                  var20 = jo1.optString("title");
                  if(var20.isEmpty()) {
                     var20 = folderFile;
                  }
               } else {
                  var20 = folderFile;
               }

               if(var20.startsWith("Str.")) {
                  var20 = Str.format(request, var20.substring(4), new Object[0]);
               }

               if(!isPerm && var20.toLowerCase().indexOf(searchName) != -1) {
                  jo1 = new JSONObject();
                  jo1.put("path", parentText);
                  jo1.put("title", var20);
                  jo1.put("file", folderFile);
                  jo1.put("parentFile", parentFile);
                  array.put(jo1);
                  if(array.length() > 99) {
                     return true;
                  }
               }

               if(doSearchFile(request, file, searchName, StringUtil.concat(new String[]{parentText, "/", var20}), StringUtil.concat(new String[]{parentFile, "/", folderFile}), array, isPerm, roles)) {
                  return true;
               }
            } else {
               String path = FileUtil.getModulePath(file);
               if(path.endsWith(".xwl")) {
                  JSONObject moduleData = XwlBuffer.get(path, false);
                  if(!isPerm || !Boolean.FALSE.equals(moduleData.opt("loginRequired"))) {
                     String title = moduleData.optString("title");
                     if(title.isEmpty()) {
                        title = path.substring(path.lastIndexOf(47) + 1);
                     }

                     if(title.startsWith("Str.")) {
                        title = Str.format(request, title.substring(4), new Object[0]);
                     }

                     if(title.toLowerCase().indexOf(searchName) != -1) {
                        JSONObject jo = new JSONObject();
                        jo.put("path", parentText);
                        jo.put("title", title);
                        jo.put("file", file.getName());
                        jo.put("parentFile", parentFile);
                        array.put(jo);
                        if(array.length() > 99) {
                           return true;
                        }
                     }
                  }
               }
            }
         }
      }

      return false;
   }

   public static void getMobileAppList(HttpServletRequest request, HttpServletResponse response) throws Exception {
      ArrayList appList = new ArrayList();
      JSONArray outputList = new JSONArray();
      String[] roles = Session.getRoles(request);
      scanMobileApp(request, appList, new File(Base.modulePath, "apps"), roles);
      Iterator var6 = appList.iterator();

      while(var6.hasNext()) {
         JSONObject jo = (JSONObject)var6.next();
         outputList.put(jo);
      }

      WebUtil.send(response, (new JSONObject()).put("rows", outputList));
   }

   private static void scanMobileApp(HttpServletRequest request, ArrayList appList, File path, String[] roles) throws Exception {
      ArrayList fileNames = IDE.getSortedFile(path);
      Iterator var15 = fileNames.iterator();

      while(var15.hasNext()) {
         Entry entry = (Entry)var15.next();
         String fileName = (String)entry.getKey();
         File file = new File(path, fileName);
         if(XwlBuffer.canDisplay(file, roles, 2)) {
            if(file.isDirectory()) {
               scanMobileApp(request, appList, file, roles);
            } else {
               String url = FileUtil.getModulePath(file);
               JSONObject content = XwlBuffer.get(url, true);
               if(content != null) {
                  JSONObject viewport = getViewport(content);
                  if(viewport != null) {
                     viewport = viewport.getJSONObject("configs");
                     JSONObject item = new JSONObject();
                     String title = content.optString("title");
                     if(title.startsWith("Str.")) {
                        title = Str.format(request, title.substring(4), new Object[0]);
                     }

                     item.put("title", StringUtil.select(new String[]{title, file.getName()}));
                     String image = viewport.optString("appImage");
                     if(image.isEmpty()) {
                        String glyph = viewport.optString("appGlyph");
                        if(glyph.isEmpty()) {
                           item.put("glyph", "&#xf10a;");
                        } else {
                           item.put("glyph", StringUtil.concat(new String[]{"&#x", glyph, ";"}));
                        }
                     } else {
                        item.put("image", image);
                     }

                     item.put("url", url);
                     appList.add(item);
                  }
               }
            }
         }
      }

   }

   private static JSONObject getViewport(JSONObject rootNode) throws Exception {
      JSONObject module = (JSONObject)((JSONArray)rootNode.opt("children")).opt(0);
      JSONArray items = (JSONArray)module.opt("children");
      if(items == null) {
         return null;
      } else {
         int j = items.length();

         for(int i = 0; i < j; ++i) {
            JSONObject jo = (JSONObject)items.opt(i);
            if("tviewport".equals(jo.opt("type"))) {
               return jo;
            }
         }

         return null;
      }
   }
}
