package com.wb.interact;

import com.wb.common.Base;
import com.wb.compatible.CustomResponse;
import com.wb.tool.MgDataOutput;
import com.wb.tool.MgMailSend;
import com.wb.util.StringUtil;
import com.wb.util.WebUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.util.zip.GZIPInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class MgFilePush {

   public static void transfer(HttpServletRequest request, HttpServletResponse response) throws Exception {
      JSONObject metaParams = new JSONObject(request.getParameter("__metaParams"));
      String type = metaParams.optString("type");
      String to = metaParams.optString("to");
      String subject = metaParams.optString("subject");
      String content = metaParams.optString("content");
      String data = metaParams.optString("data", (String)null);
      JSONArray records;
      if(data == null) {
         CustomResponse resp = new CustomResponse(response);
         request.setAttribute("sys.rowOnly", Integer.valueOf(1));
         request.setAttribute("sys.fromExport", Integer.valueOf(1));
         WebUtil.include(request, resp, metaParams.optString("url"));
         String respText = getResponseString(resp);
         data = respText.substring(10, respText.length() - 11);
         JSONObject responseObject = new JSONObject(data);
         data = (String)responseObject.opt("value");
         records = (new JSONObject(data)).getJSONArray("rows");
      } else {
         records = new JSONArray(data);
      }

      JSONArray headers = metaParams.optJSONArray("headers");
      String title = metaParams.optString("title", (String)null);
      boolean neptune = metaParams.optBoolean("neptune");
      String filename = metaParams.optString("filename");
      if(StringUtil.isEmpty(filename)) {
         filename = "data";
      }

      String fileDatName = "VV_2162966_" + filename + "_1_FED_MSHX.dat";
      if(type.equals("dat")) {
         File finalXlsxPath = new File(Base.path, fileDatName);
         FileUtils.write(finalXlsxPath, MgDataOutput.outputDat(headers, records, filename), "UTF-8");
         response.reset();
         response.addHeader("Content-Length", "" + finalXlsxPath.length());
         response.setHeader("content-type", "application/force-download");
         response.setHeader("Content-Disposition", "attachment;" + WebUtil.encodeFilename(request, fileDatName));
         response.getOutputStream().write(FileUtils.readFileToByteArray(finalXlsxPath));
      }

      if(type.equals("all")) {
         String fileExtName = "VV_2162966_" + filename + "_1_FED_MSHX.xls";
         String finalXlsxPath1 = Base.path + File.separator + fileExtName;
         File datFile = new File(Base.path, fileDatName);
         MgDataOutput.outputExc(headers, records, title, neptune, "true".equals(WebUtil.fetch(request, "isAjax")), finalXlsxPath1, filename);
         FileUtils.write(datFile, MgDataOutput.outputDat(headers, records, filename), "UTF-8");
         String attachementFileList = fileExtName + "," + fileDatName;
         MgMailSend.mgMailSend(attachementFileList, to, subject, content);
      }

   }

   private static String getResponseString(CustomResponse response) throws Exception {
      byte[] data = response.getBytes();
      String result;
      if(data.length > 2 && data[0] == 31 && data[1] == -117) {
         GZIPInputStream is = new GZIPInputStream(new ByteArrayInputStream(data));

         try {
            result = StringUtil.getString(is);
         } finally {
            is.close();
         }
      } else {
         result = new String(data, "utf-8");
      }

      return result;
   }
}
