package com.wb.interact;

import com.wb.common.Base;
import com.wb.common.ScriptBuffer;
import com.wb.common.UrlBuffer;
import com.wb.common.Var;
import com.wb.interact.IDE;
import com.wb.tool.TaskManager;
import com.wb.util.DateUtil;
import com.wb.util.DbUtil;
import com.wb.util.FileUtil;
import com.wb.util.JsonUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Date;
import java.util.Iterator;
import java.util.Set;
import java.util.Map.Entry;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FileUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class Install {

   public static void checkInstall(HttpServletRequest request, HttpServletResponse response) throws Exception {
      if(!Var.getBool("sys.service.allowInstall")) {
         throw new RuntimeException("系统已经安装完成，如需重新安装请设置变量sys.service.allowInstall为true。");
      }
   }

   public static void generateJndi(HttpServletRequest request, HttpServletResponse response) throws Exception {
      checkInstall(request, response);
      String overwrite = request.getParameter("overwrite");
      if(overwrite == null) {
         throw new NullPointerException("overwrite 参数为null");
      } else {
         char dbType = request.getParameter("dbType").charAt(0);
         String contextFilename = null;
         String libFilename = null;
         switch(dbType) {
         case 109:
            contextFilename = "m-context.xml";
            libFilename = "mysql51.jar";
         case 110:
         case 112:
         case 113:
         case 114:
         default:
            break;
         case 111:
            contextFilename = "o-context.xml";
            libFilename = "ojdbc6.jar";
            break;
         case 115:
            contextFilename = "s-context.xml";
            libFilename = "sqljdbc4.jar";
         }

         File metaFolder = new File(Base.path, "META-INF");
         File contextFile = new File(metaFolder, "context.xml");
         if(!metaFolder.exists() && !metaFolder.mkdir()) {
            throw new IOException("创建META-INF目录失败。");
         } else {
            if(!Boolean.parseBoolean(overwrite) && contextFile.exists()) {
               SysUtil.error("文件 \"META-INF/context.xml\" 已经存在，确定要覆盖吗？", "106");
            }

            File rootFolder = Base.path.getParentFile().getParentFile();
            File libFolder = new File(rootFolder, "lib");
            if(!(new File(libFolder, libFilename)).exists()) {
               FileUtils.copyFileToDirectory(new File(Base.path, "wb/system/database/" + libFilename), libFolder);
            }

            String xml = FileUtil.readString(new File(Base.path, "wb/system/database/" + contextFilename));
            xml = WebUtil.replaceParams(request, xml);
            FileUtil.writeString(contextFile, xml);
            File syncFolder = new File(rootFolder, "conf/Catalina/localhost");
            if(!syncFolder.exists()) {
               syncFolder.mkdirs();
            }

            FileUtil.writeString(new File(syncFolder, Base.path.getName() + ".xml"), xml);
         }
      }
   }

   public static synchronized void getPack(HttpServletRequest request, HttpServletResponse response) throws Exception {
      getReleasePath();
      IDE.makeFile(request, Base.path, false);
      exportWBTables("r".equals(request.getParameter("type")));
      createPack(request, response);
   }

   private static void exportWBTables(boolean userRelease) throws Exception {
      Connection conn = null;
      Statement st = null;
      ResultSet rs = null;
      String[] withoutTables = new String[]{"WB_LOG", "WB_ROUTE", "WB_SN", "WB_SYS1", "WB_SYS2", "WB_VALUE"};
      String[] sqls = FileUtil.readString(new File(Base.path, "wb/system/database/sqls.sql")).split(";");
      File tablesPath = new File(Base.path, "wb/system/database/tables");
      File syncPath = FileUtil.getSyncPath(tablesPath);

      try {
         FileUtils.cleanDirectory(tablesPath);
         if(syncPath != null) {
            FileUtils.cleanDirectory(syncPath);
         }

         conn = DbUtil.getConnection();
         st = conn.createStatement();
         st.executeUpdate("update WB_USER set LOGIN_TIMES=0");
         String[] var16 = sqls;
         int var15 = sqls.length;

         for(int var14 = 0; var14 < var15; ++var14) {
            String sql = var16[var14];
            String upperSQL = sql.toUpperCase();
            int index = upperSQL.indexOf("CREATE TABLE");
            if(index != -1) {
               String tableName = sql.substring(index + 13, sql.indexOf(40)).trim();
               if(userRelease || StringUtil.indexOf(withoutTables, tableName) == -1) {
                  BufferedWriter writer = null;
                  rs = null;

                  try {
                     File destTable = new File(tablesPath, tableName + ".dat");
                     if(userRelease) {
                        rs = st.executeQuery("select * from " + tableName);
                     } else if(tableName.equals("WB_USER")) {
                        rs = st.executeQuery("select * from WB_USER where USER_ID in (\'admin\',\'test\')");
                     } else if(tableName.equals("WB_RESOURCE")) {
                        rs = st.executeQuery("select * from WB_RESOURCE where RES_ID in (\'desktop@admin\',\'desktop@test\')");
                     } else {
                        rs = st.executeQuery("select * from " + tableName);
                     }

                     writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(destTable), "utf-8"));
                     DbUtil.exportData(rs, writer);
                     writer.close();
                     writer = null;
                     if(syncPath != null) {
                        FileUtils.copyFileToDirectory(destTable, syncPath);
                     }
                  } finally {
                     if(writer != null) {
                        writer.close();
                     }

                     if(rs != null) {
                        rs.close();
                     }

                  }
               }
            }
         }
      } finally {
         DbUtil.close(rs);
         DbUtil.close(st);
         DbUtil.close(conn);
      }

   }

   public static void testJNDI(HttpServletRequest request, HttpServletResponse response) throws Exception {
      checkInstall(request, response);
      String jndi = request.getParameter("jndi");
      Var.set("sys.jndi.default", jndi);
      Var.jndi = jndi;
      DbUtil.getConnection().close();
   }

   public static void setup(HttpServletRequest request, HttpServletResponse response) throws Exception {
      checkInstall(request, response);
      String jndi = request.getParameter("jndiText");
      String type = request.getParameter("typeText");
      Var.set("sys.jndi.default", jndi);
      Var.jndi = jndi;
      if("postgresql".equals(type) && !"e".equals(Var.getString("sys.app.versionType"))) {
         throw new RuntimeException("postgresql数据库类型只有企业版本支持。");
      } else {
         Connection conn = null;
         Statement st = null;
         File mapJson = new File(Base.path, "wb/system/map.json");
         File tablePath = new File(Base.path, "wb/system/database/tables");

         try {
            JSONArray mapArray = JsonUtil.readArray(mapJson);
            JSONObject jo = new JSONObject();
            jo.put("var.json", FileUtil.readString(Var.file));
            FileUtil.syncSave(mapJson, mapArray.put(jo).toString());
            String[] sqls = replaceSQLMacro(FileUtil.readString(new File(Base.path, "wb/system/database/sqls.sql")), type).split(";");
            conn = DbUtil.getConnection();
            st = conn.createStatement();
            String[] var17 = sqls;
            int var16 = sqls.length;

            for(int var15 = 0; var15 < var16; ++var15) {
               String sql = var17[var15];
               int index = sql.indexOf("CREATE TABLE");
               if(index == -1) {
                  st.executeUpdate(sql.trim());
               } else {
                  String tableName = sql.substring(index + 13, sql.indexOf(40)).trim();

                  try {
                     st.executeUpdate("DROP TABLE " + tableName);
                  } catch (Throwable var22) {
                     ;
                  }

                  st.executeUpdate(sql.trim());
                  File file = new File(tablePath, StringUtil.concat(new String[]{tableName, ".dat"}));
                  if(file.exists()) {
                     DbUtil.importData(conn, tableName, new BufferedReader(new InputStreamReader(new FileInputStream(file), "utf-8")));
                  }
               }
            }
         } finally {
            DbUtil.close(st);
            DbUtil.close(conn);
         }

         Var.set("sys.db.defaultType", type);
         if("d".equals(Var.getString("sys.app.versionType"))) {
            Var.set("sys.portal", "demo-index");
            UrlBuffer.buffer.put("/", "sys/portal/demo-index.xwl");
         } else {
            Var.set("sys.portal", "index");
            UrlBuffer.put("/", "sys/portal/index.xwl");
         }

         Var.set("sys.service.allowInstall", Boolean.valueOf(false));
         SysUtil.reload(3);
         TaskManager.start();
      }
   }

   private static File getReleasePath() {
      String releasePathVar = Var.getString("sys.ide.releasePath");
      if(releasePathVar.isEmpty()) {
         throw new RuntimeException("发布目录变量 \"sys.ide.releasePath\" 未指定。");
      } else {
         File releasePath = new File(releasePathVar);
         if(!releasePath.exists()) {
            throw new RuntimeException("发布目录 \"" + releasePath + "\" 不存在。");
         } else {
            return releasePath;
         }
      }
   }

   private static void createPack(HttpServletRequest request, HttpServletResponse response) throws Exception {
      File releasePath = getReleasePath();
      String type = request.getParameter("type");
      boolean userReleaseVersion = "r".equals(type);
      File destPath = FileUtil.getUniqueFile(new File(releasePath, (userReleaseVersion?Var.getString("sys.app.title"):"wb7" + type) + "(" + DateUtil.format(new Date(), "yyyy-MM-dd") + ")"));
      File ssproto;
      if(userReleaseVersion) {
         File[] destWebInf = FileUtil.listFiles(Base.path);
         File[] var10 = destWebInf;
         int packJS = destWebInf.length;

         for(int packJSPath = 0; packJSPath < packJS; ++packJSPath) {
            ssproto = var10[packJSPath];
            FileUtils.copyDirectoryToDirectory(ssproto, destPath);
         }

         ssproto = new File(destPath, "wb/system/var.json");
         JSONObject var12 = JsonUtil.readObject(ssproto);
         ((JSONArray)JsonUtil.getValue(var12, "sys.db.defaultType", '.')).put(0, "");
         ((JSONArray)JsonUtil.getValue(var12, "sys.jndi.default", '.')).put(0, "");
         ((JSONArray)JsonUtil.getValue(var12, "sys.ide.releasePath", '.')).put(0, "");
         ((JSONArray)JsonUtil.getValue(var12, "sys.ide.syncPath", '.')).put(0, "");
         ((JSONArray)JsonUtil.getValue(var12, "sys.portal", '.')).put(0, "setup");
         ((JSONArray)JsonUtil.getValue(var12, "sys.service.allowInstall", '.')).put(0, true);
         FileUtil.writeString(ssproto, var12.toString(2));
      } else {
         File var11 = new File(destPath, "wb/WEB-INF");
         FileUtils.copyDirectoryToDirectory(new File(Base.path, "WEB-INF/lib"), var11);
         FileUtils.copyFileToDirectory(new File(Base.path, "WEB-INF/web.xml"), var11);
         FileUtils.copyDirectoryToDirectory(new File(Base.path, "wb"), new File(destPath, "wb"));
         FileUtils.copyDirectory(new File(Var.getString("sys.ide.sourcePath")), new File(destPath, "source"));
         FileUtils.copyFileToDirectory(new File(releasePath, "webbuilder-" + Var.getString("sys.app.version") + ".jar"), new File(destPath, "wb/WEB-INF/lib"));
         FileUtils.copyDirectoryToDirectory(new File(releasePath, "misc"), destPath);
         FileUtils.copyDirectoryToDirectory(new File(releasePath, "docs/docs"), destPath);
         FileUtils.copyFileToDirectory(new File(releasePath, "api.html"), destPath);
         FileUtils.copyFileToDirectory(new File(releasePath, "manual.docx"), destPath);
         FileUtils.copyFileToDirectory(new File(releasePath, "license.html"), destPath);
         FileUtils.copyFileToDirectory(new File(releasePath, "readme.html"), destPath);
         ssproto = new File(destPath, "wb/wb/system/database/ssproto.sql");
         if(!ssproto.delete()) {
            throw new RuntimeException("无法删除 \"" + ssproto + "\"。");
         }

         String var13 = "wb/wb/system/pack.js";
         File var14 = new File(destPath, var13);
         if(!var14.delete()) {
            throw new RuntimeException("无法删除 \"" + var14 + "\"。");
         }

         var13 = "wb/system/pack.js";
         var14 = new File(Base.path, var13);
         request.setAttribute("destPath", destPath);
         ScriptBuffer.run(var13, FileUtil.readString(var14), request, response, var13);
      }

      WebUtil.send(response, destPath);
   }

   private static String replaceSQLMacro(String sql, String dbType) throws Exception {
      JSONObject object = JsonUtil.readObject(new File(Base.path, "wb/system/database/types.json"));
      JSONObject items = object.getJSONObject(dbType);
      Set es = items.entrySet();

      Entry entry;
      for(Iterator var6 = es.iterator(); var6.hasNext(); sql = StringUtil.replaceAll(sql, "{#" + (String)entry.getKey() + "#}", entry.getValue().toString())) {
         entry = (Entry)var6.next();
      }

      return sql;
   }

   public static void register(HttpServletRequest request, HttpServletResponse response) throws Exception {
      Var.set("sys.app.licensee", request.getParameter("licText"));
      Var.set("sys.app.serialNumber", request.getParameter("snText"));
   }

   public static void verify(HttpServletRequest request, HttpServletResponse response) throws Exception {
      String sn;
      String msg;
      try {
         sn = request.getParameter("snText");
         msg = WebUtil.submit("http://www.putdb.com/sn-verify", (new JSONObject()).put("sn", sn));
      } catch (Throwable var5) {
         throw new RuntimeException("验证失败，网络无效或服务暂时不可访问。");
      }

      if(!"ok".equals(msg)) {
         throw new RuntimeException("验证失败，序列号 “" + sn + "” 无效。");
      }
   }
}
