package com.wb.interact;

import com.wb.common.Base;
import com.wb.common.Var;
import com.wb.util.DbUtil;
import com.wb.util.JsonUtil;
import com.wb.util.SortUtil;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Map.Entry;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public class DBE {

   public static void getTree(HttpServletRequest request, HttpServletResponse response) throws Exception {
      String jndi = request.getParameter("jndi");
      boolean hasSchem = Boolean.parseBoolean(request.getParameter("hasSchem"));
      WebUtil.send(response, StringUtil.isEmpty(jndi)?getDbList():getTableList(jndi, hasSchem, (HashSet)null));
   }

   public static void checkSelectSql(HttpServletRequest request, HttpServletResponse response) throws Exception {
      String sql = request.getParameter("sql");
      String[] roles = (String[])WebUtil.fetchObject(request, "sys.roles");
      if(StringUtil.indexOf(roles, "demo") != -1 && StringUtil.indexOf(roles, "admin") == -1 && (!sql.startsWith("select * from ") || !StringUtil.checkName(sql.substring(14), true) || sql.substring(14).equalsIgnoreCase("WB_USER"))) {
         SysUtil.accessDenied();
      }

   }

   public static String getDbList() throws Exception {
      JSONObject config = JsonUtil.readObject(new File(Base.path, "wb/system/var.json"));
      HashMap map = new HashMap();
      config = config.optJSONObject("sys").optJSONObject("jndi");
      Set es = config.entrySet();
      JSONArray ja = new JSONArray();
      config.remove("default");
      Iterator var8 = es.iterator();

      Entry e;
      while(var8.hasNext()) {
         e = (Entry)var8.next();
         String key = (String)e.getKey();
         map.put(key, ((JSONArray)e.getValue()).optString(0));
      }

      ArrayList sortedItems = SortUtil.sortKey(map);
      JSONObject jo = new JSONObject();
      jo.put("text", "default");
      jo.put("jndi", "default");
      jo.put("iconCls", "db_icon");
      ja.put(jo);
      var8 = sortedItems.iterator();

      while(var8.hasNext()) {
         e = (Entry)var8.next();
         jo = new JSONObject();
         jo.put("text", e.getKey());
         jo.put("jndi", e.getKey());
         jo.put("iconCls", "db_icon");
         ja.put(jo);
      }

      return ja.toString();
   }

   public static String getTableList(String jndi, boolean hasSchem, HashSet tables) throws Exception {
      Connection conn = null;
      Statement st = null;
      ResultSet rs = null;
      boolean isFirst = true;
      boolean hasTableDefine = tables != null;
      String[] types = new String[]{"TABLE"};
      StringBuilder buf = new StringBuilder();
      HashMap tableMap = new HashMap();

      String var20;
      try {
         conn = DbUtil.getConnection(jndi);
         boolean isOracle = Var.getBool("sys.db.oracleUserTable") && conn.getMetaData().getDatabaseProductName().toLowerCase().indexOf("oracle") != -1;
         if(isOracle) {
            st = conn.createStatement();
            rs = st.executeQuery("select user from dual");
            rs.next();
            String user = rs.getString(1);
            rs.close();
            rs = st.executeQuery("select TABLE_NAME,\'" + user + "\' from user_tables");
         } else {
            rs = conn.getMetaData().getTables((String)null, (String)null, (String)null, types);
         }

         String tableSchem;
         String tableName;
         for(; rs.next(); tableMap.put(tableName, tableSchem)) {
            if(isOracle) {
               tableName = rs.getString(1);
               tableSchem = StringUtil.opt(rs.getString(2));
            } else {
               tableSchem = StringUtil.opt(rs.getString(2));
               tableName = rs.getString(3);
            }
         }

         ArrayList sortedEntries = SortUtil.sortKey(tableMap);
         buf.append('[');
         Iterator var18 = sortedEntries.iterator();

         while(var18.hasNext()) {
            Entry fullName = (Entry)var18.next();
            if(isFirst) {
               isFirst = false;
            } else {
               buf.append(',');
            }

            tableName = (String)fullName.getKey();
            tableSchem = (String)fullName.getValue();
            buf.append("{\"text\":\"");
            if(hasSchem && !StringUtil.isEmpty(tableSchem)) {
               buf.append(tableSchem);
               buf.append('.');
            }

            buf.append(tableName);
            buf.append("\",\"table\":\"");
            buf.append(tableName);
            buf.append("\",\"schem\":\"");
            buf.append(tableSchem);
            buf.append("\",\"leaf\":true,\"iconCls\":\"");
            String upperTableName = tableName.toUpperCase();
            if(hasTableDefine && tables.contains(upperTableName)) {
               tables.remove(upperTableName);
               buf.append("table_add_icon\"}");
            } else {
               buf.append("table_icon\"}");
            }
         }

         if(hasTableDefine) {
            var18 = tables.iterator();

            while(var18.hasNext()) {
               String fullName1 = (String)var18.next();
               if(isFirst) {
                  isFirst = false;
               } else {
                  buf.append(',');
               }

               buf.append("{\"text\":\"");
               buf.append(fullName1);
               buf.append("\",\"table\":\"");
               buf.append(fullName1);
               buf.append("\",\"schem\":\"\",\"leaf\":true,\"iconCls\":\"table_delete_icon\"}");
            }
         }

         buf.append(']');
         var20 = buf.toString();
      } finally {
         DbUtil.close(rs);
         DbUtil.close(st);
         DbUtil.close(conn);
      }

      return var20;
   }

   public static void downloadBlob(HttpServletRequest request, HttpServletResponse response) throws Exception {
      String jndi = request.getParameter("__jndi");
      String tableName = request.getParameter("__tableName");
      String fieldName = request.getParameter("__fieldName");
      String selectSql = DbUtil.buildSQLsWb(jndi, tableName, false, 1, (HttpServletRequest)null, (new JSONObject()).put(fieldName, 1), (JSONObject)null, (JSONObject)null)[3];
      ResultSet rs = (ResultSet)DbUtil.run(request, selectSql, jndi);
      DbUtil.outputBlob(rs, request, response, "download");
   }

   public static void uploadBlob(HttpServletRequest request, HttpServletResponse response) throws Exception {
      setBlob(request, false);
   }

   public static void clearBlob(HttpServletRequest request, HttpServletResponse response) throws Exception {
      setBlob(request, true);
   }

   private static void setBlob(HttpServletRequest request, boolean isClear) throws Exception {
      String jndi = WebUtil.fetch(request, "__jndi");
      String tableName = WebUtil.fetch(request, "__tableName");
      String fieldName = WebUtil.fetch(request, "__fieldName");
      if(isClear) {
         request.setAttribute(fieldName, "");
      } else {
         request.setAttribute(fieldName, request.getAttribute("file"));
      }

      String updateSql = DbUtil.buildSQLsWb(jndi, tableName, false, 1, (HttpServletRequest)null, (new JSONObject()).put(fieldName, 1), (JSONObject)null, (JSONObject)null)[1];
      DbUtil.run(request, updateSql, jndi);
   }
}
