package com.wb.controls;

import com.wb.controls.Control;
import com.wb.tool.DataProvider;
import com.wb.util.DbUtil;
import com.wb.util.StringUtil;
import com.wb.util.WebUtil;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Map.Entry;
import org.json.JSONArray;
import org.json.JSONObject;

public class DpControl extends Control {

   public void create() throws Exception {
      this.getContent(true);
   }

   public String getContent(boolean directOutput) throws Exception {
      if(this.gb("disabled", false)) {
         return null;
      } else {
         long startTime = System.currentTimeMillis();
         Long totalCount = null;
         String jndi = this.gs("jndi");
         String limitRecords = this.gs("limitRecords");
         String limitExportRecords = this.gs("limitExportRecords");
         String startParam = this.request.getParameter("start");
         String limitParam = this.request.getParameter("limit");
         String type = this.gs("type");
         if(StringUtil.isEmpty(type) || "array".equals(type)) {
            this.setOrderVars();
         }

         String sql = this.gs("sql");
         String totalSql = this.gs("totalSql");
         long beginIndex;
         if(StringUtil.isEmpty(startParam)) {
            beginIndex = 1L;
            this.request.setAttribute("start", Long.valueOf(0L));
         } else {
            beginIndex = Long.parseLong(startParam) + 1L;
         }

         long endIndex;
         if(StringUtil.isEmpty(limitParam)) {
            endIndex = Long.MAX_VALUE;
            this.request.setAttribute("limit", Long.valueOf(endIndex));
         } else {
            endIndex = beginIndex + Long.parseLong(limitParam) - 1L;
         }

         this.request.setAttribute("beginIndex", Long.valueOf(beginIndex));
         this.request.setAttribute("endIndex", Long.valueOf(endIndex));
         Object result = this.getResult(DbUtil.run(this.request, sql, jndi));
         if(result instanceof ResultSet) {
            ResultSet resultSet = (ResultSet)result;
            if(!StringUtil.isEmpty(totalSql)) {
               Object totalResult = this.getResult(DbUtil.run(this.request, totalSql, jndi));
               if(totalResult == null) {
                  throw new NullPointerException("No value in the totalSql.");
               }

               if(totalResult instanceof ResultSet) {
                  ResultSet totalResultSet = (ResultSet)totalResult;
                  if(!totalResultSet.next()) {
                     throw new NullPointerException("Empty total ResultSet.");
                  }

                  totalCount = Long.valueOf(Long.parseLong(totalResultSet.getString(1)));
               } else {
                  totalCount = Long.valueOf(Long.parseLong(totalResult.toString()));
               }
            }

            DataProvider dp = new DataProvider();
            dp.startTime = startTime;
            dp.request = this.request;
            dp.response = this.response;
            dp.resultSet = resultSet;
            dp.fields = this.gs("fields");
            dp.fieldsTag = this.gs("fieldsTag");
            dp.keyDefines = this.gs("keyDefines");
            dp.totalCount = totalCount;
            dp.createColumns = this.gb("createColumns", true);
            if(this.gb("autoPage", true)) {
               dp.beginIndex = beginIndex;
               dp.endIndex = endIndex;
            }

            if(!limitRecords.isEmpty()) {
               dp.limitRecords = Integer.valueOf(Integer.parseInt(limitRecords));
            }

            if(!limitExportRecords.isEmpty()) {
               dp.limitExportRecords = Integer.valueOf(Integer.parseInt(limitExportRecords));
            }

            dp.tag = this.gs("tag");
            dp.type = type;
            String dictTableNames = this.gs("dictTableNames");
            dp.createKeyValues = this.gb("createKeyValues", false);
            if(dictTableNames.isEmpty()) {
               dp.dictTableNames = null;
            } else {
               dp.dictTableNames = StringUtil.split(dictTableNames, ',', true);
            }

            dp.dictFieldsMap = this.gs("dictFieldsMap");
            if(directOutput) {
               dp.output();
               return null;
            } else {
               return dp.getScript();
            }
         } else {
            String text = StringUtil.concat(new String[]{"{\"total\":1,\"metaData\":{\"fields\":[{\"name\":\"result\",\"type\":\"string\"}]},\"columns\":[{\"xtype\":\"rownumberer\",\"width\":40},{\"dataIndex\":\"result\",flex:1,\"text\":\"result\"}],\"rows\":[{\"result\":", result == null?"null":StringUtil.quote(result.toString()), "}],\"elapsed\":", Long.toString(System.currentTimeMillis() - startTime), "}"});
            if(directOutput) {
               WebUtil.send(this.response, text);
               return null;
            } else {
               return text;
            }
         }
      }
   }

   private Object getResult(Object result) {
      if(result instanceof HashMap) {
         HashMap map = (HashMap)result;
         Set es = map.entrySet();
         String itemId = StringUtil.select(new String[]{this.gs("itemId")});

         Entry entry;
         String name;
         Object val;
         for(Iterator var8 = es.iterator(); var8.hasNext(); this.request.setAttribute(name, entry.getValue())) {
            val = var8.next();
            entry = (Entry)val;
            name = (String)entry.getKey();
            if(name.equals("return")) {
               name = itemId;
            } else if(!itemId.isEmpty()) {
               name = StringUtil.concat(new String[]{itemId, ".", name});
            }
         }

         val = map.get(StringUtil.select(new String[]{this.gs("resultName"), "result"}));
         if(val == null) {
            return map.get("return");
         } else {
            return val;
         }
      } else {
         return result;
      }
   }

   private void setOrderVars() throws Exception {
      String sort = this.request.getParameter("sort");
      if(!StringUtil.isEmpty(sort) && this.request.getAttribute("sql.orderBy") == null) {
         JSONArray ja = new JSONArray(sort);
         int j = ja.length();
         if(j > 0) {
            StringBuilder exp = new StringBuilder();
            int order = 0;
            String direction = "";
            String orderFields = this.gs("orderFields");
            String defaultPrefix;
            JSONObject orderJo;
            if(StringUtil.isEmpty(orderFields)) {
               orderJo = null;
               defaultPrefix = null;
            } else {
               orderJo = new JSONObject(orderFields);
               defaultPrefix = orderJo.optString("default", (String)null);
            }

            for(int i = 0; i < j; ++i) {
               JSONObject jo = ja.getJSONObject(i);
               if(i > 0) {
                  exp.append(',');
               }

               String property = jo.getString("property");
               if(jo.has("sorterIndex")) {
                  order = jo.getInt("sorterIndex");
               }

               if(orderJo != null) {
                  if(orderJo.has(property)) {
                     String prefix = orderJo.optString(property);
                     if(!prefix.isEmpty()) {
                        exp.append(prefix);
                        exp.append('.');
                     }
                  } else if(defaultPrefix != null) {
                     exp.append(defaultPrefix);
                     exp.append('.');
                  }
               }

               exp.append(property);
               direction = jo.optString("direction");
               if(StringUtil.isSame(direction, "desc")) {
                  exp.append(" desc");
               }
            }

            this.request.setAttribute("I_ORDER_BY", Integer.valueOf(order));
            this.request.setAttribute("I_ORDER_DIR", direction);
            this.request.setAttribute("sql.orderBy", " order by " + exp);
            this.request.setAttribute("sql.orderFields", "," + exp);
         }

      }
   }
}
