package com.rw.service;

import com.rw.dao.FileDAO;
import com.rw.model.FileModel;
import com.rw.service.FileService;
import com.wb.common.Base;
import com.xiaoleilu.hutool.io.FileUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("fileService")
public class FileServiceImpl implements FileService {

   @Autowired
   private FileDAO fileDAO;


   public List getFilePath(String sql) throws Exception {
      return this.fileDAO.getFiles(sql);
   }

   public List getFilePathByObjectId(String objectId) throws Exception {
      List fileModels = this.fileDAO.getFilesByObjectId(objectId);
      ArrayList fileNames = null;
      String fileName = null;
      File file = null;
      if(fileModels != null && fileModels.size() > 0) {
         fileNames = new ArrayList(fileModels.size());

         for(Iterator var7 = fileModels.iterator(); var7.hasNext(); fileNames.add(fileName)) {
            FileModel fileModel = (FileModel)var7.next();
            fileName = "wb" + File.separatorChar + "template" + File.separatorChar + "tempFile" + File.separatorChar + fileModel.getName();
            file = new File(System.getProperty("java.io.tmpdir"), fileModel.getId());
            File destFile = new File(Base.path, fileName);
            if(fileModel.getFileSize().longValue() > 0L) {
               FileUtil.copy(file, destFile, true);
            } else {
               FileUtil.writeString("", destFile, "UTF-8");
            }
         }
      }

      return fileNames;
   }

   public String getFilePathById(String id) throws Exception {
      FileModel fileModel = this.fileDAO.getFilesById(id);
      String fileName = null;
      File file = null;
      if(fileModel != null) {
         fileName = "wb" + File.separatorChar + "template" + File.separatorChar + "tempFile" + File.separatorChar + fileModel.getName();
         file = new File(System.getProperty("java.io.tmpdir"), fileModel.getId());
         File destFile = FileUtil.file(Base.path, fileName);
         if(fileModel.getFileSize().longValue() > 0L) {
            FileUtil.copy(file, destFile, true);
         } else {
            FileUtil.writeString("", destFile, "UTF-8");
         }

         return fileName;
      } else {
         return null;
      }
   }
}
