package com.rw.service;

import com.rw.annotation.SystemServiceLog;
import com.rw.dao.BaseDAO;
import com.rw.dao.ExcelDao;
import com.rw.model.excel.Col2Field;
import com.rw.model.excel.ExcelTemplate;
import com.rw.model.sp.Procedure;
import com.rw.model.sp.ProcedureArgument;
import com.rw.service.ExcelService;
import com.rw.util.ExcelKit;
import com.rw.util.ExpressionKit;
import com.wb.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service("excelService")
public class ExcelServiceImpl implements ExcelService {

   @Autowired
   private ExcelDao excelDao;
   @Autowired
   private BaseDAO baseDAO;


   @SystemServiceLog(
      description = "获取Excel模板信息"
   )
   public List getTemplateInfo(String modelCode) throws RuntimeException {
      ArrayList excelTemplateList = new ArrayList();
      String templateManageSql = "select t.template_id, t.template_name,t.template_tb_name,t.start_rows_num,t.end_rows_num,t.start_exec_sp,t.end_exec_sp,t.template_flag,t.template_sheet_name from  t_import_template_manage t where t.template_code=?";
      HashMap codeParams = new HashMap();
      codeParams.put("template_code", modelCode);
      List list = this.baseDAO.findList(templateManageSql, new Object[]{modelCode});
      if(list.size() > 0) {
         ExcelTemplate excelTemplate = new ExcelTemplate();
         Map map = (Map)list.get(0);
         int templateFlag = Integer.parseInt(ObjectUtils.toString(map.get("template_flag".toUpperCase())));
         String templateId = (String)map.get("template_id".toUpperCase());
         if(templateFlag != 3) {
            excelTemplate.setTemplateId(templateId);
            excelTemplate.setTemplateName((String)map.get("template_name".toUpperCase()));
            excelTemplate.setTemplateTbName((String)map.get("template_tb_name".toUpperCase()));
            excelTemplate.setStartRowsNum(Integer.parseInt(ObjectUtils.toString(map.get("start_rows_num".toUpperCase()), "0")));
            excelTemplate.setEndRowsNum(Integer.parseInt(ObjectUtils.toString(map.get("end_rows_num".toUpperCase()), "0")));
            excelTemplate.setTemplateFlag(templateFlag);
            excelTemplate.setTemplateSheetName((String)map.get("template_sheet_name".toUpperCase()));
            excelTemplateList.add(excelTemplate);
         } else {
            templateManageSql = "select t.template_id, t.template_name,t.template_tb_name,t.start_rows_num,t.end_rows_num,t.start_exec_sp,t.end_exec_sp,t.template_flag,t.template_sheet_name from  t_import_template_manage t where t.parent_id= ? order by template_sort";
            HashMap params = new HashMap();
            params.put("parent_id", templateId);
            list = this.baseDAO.findList(templateManageSql, new Object[]{templateId});
            Iterator var12 = list.iterator();

            while(var12.hasNext()) {
               Map m = (Map)var12.next();
               ExcelTemplate et = new ExcelTemplate();
               et.setTemplateId((String)m.get("template_id".toUpperCase()));
               et.setTemplateName((String)m.get("template_name".toUpperCase()));
               et.setTemplateTbName((String)m.get("template_tb_name".toUpperCase()));
               et.setStartRowsNum(Integer.parseInt(m.get("start_rows_num".toUpperCase()).toString()));
               et.setEndRowsNum(Integer.parseInt(ObjectUtils.toString(m.get("end_rows_num".toUpperCase()), "0")));
               et.setTemplateFlag(Integer.parseInt(ObjectUtils.toString(m.get("template_flag".toUpperCase()))));
               et.setTemplateSheetName((String)m.get("template_sheet_name".toUpperCase()));
               excelTemplateList.add(et);
            }
         }
      }

      return excelTemplateList;
   }

   private List getCol2FieldList(String templateId) throws RuntimeException {
      String templateFields = "select f.col_text,f.col_name,f.xls_col,f.field_type,f.default_value,f.template_sort,f.empty_is_imp from t_import_template_fields f where f.template_id=? and f.is_selected=1 order by template_sort";
      HashMap idParams = new HashMap();
      idParams.put("template_id", templateId);
      List list = this.baseDAO.findList(templateFields, new Object[]{templateId});
      ArrayList col2FieldList = new ArrayList(list.size());

      for(int i = 0; i < list.size(); ++i) {
         Map map = (Map)list.get(i);
         Col2Field model = new Col2Field();
         model.setColName(ObjectUtils.toString(map.get("col_name".toUpperCase())));
         model.setColText(ObjectUtils.toString(map.get("col_text".toUpperCase())));
         model.setFieldType(ObjectUtils.toString(map.get("field_type".toUpperCase())));
         model.setDefaultValue(ObjectUtils.toString(map.get("default_value".toUpperCase())));
         model.setEmptyIsImp(StringUtil.getBoolA(ObjectUtils.toString(map.get("empty_is_imp".toUpperCase()))).booleanValue());
         String xls_col = ObjectUtils.toString(map.get("XLS_COL"));
         model.setXlsCol(xls_col);
         if(StringUtils.isNotBlank(xls_col)) {
            model.setFieldIndex(ExcelKit.columnToIndex(xls_col) - 1);
         } else {
            String inds = ObjectUtils.toString(map.get("template_sort".toUpperCase()), "0");
            model.setFieldIndex(Integer.parseInt(inds));
         }

         col2FieldList.add(model);
      }

      return col2FieldList;
   }

   private ExcelTemplate getExcelTemplate(Map map, Map reqParasMap) throws RuntimeException {
      ExcelTemplate excelTemplate = null;
      if(map != null) {
         excelTemplate = new ExcelTemplate();
         excelTemplate.setTemplateId((String)map.get("template_id".toUpperCase()));
         excelTemplate.setTemplateName((String)map.get("template_name".toUpperCase()));
         excelTemplate.setTemplateTbName((String)map.get("template_tb_name".toUpperCase()));
         excelTemplate.setStartRowsNum(Integer.parseInt(ObjectUtils.toString(map.get("start_rows_num".toUpperCase()), "0")));
         excelTemplate.setEndRowsNum(Integer.parseInt(ObjectUtils.toString(map.get("end_rows_num".toUpperCase()), "0")));
         excelTemplate.setTemplateFlag(Integer.parseInt(ObjectUtils.toString(map.get("template_flag".toUpperCase()), "0")));
         excelTemplate.setTemplateSheetName((String)map.get("template_sheet_name".toUpperCase()));
         String startSp = ObjectUtils.toString(map.get("start_exec_sp".toUpperCase()), (String)null);
         if(StringUtils.isNotBlank(startSp)) {
            excelTemplate.setStartExecSp(this.parseSP(startSp, reqParasMap));
         }

         String endSp = ObjectUtils.toString(map.get("end_exec_sp".toUpperCase()), (String)null);
         if(StringUtils.isNotBlank(endSp)) {
            excelTemplate.setEndExecSp(this.parseSP(endSp, reqParasMap));
         }

         excelTemplate.setCol2FieldList(this.getCol2FieldList(excelTemplate.getTemplateId()));
      }

      return excelTemplate;
   }

   @SystemServiceLog(
      description = "serivce层导入Excel"
   )
   public Map importExcel(String modelCode, Map reqParasMap) throws RuntimeException {
      LinkedHashMap excelTemplateMap = new LinkedHashMap();
      String templateManageSql = "select t.template_id, t.template_name,t.template_tb_name,t.start_rows_num,t.end_rows_num,t.start_exec_sp,t.end_exec_sp,t.template_flag,t.template_sheet_name from  t_import_template_manage t where t.template_code=? ";
      HashMap codeParams = new HashMap();
      codeParams.put("template_id", modelCode);
      List list = this.baseDAO.findList(templateManageSql, new Object[]{modelCode});
      if(list.size() > 0) {
         Map map = (Map)list.get(0);
         int templateFlag = Integer.parseInt(ObjectUtils.toString(map.get("template_flag".toUpperCase()), "0"));
         if(templateFlag != 3) {
            ExcelTemplate templateId = this.getExcelTemplate(map, reqParasMap);
            excelTemplateMap.put(templateId.getTemplateSheetName(), templateId);
         } else {
            String templateId1 = (String)map.get("template_id".toUpperCase());
            templateManageSql = "select t.template_id, t.template_name,t.template_tb_name,t.start_rows_num,t.end_rows_num,t.start_exec_sp,t.end_exec_sp,t.template_flag,t.template_sheet_name from  t_import_template_manage t where t.parent_id=? order by t.template_sort";
            HashMap tempParams = new HashMap();
            tempParams.put("template_id", templateId1);
            list = this.baseDAO.findList(templateManageSql, new Object[]{templateId1});
            Iterator var12 = list.iterator();

            while(var12.hasNext()) {
               Map m = (Map)var12.next();
               ExcelTemplate excelTemplate = this.getExcelTemplate(m, reqParasMap);
               if(excelTemplateMap.containsKey(excelTemplate.getTemplateSheetName())) {
                  excelTemplateMap.put(excelTemplate.getTemplateSheetName() + "&|+|&" + excelTemplate.getTemplateName(), excelTemplate);
               } else {
                  excelTemplateMap.put(excelTemplate.getTemplateSheetName(), excelTemplate);
               }
            }
         }
      }

      return excelTemplateMap;
   }

   @SystemServiceLog(
      description = "批量执行插入sql语句"
   )
   @Transactional
   public int insertBatch(List batchSql) throws RuntimeException {
      return this.excelDao.batchUpdateSql(batchSql);
   }

   @SystemServiceLog(
      description = "执行导入Excel的sp"
   )
   public Map importExcel4SP(String sp, List spaList) throws RuntimeException {
      Map spResult = this.baseDAO.querySp(sp, spaList);
      return spResult;
   }

   private Procedure parseSP(String sp, Map reqParasMap) throws RuntimeException {
      int firstIndex = StringUtils.indexOf(sp, "{");
      int endIndex = StringUtils.lastIndexOf(sp, "}");
      String paramStr = StringUtils.substring(sp, firstIndex + 1, endIndex);
      Procedure pd = new Procedure();
      if(StringUtils.isNotEmpty(paramStr)) {
         String[] startParams = paramStr.split(";");
         int paramsLength = startParams.length;
         pd.setProceSql(sp.substring(0, sp.indexOf("{")));
         if(paramsLength > 0) {
            ArrayList paList = new ArrayList(paramsLength);

            for(int i = 0; i < paramsLength; ++i) {
               String[] param = startParams[i].split(",");
               if(param.length == 4) {
                  ProcedureArgument pa = new ProcedureArgument();
                  if(Integer.parseInt(param[0]) == 0) {
                     pa.setDirection("in");
                     pa.setIndex(Integer.parseInt(param[1]));
                     pa.setDefaultValue(ExpressionKit.replaceParas(param[2], reqParasMap));
                     pa.setDataType(Integer.valueOf(Integer.parseInt(param[3])));
                     paList.add(pa);
                  } else if(Integer.parseInt(param[0]) == 1) {
                     pa.setDirection("out");
                     pa.setIndex(Integer.parseInt(param[1]));
                     pa.setArgName(param[2]);
                     pa.setDataType(Integer.valueOf(Integer.parseInt(param[3])));
                     paList.add(pa);
                  }
               }
            }

            pd.setProcedureArguments(paList);
         }
      } else {
         pd.setProceSql(sp.substring(0, sp.indexOf("{")));
      }

      return pd;
   }

   public String getTemplateFilePath(String modelCode) throws RuntimeException {
      String templateManageSql = "SELECT T.TEMPLATE_ID, T.TEMPLATE_NAME,T.TEMPLATE_TB_NAME,T.START_ROWS_NUM,T.END_ROWS_NUM,T.START_EXEC_SP,T.END_EXEC_SP,T.TEMPLATE_FLAG,T.TEMPLATE_SHEET_NAME,T.TEMPLATE_FILE_PATH FROM  T_IMPORT_TEMPLATE_MANAGE T WHERE T.TEMPLATE_CODE=? ";
      HashMap codeParams = new HashMap();
      codeParams.put("template_id", modelCode);
      Map one = this.baseDAO.findOne(templateManageSql, new Object[]{modelCode});
      return one != null?ObjectUtils.toString(one.get("TEMPLATE_FILE_PATH"), (String)null):null;
   }
}
