package com.rw.model.excel;

import com.rw.model.excel.NumberFormat;
import com.rw.model.excel.XRow;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class XSheet {

   private String label;
   private int defaultRowHeight;
   private int defaultCellWidth;
   private int maxColNum;
   private List rowList = new ArrayList();


   public int getMaxColNum() {
      return this.maxColNum;
   }

   public void setMaxColNum(int maxColNum) {
      this.maxColNum = maxColNum;
   }

   public int getDefaultRowHeight() {
      return this.defaultRowHeight;
   }

   public void setDefaultRowHeight(int defaultRowHeight) {
      this.defaultRowHeight = defaultRowHeight;
   }

   public int getDefaultCellWidth() {
      return this.defaultCellWidth;
   }

   public void setDefaultCellWidth(int defaultCellWidth) {
      this.defaultCellWidth = defaultCellWidth;
   }

   public String getLabel() {
      return this.label;
   }

   public void setLabel(String label) {
      this.label = label;
   }

   public List getRowList() {
      return this.rowList;
   }

   public void setRowList(List rowList) {
      this.rowList = rowList;
   }

   public String toHtml() {
      StringBuffer stringBuffer = new StringBuffer();
      stringBuffer.append("<table class=\'table table-striped table-hover\'>\r\n");

      for(int row = 0; row <= this.maxColNum; ++row) {
         stringBuffer.append("<th colIndex=\'" + (row - 1) + "\'>" + NumberFormat.format(row) + "</th>");
      }

      Iterator var3 = this.rowList.iterator();

      while(var3.hasNext()) {
         XRow var4 = (XRow)var3.next();
         stringBuffer.append(var4.toHtml());
      }

      stringBuffer.append("</table>");
      return stringBuffer.toString();
   }

   public String toHtml(int startRowNum) {
      StringBuffer stringBuffer = new StringBuffer();
      stringBuffer.append("<table class=\'table table-striped table-hover\'>\r\n");

      int i;
      for(i = 0; i <= this.maxColNum; ++i) {
         stringBuffer.append("<th colIndex=\'" + (i - 1) + "\'>" + NumberFormat.format(i) + "</th>");
      }

      if(startRowNum < this.rowList.size()) {
         for(i = startRowNum; i < this.rowList.size(); ++i) {
            stringBuffer.append(((XRow)this.rowList.get(i)).toHtml());
         }
      }

      stringBuffer.append("</table>");
      return stringBuffer.toString();
   }

   public static void main(String[] a) {
      String re = NumberFormat.format(27);
      System.out.println(re);
   }
}
