package com.rw.major.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class FileUtil {

   public static String getFileContent(String filePath, String encoding) {
      if(filePath != null && !StringUtils.isBlank(filePath)) {
         File file = new File(filePath);
         if(!file.exists()) {
            return null;
         } else {
            if(encoding == null || StringUtils.isBlank(encoding)) {
               encoding = "utf-8";
            }

            StringBuffer str = new StringBuffer();
            BufferedReader reader = null;

            try {
               FileInputStream e = new FileInputStream(file);
               InputStreamReader isr = new InputStreamReader(e, encoding);
               reader = new BufferedReader(isr);
               String tempString = null;

               while((tempString = reader.readLine()) != null) {
                  str.append(tempString);
               }

               reader.close();
            } catch (IOException var16) {
               var16.printStackTrace();
            } finally {
               if(reader != null) {
                  try {
                     reader.close();
                  } catch (IOException var15) {
                     ;
                  }
               }

            }

            return str.toString();
         }
      } else {
         return null;
      }
   }

   public static List paser(String fileContent, String regex) {
      byte flag = 0;
      int var8 = flag | 2;
      var8 |= 8;
      var8 |= 32;
      Pattern p = Pattern.compile(regex, var8);
      Matcher m = p.matcher(fileContent);
      ArrayList rtn = new ArrayList();

      while(m.find()) {
         ArrayList list = new ArrayList();

         for(int i = 1; i <= m.groupCount(); ++i) {
            list.add(m.group(i));
         }

         rtn.add(list);
      }

      return rtn;
   }
}
