package com.rw.major.util;

import com.rw.major.model.nonsence.AbroadBranchBean;
import com.rw.major.model.nonsence.AdministrativeInvestigationBean;
import com.rw.major.model.nonsence.BaseInfo1Bean;
import com.rw.major.model.nonsence.BaseInfo2Bean;
import com.rw.major.model.nonsence.CustomerRecognitionBean;
import com.rw.major.model.nonsence.InnerCtrlBean;
import com.rw.major.model.nonsence.InternalInspectionBean;
import com.rw.major.model.nonsence.LargeAndSuspiciousDetailBean;
import com.rw.major.model.nonsence.PostPerson1Bean;
import com.rw.major.model.nonsence.PostPerson2Bean;
import com.rw.major.model.nonsence.PropagandaBean;
import com.rw.major.model.nonsence.RiskCtrlBean;
import com.rw.major.model.nonsence.SiteInspectionBean;
import com.rw.major.model.nonsence.TrainBean;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public class FileDownWorkbookUtil {

   public static void fillCellValue(HSSFSheet sheet, int rowno, int colno, String value) {
      HSSFRow row = sheet.getRow(rowno);
      if(row == null) {
         row = sheet.createRow(rowno);
      }

      HSSFCell cell = row.getCell(colno);
      if(cell == null) {
         cell = row.createCell(colno);
      }

      if(value == null) {
         value = "";
      }

      cell.setCellValue(value);
   }

   public static Workbook createBaseInfoWorkbook(String classpath, BaseInfo1Bean b1, List b2) {
      HSSFWorkbook wb = null;
      String filepath = classpath + File.separator + "excelTemplate" + File.separator + "baseInfoReport2015.xls";

      try {
         FileInputStream e = new FileInputStream(filepath);
         wb = new HSSFWorkbook(e);
         HSSFSheet sheet = wb.getSheetAt(0);
         fillBaseInfoSheet(sheet, b1, b2);
         e.close();
      } catch (IOException var7) {
         var7.printStackTrace();
      }

      return wb;
   }

   public static void fillBaseInfoSheet(HSSFSheet sheet, BaseInfo1Bean b1, List b2) {
      if(b1 != null) {
         fillCellValue(sheet, 2, 1, b1.getTbdw());
         fillCellValue(sheet, 2, 5, b1.getRmyh());
         fillCellValue(sheet, 3, 3, b1.getJgName());
         fillCellValue(sheet, 4, 3, b1.getJrjgCode());
         fillCellValue(sheet, 4, 5, b1.getJrxkCode());
         fillCellValue(sheet, 5, 3, b1.getZzjgCode());
         fillCellValue(sheet, 5, 5, b1.getBgjgCode());
         fillCellValue(sheet, 6, 3, b1.getJgxyCode());
         fillCellValue(sheet, 6, 5, b1.getHylx());
         fillCellValue(sheet, 7, 3, b1.getZczb());
         fillCellValue(sheet, 7, 5, b1.getSlsj());
         fillCellValue(sheet, 8, 3, b1.getIfFr());
         fillCellValue(sheet, 8, 5, b1.getIfWz());
         fillCellValue(sheet, 9, 3, b1.getZone());
         fillCellValue(sheet, 10, 3, b1.getJyfw());
         fillCellValue(sheet, 12, 3, b1.getAddress());
         fillCellValue(sheet, 14, 3, b1.getPhone());
         fillCellValue(sheet, 15, 3, b1.getFddbr());
         fillCellValue(sheet, 27, 3, b1.getNextSubCount());
         fillCellValue(sheet, 27, 5, b1.getNextSubZone());
         fillCellValue(sheet, 30, 3, b1.getOverseasCount());
         fillCellValue(sheet, 30, 5, b1.getOverseasZone());
         fillCellValue(sheet, 33, 1, b1.getReportUser());
         fillCellValue(sheet, 33, 5, b1.getReportDate());
      }

      if(b2 != null && !b2.isEmpty()) {
         for(int i = 0; i < b2.size(); ++i) {
            BaseInfo2Bean bean = (BaseInfo2Bean)b2.get(i);
            fillCellValue(sheet, 17 + i, 3, bean.getStockHolder());
            fillCellValue(sheet, 17 + i, 5, bean.getHoldStock());
         }
      }

   }

   public static Workbook createInnerCtrlWorkbook(String classpath, List list) {
      HSSFWorkbook wb = null;
      String filepath = classpath + File.separator + "excelTemplate" + File.separator + "reportInternal2015.xls";

      try {
         FileInputStream e = new FileInputStream(filepath);
         wb = new HSSFWorkbook(e);
         HSSFSheet sheet = wb.getSheetAt(0);
         fillInnerCtrlSheet(sheet, list);
         e.close();
      } catch (IOException var6) {
         var6.printStackTrace();
      }

      return wb;
   }

   public static void fillInnerCtrlSheet(HSSFSheet sheet, List list) {
      if(list != null && !list.isEmpty()) {
         for(int i = 0; i < list.size(); ++i) {
            InnerCtrlBean bean = (InnerCtrlBean)list.get(i);
            fillCellValue(sheet, 4 + i, 0, bean.getOrderNumber());
            fillCellValue(sheet, 4 + i, 1, bean.getName());
            fillCellValue(sheet, 4 + i, 2, bean.getImplementTime());
            fillCellValue(sheet, 4 + i, 3, bean.getUnit());
            fillCellValue(sheet, 4 + i, 4, bean.getRelevantDocument());
            fillCellValue(sheet, 4 + i, 5, bean.getIfNew());
            fillCellValue(sheet, 4 + i, 6, bean.getIfUpdate());
            fillCellValue(sheet, 4 + i, 7, bean.getIfReport());
         }
      }

   }

   public static Workbook createPostPersonWorkbook(String classpath, PostPerson1Bean b1, List b2) {
      HSSFWorkbook wb = null;
      String filepath = classpath + File.separator + "excelTemplate" + File.separator + "reportPostPerson2015.xls";

      try {
         FileInputStream e = new FileInputStream(filepath);
         wb = new HSSFWorkbook(e);
         HSSFSheet sheet = wb.getSheetAt(0);
         fillPostPersonSheet(sheet, b1, b2);
         e.close();
      } catch (IOException var7) {
         var7.printStackTrace();
      }

      return wb;
   }

   public static void fillPostPersonSheet(HSSFSheet sheet, PostPerson1Bean b1, List b2) {
      if(b1 != null) {
         fillCellValue(sheet, 3, 3, b1.getDeptName());
         fillCellValue(sheet, 4, 3, b1.getQxzz());
         fillCellValue(sheet, 4, 8, b1.getQxzzKy());
         fillCellValue(sheet, 5, 3, b1.getBjjg());
         fillCellValue(sheet, 5, 8, b1.getBjjgKy());
         fillCellValue(sheet, 6, 3, b1.getQxjz());
         fillCellValue(sheet, 6, 8, b1.getQxjzKy());
         fillCellValue(sheet, 7, 3, b1.getQxzzRate());
         fillCellValue(sheet, 7, 8, b1.getQxjzRate());
      }

      if(b2 != null && !b2.isEmpty()) {
         for(int add = 0; add < b2.size(); ++add) {
            PostPerson2Bean bean = (PostPerson2Bean)b2.get(add);
            fillCellValue(sheet, 9 + add, 1, bean.getTypeName());
            fillCellValue(sheet, 9 + add, 2, bean.getName());
            fillCellValue(sheet, 9 + add, 3, bean.getPosition());
            fillCellValue(sheet, 9 + add, 4, bean.getOfficePhone());
            fillCellValue(sheet, 9 + add, 5, bean.getTelephone());
            fillCellValue(sheet, 9 + add, 6, bean.getEmail());
            fillCellValue(sheet, 9 + add, 7, bean.getQualifications());
            fillCellValue(sheet, 9 + add, 8, bean.getFinanceTime());
            fillCellValue(sheet, 9 + add, 9, bean.getFxqTime());
         }

         if(b2.size() > 1) {
            CellRangeAddress var5 = new CellRangeAddress(9, 9 + b2.size(), 0, 0);
            sheet.addMergedRegion(var5);
         }
      }

   }

   public static Workbook createCustomerRecognitionWorkbook(String classpath, List list) {
      HSSFWorkbook wb = null;
      String filepath = classpath + File.separator + "excelTemplate" + File.separator + "CustGrade2015.xls";

      try {
         FileInputStream e = new FileInputStream(filepath);
         wb = new HSSFWorkbook(e);
         HSSFSheet sheet = wb.getSheetAt(0);
         fillCustomerRecognitionSheet(sheet, list);
         e.close();
      } catch (IOException var6) {
         var6.printStackTrace();
      }

      return wb;
   }

   public static void fillCustomerRecognitionSheet(HSSFSheet sheet, List list) {
      if(list != null && list.size() >= 2) {
         CustomerRecognitionBean b1 = (CustomerRecognitionBean)list.get(0);
         CustomerRecognitionBean b2 = (CustomerRecognitionBean)list.get(1);
         if(b1 != null) {
            fillCellValue(sheet, 3, 2, b1.getTotalCount());
            fillCellValue(sheet, 4, 2, b1.getOpenCount());
            fillCellValue(sheet, 5, 2, b1.getCloseCount());
            fillCellValue(sheet, 6, 2, b1.getNewIdentifyCount());
            fillCellValue(sheet, 7, 2, b1.getRepeatIdentifyCount());
            fillCellValue(sheet, 8, 2, b1.getStopCount());
            fillCellValue(sheet, 9, 2, b1.getMonitorCount());
            fillCellValue(sheet, 10, 2, b1.getLimitCount());
            fillCellValue(sheet, 11, 2, b1.getFrozenCount());
            fillCellValue(sheet, 12, 2, b1.getaCount());
            fillCellValue(sheet, 13, 2, b1.getAaCount());
            fillCellValue(sheet, 14, 2, b1.getbCount());
            fillCellValue(sheet, 15, 2, b1.getBbCount());
            fillCellValue(sheet, 16, 2, b1.getcCount());
            fillCellValue(sheet, 17, 2, b1.getCcCount());
            fillCellValue(sheet, 18, 2, b1.getdCount());
            fillCellValue(sheet, 19, 2, b1.getDdCount());
            fillCellValue(sheet, 20, 2, b1.geteCount());
            fillCellValue(sheet, 21, 2, b1.getEeCount());
         }

         if(b2 != null) {
            fillCellValue(sheet, 3, 3, b2.getTotalCount());
            fillCellValue(sheet, 4, 3, b2.getOpenCount());
            fillCellValue(sheet, 5, 3, b2.getCloseCount());
            fillCellValue(sheet, 6, 3, b2.getNewIdentifyCount());
            fillCellValue(sheet, 7, 3, b2.getRepeatIdentifyCount());
            fillCellValue(sheet, 8, 3, b2.getStopCount());
            fillCellValue(sheet, 9, 3, b2.getMonitorCount());
            fillCellValue(sheet, 10, 3, b2.getLimitCount());
            fillCellValue(sheet, 11, 3, b2.getFrozenCount());
            fillCellValue(sheet, 12, 3, b2.getaCount());
            fillCellValue(sheet, 13, 3, b2.getAaCount());
            fillCellValue(sheet, 14, 3, b2.getbCount());
            fillCellValue(sheet, 15, 3, b2.getBbCount());
            fillCellValue(sheet, 16, 3, b2.getcCount());
            fillCellValue(sheet, 17, 3, b2.getCcCount());
            fillCellValue(sheet, 18, 3, b2.getdCount());
            fillCellValue(sheet, 19, 3, b2.getDdCount());
            fillCellValue(sheet, 20, 3, b2.geteCount());
            fillCellValue(sheet, 21, 3, b2.getEeCount());
         }
      }

   }

   public static Workbook createLargeAndSuspiciousWorkbook(String classpath, LargeAndSuspiciousDetailBean b) {
      HSSFWorkbook wb = null;
      String filepath = classpath + File.separator + "excelTemplate" + File.separator + "dataReport2015.xls";

      try {
         FileInputStream e = new FileInputStream(filepath);
         wb = new HSSFWorkbook(e);
         HSSFSheet sheet = wb.getSheetAt(0);
         fillLargeAndSuspiciousSheet(sheet, b);
         e.close();
      } catch (IOException var6) {
         var6.printStackTrace();
      }

      return wb;
   }

   public static void fillLargeAndSuspiciousSheet(HSSFSheet sheet, LargeAndSuspiciousDetailBean b) {
      if(b != null) {
         fillCellValue(sheet, 3, 2, b.getDeCount());
         fillCellValue(sheet, 4, 2, b.getDeBzCount());
         fillCellValue(sheet, 5, 2, b.getAnalysisCount());
         fillCellValue(sheet, 6, 2, b.getKyCount());
         fillCellValue(sheet, 7, 2, b.getKyBzCount());
         fillCellValue(sheet, 8, 2, b.getBankCount());
         fillCellValue(sheet, 9, 2, b.getPoliceCount());
      }

   }

   public static Workbook createPropagandaWorkbook(String classpath, List list) {
      HSSFWorkbook wb = null;
      String filepath = classpath + File.separator + "excelTemplate" + File.separator + "reportPropaganda2015.xls";

      try {
         FileInputStream e = new FileInputStream(filepath);
         wb = new HSSFWorkbook(e);
         HSSFSheet sheet = wb.getSheetAt(0);
         fillPropagandaSheet(sheet, list);
         e.close();
      } catch (IOException var6) {
         var6.printStackTrace();
      }

      return wb;
   }

   public static void fillPropagandaSheet(HSSFSheet sheet, List list) {
      if(list != null && !list.isEmpty()) {
         for(int i = 0; i < list.size(); ++i) {
            PropagandaBean bean = (PropagandaBean)list.get(i);
            fillCellValue(sheet, i + 4, 0, bean.getJgName());
            fillCellValue(sheet, i + 4, 1, bean.getJoinJg());
            fillCellValue(sheet, i + 4, 2, bean.getContent());
            fillCellValue(sheet, i + 4, 3, bean.getMethods());
            fillCellValue(sheet, i + 4, 4, bean.getStartDate());
            fillCellValue(sheet, i + 4, 5, bean.getEndDate());
            fillCellValue(sheet, i + 4, 6, bean.getAudienceCount());
            fillCellValue(sheet, i + 4, 7, bean.getDataCount());
            fillCellValue(sheet, i + 4, 8, bean.getEffect());
         }
      }

   }

   public static Workbook createTrainWorkbook(String classpath, List list) {
      HSSFWorkbook wb = null;
      String filepath = classpath + File.separator + "excelTemplate" + File.separator + "reportTrain2015.xls";

      try {
         FileInputStream e = new FileInputStream(filepath);
         wb = new HSSFWorkbook(e);
         HSSFSheet sheet = wb.getSheetAt(0);
         fillTrainSheet(sheet, list);
         e.close();
      } catch (IOException var6) {
         var6.printStackTrace();
      }

      return wb;
   }

   public static void fillTrainSheet(HSSFSheet sheet, List list) {
      if(list != null && !list.isEmpty()) {
         for(int i = 0; i < list.size(); ++i) {
            TrainBean bean = (TrainBean)list.get(i);
            fillCellValue(sheet, i + 4, 0, bean.getDept());
            fillCellValue(sheet, i + 4, 1, bean.getContent());
            fillCellValue(sheet, i + 4, 2, bean.getStartDate());
            fillCellValue(sheet, i + 4, 3, bean.getEndDate());
            fillCellValue(sheet, i + 4, 4, bean.getMethods());
            fillCellValue(sheet, i + 4, 5, bean.getParticipants());
            fillCellValue(sheet, i + 4, 6, bean.getDays());
            fillCellValue(sheet, i + 4, 7, bean.getPassengers());
            fillCellValue(sheet, i + 4, 8, bean.getEffect());
         }
      }

   }

   public static Workbook createInternalInspectionWorkbook(String classpath, List list) {
      HSSFWorkbook wb = null;
      String filepath = classpath + File.separator + "excelTemplate" + File.separator + "reportInternalInspec2015.xls";

      try {
         FileInputStream e = new FileInputStream(filepath);
         wb = new HSSFWorkbook(e);
         HSSFSheet sheet = wb.getSheetAt(0);
         fillInternalInspectionSheet(sheet, list);
         e.close();
      } catch (IOException var6) {
         var6.printStackTrace();
      }

      return wb;
   }

   public static void fillInternalInspectionSheet(HSSFSheet sheet, List list) {
      if(list != null && !list.isEmpty()) {
         for(int i = 0; i < list.size(); ++i) {
            InternalInspectionBean bean = (InternalInspectionBean)list.get(i);
            fillCellValue(sheet, i + 4, 0, bean.getOrderNumber());
            fillCellValue(sheet, i + 4, 1, bean.getStartDate());
            fillCellValue(sheet, i + 4, 2, bean.getEndDate());
            fillCellValue(sheet, i + 4, 3, bean.getMainDept());
            fillCellValue(sheet, i + 4, 4, bean.getBeCheckedDept());
            fillCellValue(sheet, i + 4, 5, bean.getProblem());
            fillCellValue(sheet, i + 4, 6, bean.getRectify());
            fillCellValue(sheet, i + 4, 7, bean.getIfInner());
         }
      }

   }

   public static Workbook createAdministrativeInvestigationWorkbook(String classpath, List list) {
      HSSFWorkbook wb = null;
      String filepath = classpath + File.separator + "excelTemplate" + File.separator + "reportInspection2015.xls";

      try {
         FileInputStream e = new FileInputStream(filepath);
         wb = new HSSFWorkbook(e);
         HSSFSheet sheet = wb.getSheetAt(0);
         fillAdministrativeInvestigationSheet(sheet, list);
         e.close();
      } catch (IOException var6) {
         var6.printStackTrace();
      }

      return wb;
   }

   public static void fillAdministrativeInvestigationSheet(HSSFSheet sheet, List list) {
      if(list != null && !list.isEmpty()) {
         for(int i = 0; i < list.size(); ++i) {
            AdministrativeInvestigationBean bean = (AdministrativeInvestigationBean)list.get(i);
            fillCellValue(sheet, i + 4, 0, bean.getIfInner());
            fillCellValue(sheet, i + 4, 1, bean.getDept());
            fillCellValue(sheet, i + 4, 2, bean.getCoDept());
            fillCellValue(sheet, i + 4, 3, bean.getFinishDate());
            fillCellValue(sheet, i + 4, 4, bean.getIfOnTime());
         }
      }

   }

   public static Workbook createSiteInspectionWorkbook(String classpath, List list) {
      HSSFWorkbook wb = null;
      String filepath = classpath + File.separator + "excelTemplate" + File.separator + "reportScene2015.xls";

      try {
         FileInputStream e = new FileInputStream(filepath);
         wb = new HSSFWorkbook(e);
         HSSFSheet sheet = wb.getSheetAt(0);
         fillSiteInspectionSheet(sheet, list);
         e.close();
      } catch (IOException var6) {
         var6.printStackTrace();
      }

      return wb;
   }

   public static void fillSiteInspectionSheet(HSSFSheet sheet, List list) {
      if(list != null && !list.isEmpty()) {
         for(int i = 0; i < list.size(); ++i) {
            SiteInspectionBean bean = (SiteInspectionBean)list.get(i);
            fillCellValue(sheet, i + 4, 0, bean.getCheckNumber());
            fillCellValue(sheet, i + 4, 1, bean.getStartDate());
            fillCellValue(sheet, i + 4, 2, bean.getEndDate());
            fillCellValue(sheet, i + 4, 3, bean.getZcDept());
            fillCellValue(sheet, i + 4, 4, bean.getBcDept());
            fillCellValue(sheet, i + 4, 5, bean.getQuestion());
            fillCellValue(sheet, i + 4, 6, bean.getCfjeJg());
            fillCellValue(sheet, i + 4, 7, bean.getCgCount());
            fillCellValue(sheet, i + 4, 8, bean.getCfjeGr());
            fillCellValue(sheet, i + 4, 9, bean.getRectify());
         }
      }

   }

   public static Workbook createRiskCtrlWorkbook(String classpath, List list) {
      HSSFWorkbook wb = null;
      String filepath = classpath + File.separator + "excelTemplate" + File.separator + "reportContrResults2015.xls";

      try {
         FileInputStream e = new FileInputStream(filepath);
         wb = new HSSFWorkbook(e);
         HSSFSheet sheet = wb.getSheetAt(0);
         fillRiskCtrlSheet(sheet, list);
         e.close();
      } catch (IOException var6) {
         var6.printStackTrace();
      }

      return wb;
   }

   public static void fillRiskCtrlSheet(HSSFSheet sheet, List list) {
      if(list != null && !list.isEmpty()) {
         for(int i = 0; i < list.size(); ++i) {
            RiskCtrlBean bean = (RiskCtrlBean)list.get(i);
            fillCellValue(sheet, i + 4, 0, bean.getRiskName());
            fillCellValue(sheet, i + 4, 1, bean.getFxjg());
            fillCellValue(sheet, i + 4, 2, bean.getStartTime());
            fillCellValue(sheet, i + 4, 3, bean.getEndTime());
            fillCellValue(sheet, i + 4, 4, bean.getBaseInfo());
            fillCellValue(sheet, i + 4, 5, bean.getEffect());
            fillCellValue(sheet, i + 4, 6, bean.getIfReport());
         }
      }

   }

   public static Workbook createAbroadBranchWorkbook(String classpath, List list) {
      HSSFWorkbook wb = null;
      String filepath = classpath + File.separator + "excelTemplate" + File.separator + "reportOverseas2015.xls";

      try {
         FileInputStream e = new FileInputStream(filepath);
         wb = new HSSFWorkbook(e);
         HSSFSheet sheet = wb.getSheetAt(0);
         fillAbroadBranchSheet(sheet, list);
         e.close();
      } catch (IOException var6) {
         var6.printStackTrace();
      }

      return wb;
   }

   public static void fillAbroadBranchSheet(HSSFSheet sheet, List list) {
      if(list != null && !list.isEmpty()) {
         for(int i = 0; i < list.size(); ++i) {
            AbroadBranchBean bean = (AbroadBranchBean)list.get(i);
            fillCellValue(sheet, i + 4, 0, bean.getOrderNumber());
            fillCellValue(sheet, i + 4, 1, bean.getName());
            fillCellValue(sheet, i + 4, 2, bean.getCountry());
            fillCellValue(sheet, i + 4, 3, bean.getImplementTime());
            fillCellValue(sheet, i + 4, 4, bean.getUnitType());
            fillCellValue(sheet, i + 4, 5, bean.getOutletsNumber());
            fillCellValue(sheet, i + 4, 6, bean.getLocalManage());
            fillCellValue(sheet, i + 4, 7, bean.getRuledInfo());
            fillCellValue(sheet, i + 4, 8, bean.getPunishInfo());
            fillCellValue(sheet, i + 4, 9, bean.getOthers());
            fillCellValue(sheet, i + 4, 10, bean.getIfSin());
         }
      }

   }
}
