package com.rw.major.util;

import com.rw.major.model.FcerBean;
import com.rw.major.model.FcrcDeBean;
import com.rw.major.model.FcrcDeRcifBean;
import com.rw.major.model.FcrcKyBean;
import com.rw.major.model.FeedBackBean;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Iterator;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;

public class FeedBackXmlUtil {

   public static FeedBackBean analysisFDSCFeedback(InputStream is, String pk) {
      FeedBackBean bean = new FeedBackBean();
      bean.setFdbkid(pk);
      SAXReader reader = new SAXReader();

      try {
         Document e = reader.read(is);
         Element root = e.getRootElement();
         Element sfid = root.element("SFID");
         if(sfid != null) {
            bean.setSfid(sfid.getTextTrim());
         }
      } catch (DocumentException var7) {
         var7.printStackTrace();
      }

      return bean;
   }

   public static FeedBackBean analysisFDCFFeedback(InputStream is, String pk) {
      FeedBackBean bean = new FeedBackBean();
      bean.setFdbkid(pk);
      SAXReader reader = new SAXReader();

      try {
         Document e = reader.read(is);
         Element root = e.getRootElement();
         Element sfid = root.element("SFID");
         if(sfid != null) {
            bean.setSfid(sfid.getTextTrim());
         }

         Element ertn = root.element("ERTN");
         if(ertn != null) {
            String fcers = ertn.getText();
            bean.setErtn(new Integer(fcers));
         }

         Element fcers1 = root.element("FCERs");
         FcerBean fcerbean;
         if(fcers1 != null) {
            for(Iterator fcerIt = fcers1.elementIterator("FCER"); fcerIt.hasNext(); bean.getFcers().add(fcerbean)) {
               fcerbean = new FcerBean();
               fcerbean.setFdbkid(pk);
               Element fcer = (Element)fcerIt.next();
               String seqno = fcer.attributeValue("seqno");
               fcerbean.setFcerid(new Integer(seqno));
               Element erlc = fcer.element("ERLC");
               if(erlc != null) {
                  fcerbean.setErlc(erlc.getTextTrim());
               }

               Element errs = fcer.element("ERRS");
               if(errs != null) {
                  fcerbean.setErrs(errs.getTextTrim());
               }
            }
         }
      } catch (DocumentException var15) {
         var15.printStackTrace();
      }

      return bean;
   }

   public static FeedBackBean analysisFDRC_KY_Feedback(InputStream is, String pk) {
      FeedBackBean bean = new FeedBackBean();
      bean.setFdbkid(pk);
      SAXReader reader = new SAXReader();

      try {
         Document e = reader.read(is);
         Element root = e.getRootElement();
         Element sfid = root.element("SFID");
         if(sfid != null) {
            bean.setSfid(sfid.getTextTrim());
         }

         Element rctn = root.element("RCTN");
         if(rctn != null) {
            String fcrcs = rctn.getTextTrim();
            bean.setRctn(new Integer(fcrcs));
         }

         Element fcrcs1 = root.element("FCRCs");
         FcrcKyBean fcrcKybean;
         if(fcrcs1 != null) {
            for(Iterator fcrcIt = fcrcs1.elementIterator("FCRC"); fcrcIt.hasNext(); bean.getFcrckys().add(fcrcKybean)) {
               fcrcKybean = new FcrcKyBean();
               fcrcKybean.setFdbkid(pk);
               Element fcrc = (Element)fcrcIt.next();
               String seqno = fcrc.attributeValue("seqno");
               fcrcKybean.setFcrcid(new Integer(seqno));
               Element rclc = fcrc.element("RCLC");
               if(rclc != null) {
                  fcrcKybean.setRclc(rclc.getTextTrim());
               }

               Element rcsg = fcrc.element("RCSG");
               if(rcsg != null) {
                  fcrcKybean.setRcsg(rcsg.getTextTrim());
               }
            }
         }
      } catch (DocumentException var15) {
         var15.printStackTrace();
      }

      return bean;
   }

   public static FeedBackBean analysisFDRC_DE_Feedback(InputStream is, String pk) throws DocumentException {
      FeedBackBean bean = new FeedBackBean();
      bean.setFdbkid(pk);
      SAXReader reader = new SAXReader();

      try {
         Document e = reader.read(is);
         Element root = e.getRootElement();
         Element sfid = root.element("SFID");
         if(sfid != null) {
            bean.setSfid(sfid.getTextTrim());
         }

         Element rctn = root.element("RCTN");
         if(rctn != null) {
            String fcrcs = rctn.getTextTrim();
            bean.setRctn(new Integer(fcrcs));
         }

         Element fcrcs1 = root.element("FCRCs");
         FcrcDeBean fcrcDebean;
         if(fcrcs1 != null) {
            for(Iterator fcrcIt = fcrcs1.elementIterator("FCRC"); fcrcIt.hasNext(); bean.getFcrcdes().add(fcrcDebean)) {
               fcrcDebean = new FcrcDeBean();
               fcrcDebean.setFdbkid(pk);
               Element fcrc = (Element)fcrcIt.next();
               String fcrcid = fcrc.attributeValue("seqno");
               fcrcDebean.setFcrcid(new Integer(fcrcid));
               System.out.println(fcrcid);
               Element ocnm = fcrc.element("OCNM");
               if(ocnm != null) {
                  fcrcDebean.setOcnm(ocnm.getTextTrim());
               }

               Element otdt = fcrc.element("OTDT");
               if(otdt != null) {
                  fcrcDebean.setOtdt(otdt.getTextTrim());
               }

               Element otcd = fcrc.element("OTCD");
               if(otcd != null) {
                  fcrcDebean.setOtcd(otcd.getTextTrim());
               }

               Element otic = fcrc.element("OTIC");
               if(otic != null) {
                  fcrcDebean.setOtic(otic.getTextTrim());
               }

               Element rcifs = fcrc.element("RCIFs");
               FcrcDeRcifBean rcifbean;
               if(rcifs != null) {
                  for(Iterator rcifIt = rcifs.elementIterator("RCIF"); rcifIt.hasNext(); fcrcDebean.getRcifs().add(rcifbean)) {
                     rcifbean = new FcrcDeRcifBean();
                     rcifbean.setFdbkid(pk);
                     rcifbean.setFcrcid(new Integer(fcrcid));
                     Element rcif = (Element)rcifIt.next();
                     String rcifid = rcif.attributeValue("seqno");
                     rcifbean.setRcifid(new Integer(rcifid));
                     Element rclc = rcif.element("RCLC");
                     if(rclc != null) {
                        rcifbean.setRclc(rclc.getTextTrim());
                     }

                     Element rcsg = rcif.element("RCSG");
                     if(rcsg != null) {
                        rcifbean.setRcsg(rcsg.getTextTrim());
                     }
                  }
               }
            }
         }

         return bean;
      } catch (DocumentException var24) {
         var24.printStackTrace();
         throw var24;
      }
   }

   public static void main(String[] args) throws Exception {
      String filename = "FDRC[ASS020014403032306-20150605-0013-0001]20150605190859.XML";
      File file = new File("C:\\Users\\sh\\Desktop\\020014403032306-20150605\\" + filename);
      FileInputStream is = new FileInputStream(file);
      analysisFDRC_KY_Feedback(is, "");
      is.close();
      is = null;
   }
}
