package com.rw.major.service;

import com.rw.major.dao.PushdataFeedbackDao;
import com.rw.major.model.FcerBean;
import com.rw.major.model.FcrcDeBean;
import com.rw.major.model.FcrcDeRcifBean;
import com.rw.major.model.FcrcKyBean;
import com.rw.major.model.FeedBackBean;
import com.rw.major.service.PushdataFeedbackBusiness;
import com.rw.major.util.FeedBackXmlUtil;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.dom4j.DocumentException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class PushdataFeedbackBusinessImpl implements PushdataFeedbackBusiness {

   private static final Logger log = Logger.getLogger(PushdataFeedbackBusinessImpl.class);
   @Autowired
   private PushdataFeedbackDao dao;


   private int analysisFeedbackType(String pk) {
      String head = pk.substring(0, 4);
      if("FDSC".equals(head)) {
         return 1;
      } else if("FDCF".equals(head)) {
         return 2;
      } else {
         if("FDRC".equals(head)) {
            String sssh = pk.substring(6, 8);
            if("SH".equals(sssh)) {
               return 3;
            }

            if("SS".equals(sssh)) {
               return 4;
            }
         }

         return 0;
      }
   }

   public boolean checkFileUploaded(String pk) {
      return this.dao.checkFileUploaded(pk);
   }

   public FeedBackBean analysisXml(InputStream is, String pk) throws DocumentException {
      FeedBackBean feedback = null;
      int fdbktype = this.analysisFeedbackType(pk);
      int start = pk.indexOf("[");
      int end = pk.indexOf("]");
      String reportinfo = pk.substring(start + 1, end);
      String reporttype = reportinfo.substring(0, 1);
      String reportname = reportinfo.substring(1);
      if(fdbktype == 1) {
         feedback = FeedBackXmlUtil.analysisFDSCFeedback(is, pk);
      } else if(fdbktype == 2) {
         feedback = FeedBackXmlUtil.analysisFDCFFeedback(is, pk);
      } else if(fdbktype == 3) {
         feedback = FeedBackXmlUtil.analysisFDRC_DE_Feedback(is, pk);
      } else if(fdbktype == 4) {
         feedback = FeedBackXmlUtil.analysisFDRC_KY_Feedback(is, pk);
      }

      if(feedback != null) {
         feedback.setFdbktype(Integer.valueOf(fdbktype));
         feedback.setReporttype(reporttype);
         feedback.setReportname(reportname);
      }

      return feedback;
   }

   public FeedBackBean dealReportStatusAndPreReport(FeedBackBean feedback) {
      String reporttype = feedback.getReporttype();
      Integer fdbktype = feedback.getFdbktype();
      String reportname = feedback.getReportname();
      if(!"N".equals(reporttype) && !"A".equals(reporttype)) {
         if("R".equals(reporttype)) {
            if(this.dao.checkHasResentPreReport(reportname)) {
               if(fdbktype.intValue() == 1) {
                  this.dao.updateResentPreReportStatus(reportname, Integer.valueOf(3));
                  feedback.setStatus(Integer.valueOf(1));
               } else if(fdbktype.intValue() == 2) {
                  feedback.setStatus(Integer.valueOf(4));
               } else if(fdbktype.intValue() != 3 && fdbktype.intValue() != 4) {
                  feedback.setStatus(Integer.valueOf(0));
               } else {
                  this.dao.updateResentPreReportStatus(reportname, Integer.valueOf(3));
                  feedback.setStatus(Integer.valueOf(2));
               }
            } else {
               feedback.setStatus(Integer.valueOf(-1));
            }
         } else if("I".equals(reporttype)) {
            if(this.dao.checkHasFillsentPreReport(reportname)) {
               if(fdbktype.intValue() == 1) {
                  this.dao.updateFillsentPreReportStatus(reportname, Integer.valueOf(3));
                  feedback.setStatus(Integer.valueOf(1));
               } else if(fdbktype.intValue() == 2) {
                  feedback.setStatus(Integer.valueOf(4));
               } else if(fdbktype.intValue() != 3 && fdbktype.intValue() != 4) {
                  feedback.setStatus(Integer.valueOf(0));
               } else {
                  feedback.setStatus(Integer.valueOf(4));
               }
            } else {
               feedback.setStatus(Integer.valueOf(-2));
            }
         } else if(fdbktype.intValue() == 1) {
            feedback.setStatus(Integer.valueOf(1));
         } else if(fdbktype.intValue() != 2 && fdbktype.intValue() != 3 && fdbktype.intValue() != 4) {
            feedback.setStatus(Integer.valueOf(0));
         } else {
            feedback.setStatus(Integer.valueOf(4));
         }
      } else if(fdbktype.intValue() == 1) {
         feedback.setStatus(Integer.valueOf(1));
      } else if(fdbktype.intValue() != 2 && fdbktype.intValue() != 3 && fdbktype.intValue() != 4) {
         feedback.setStatus(Integer.valueOf(0));
      } else {
         feedback.setStatus(Integer.valueOf(2));
      }

      return feedback;
   }

   public void addFeedBack(FeedBackBean feedback) {
      String fdbkid = feedback.getFdbkid();
      this.dao.addFeedback(feedback.getFdbkid(), feedback.getFdbktype(), feedback.getSfid(), feedback.getErtn(), feedback.getRctn(), feedback.getReporttype(), feedback.getReportname(), feedback.getStatus());
      List fcers = feedback.getFcers();
      if(fcers != null && !fcers.isEmpty()) {
         Iterator fcrcKys = fcers.iterator();

         while(fcrcKys.hasNext()) {
            FcerBean fcrcDes = (FcerBean)fcrcKys.next();
            this.dao.addFcer(fcrcDes.getFdbkid(), fcrcDes.getFcerid(), fcrcDes.getErlc(), fcrcDes.getErrs());
         }
      }

      List fcrcDes1 = feedback.getFcrcdes();
      if(fcrcDes1 != null && !fcrcDes1.isEmpty()) {
         Iterator fcrcKy = fcrcDes1.iterator();

         while(fcrcKy.hasNext()) {
            FcrcDeBean fcrcKys1 = (FcrcDeBean)fcrcKy.next();
            this.dao.addFcrcDe(fcrcKys1.getFdbkid(), fcrcKys1.getFcrcid(), fcrcKys1.getOcnm(), fcrcKys1.getOtdt(), fcrcKys1.getOtcd(), fcrcKys1.getOtic());
            List rcifs = fcrcKys1.getRcifs();
            if(rcifs != null && !rcifs.isEmpty()) {
               Iterator var9 = rcifs.iterator();

               while(var9.hasNext()) {
                  FcrcDeRcifBean rcif = (FcrcDeRcifBean)var9.next();
                  this.dao.addFcrcDeRcif(rcif.getFdbkid(), rcif.getFcrcid(), rcif.getRcifid(), rcif.getRclc(), rcif.getRcsg());
               }
            }
         }
      }

      List fcrcKys2 = feedback.getFcrckys();
      if(fcrcKys2 != null && !fcrcKys2.isEmpty()) {
         Iterator rcifs1 = fcrcKys2.iterator();

         while(rcifs1.hasNext()) {
            FcrcKyBean fcrcKy1 = (FcrcKyBean)rcifs1.next();
            this.dao.addFcrcKy(fcrcKy1.getFdbkid(), fcrcKy1.getFcrcid(), fcrcKy1.getRclc(), fcrcKy1.getRcsg());
         }
      }

   }
}
