package com.rw.major.service;

import com.rw.major.dao.NonSenceReportDao;
import com.rw.major.model.nonsence.AbroadBranchStatusBean;
import com.rw.major.model.nonsence.AdInStatusBean;
import com.rw.major.model.nonsence.BaseInfoBean;
import com.rw.major.model.nonsence.CustomerRecognitionStatusBean;
import com.rw.major.model.nonsence.InnerCtrlBeanStatusBean;
import com.rw.major.model.nonsence.InternalInspectionStatusBean;
import com.rw.major.model.nonsence.LargeAndSuspiciousBean;
import com.rw.major.model.nonsence.MsgBean;
import com.rw.major.model.nonsence.PostPersonBean;
import com.rw.major.model.nonsence.PropagandaStatusBean;
import com.rw.major.model.nonsence.RiskCtrlStatusBean;
import com.rw.major.model.nonsence.SiteInspectionStatusBean;
import com.rw.major.model.nonsence.TrainStatusBean;
import com.rw.major.service.NonSenceReportBusiness;
import com.rw.major.util.FileDownWorkbookUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class NonSenceReportBusinessImpl implements NonSenceReportBusiness {

   @Autowired
   private NonSenceReportDao dao;


   public Workbook getBaseInfoWorkbook(String classpath, String uniqueRowid) {
      BaseInfoBean b1 = this.dao.getBaseInfo1(uniqueRowid);
      List b2 = this.dao.getBaseInfo2(uniqueRowid);
      Workbook wb = FileDownWorkbookUtil.createBaseInfoWorkbook(classpath, b1.getBase1(), b2);
      return wb;
   }

   public BaseInfoBean getBaseInfo1(String uniqueRowid) {
      return this.dao.getBaseInfo1(uniqueRowid);
   }

   public List getBaseInfo2(String uniqueRowid) {
      return this.dao.getBaseInfo2(uniqueRowid);
   }

   public Workbook getInnerCtrlWorkbook(String classpath, String uniqueRowid) {
      List list = this.dao.getInnerCtrl(uniqueRowid);
      Workbook wb = FileDownWorkbookUtil.createInnerCtrlWorkbook(classpath, list);
      return wb;
   }

   public List getInnerCtrl(String uniqueRowid) {
      return this.dao.getInnerCtrl(uniqueRowid);
   }

   public InnerCtrlBeanStatusBean getInnerCtrlBeanStatus(String uniqueRowid) {
      return this.dao.getInnerCtrlBeanStatus(uniqueRowid);
   }

   public Workbook getPostPersonWorkbook(String classpath, String uniqueRowid) {
      PostPersonBean b1 = this.dao.getPostPerson1(uniqueRowid);
      List b2 = this.dao.getPostPerson2(uniqueRowid);
      Workbook wb = FileDownWorkbookUtil.createPostPersonWorkbook(classpath, b1.getPerson1(), b2);
      return wb;
   }

   public PostPersonBean getPostPerson1(String uniqueRowid) {
      return this.dao.getPostPerson1(uniqueRowid);
   }

   public List getPostPerson2(String uniqueRowid) {
      return this.dao.getPostPerson2(uniqueRowid);
   }

   public CustomerRecognitionStatusBean getCustomerRecognitionStatusBean(String uniqueRowid) {
      return this.dao.getCustomerRecognitionStatusBean(uniqueRowid);
   }

   public List getCustomerRecognition(String uniqueRowid) {
      return this.dao.getCustomerRecognition(uniqueRowid);
   }

   public Workbook getCustomerRecognitionWorkbook(String classpath, String uniqueRowid) {
      List list = this.dao.getCustomerRecognition(uniqueRowid);
      Workbook wb = FileDownWorkbookUtil.createCustomerRecognitionWorkbook(classpath, list);
      return wb;
   }

   public LargeAndSuspiciousBean getLargeAndSuspicious(String uniqueRowid) {
      return this.dao.getLargeAndSuspicious(uniqueRowid);
   }

   public Workbook getLargeAndSuspiciousWorkbook(String classpath, String uniqueRowid) {
      LargeAndSuspiciousBean b = this.dao.getLargeAndSuspicious(uniqueRowid);
      Workbook wb = FileDownWorkbookUtil.createLargeAndSuspiciousWorkbook(classpath, b.getDetail());
      return wb;
   }

   public List getPropaganda(String uniqueRowid) {
      return this.dao.getPropaganda(uniqueRowid);
   }

   public PropagandaStatusBean getPropagandaStatus(String uniqueRowid) {
      return this.dao.getPropagandaStatus(uniqueRowid);
   }

   public Workbook getPropagandaWorkbook(String classpath, String uniqueRowid) {
      List list = this.dao.getPropaganda(uniqueRowid);
      Workbook wb = FileDownWorkbookUtil.createPropagandaWorkbook(classpath, list);
      return wb;
   }

   public List getTrain(String uniqueRowid) {
      return this.dao.getTrain(uniqueRowid);
   }

   public TrainStatusBean getTrainStatus(String uniqueRowid) {
      return this.dao.getTrainStatus(uniqueRowid);
   }

   public Workbook getTrainWorkbook(String classpath, String uniqueRowid) {
      List list = this.dao.getTrain(uniqueRowid);
      Workbook wb = FileDownWorkbookUtil.createTrainWorkbook(classpath, list);
      return wb;
   }

   public List getInternalInspection(String uniqueRowid) {
      return this.dao.getInternalInspection(uniqueRowid);
   }

   public InternalInspectionStatusBean getInternalInspectionStatus(String uniqueRowid) {
      return this.dao.getInternalInspectionStatus(uniqueRowid);
   }

   public Workbook getInternalInspectionWorkbook(String classpath, String uniqueRowid) {
      List list = this.dao.getInternalInspection(uniqueRowid);
      Workbook wb = FileDownWorkbookUtil.createInternalInspectionWorkbook(classpath, list);
      return wb;
   }

   public List getAdministrativeInvestigation(String uniqueRowid) {
      return this.dao.getAdministrativeInvestigation(uniqueRowid);
   }

   public AdInStatusBean getAdInStatus(String uniqueRowid) {
      return this.dao.getAdInStatus(uniqueRowid);
   }

   public Workbook getAdministrativeInvestigationWorkbook(String classpath, String uniqueRowid) {
      List list = this.dao.getAdministrativeInvestigation(uniqueRowid);
      Workbook wb = FileDownWorkbookUtil.createAdministrativeInvestigationWorkbook(classpath, list);
      return wb;
   }

   public List getSiteInspection(String uniqueRowid) {
      return this.dao.getSiteInspection(uniqueRowid);
   }

   public SiteInspectionStatusBean getSiteInspectionStatus(String uniqueRowid) {
      return this.dao.getSiteInspectionStatus(uniqueRowid);
   }

   public Workbook getSiteInspectionWorkbook(String classpath, String uniqueRowid) {
      List list = this.dao.getSiteInspection(uniqueRowid);
      Workbook wb = FileDownWorkbookUtil.createSiteInspectionWorkbook(classpath, list);
      return wb;
   }

   public List getRiskCtrl(String uniqueRowid) {
      return this.dao.getRiskCtrl(uniqueRowid);
   }

   public RiskCtrlStatusBean getRiskCtrlStatus(String uniqueRowid) {
      return this.dao.getRiskCtrlStatus(uniqueRowid);
   }

   public Workbook getRiskCtrlWorkbook(String classpath, String uniqueRowid) {
      List list = this.dao.getRiskCtrl(uniqueRowid);
      Workbook wb = FileDownWorkbookUtil.createRiskCtrlWorkbook(classpath, list);
      return wb;
   }

   public List getAbroadBranch(String uniqueRowid) {
      return this.dao.getAbroadBranch(uniqueRowid);
   }

   public AbroadBranchStatusBean getAbroadBranchStatus(String uniqueRowid) {
      return this.dao.getAbroadBranchStatus(uniqueRowid);
   }

   public Workbook getAbroadBranchWorkbook(String classpath, String uniqueRowid) {
      List list = this.dao.getAbroadBranch(uniqueRowid);
      Workbook wb = FileDownWorkbookUtil.createAbroadBranchWorkbook(classpath, list);
      return wb;
   }

   public MsgBean finalText(String uniqueRowid, String opType, String lmtFinal, String functionId, String userCode) {
      return this.dao.finalText(uniqueRowid, opType, lmtFinal, functionId, userCode);
   }

   public Workbook getAllReportWorkbook(String classpath, String uuid1, String uuid2, String uuid3, String uuid4, String uuid5, String uuid6, String uuid7, String uuid8, String uuid9, String uuid10, String uuid11, String uuid12) {
      HSSFWorkbook wb = null;
      String filepath = classpath + File.separator + "excelTemplate" + File.separator + "allReport.xls";

      try {
         FileInputStream e = new FileInputStream(filepath);
         wb = new HSSFWorkbook(e);
         HSSFSheet sheet11;
         List b4;
         if(uuid1 != null && !"".equals(uuid1)) {
            sheet11 = wb.getSheetAt(0);
            BaseInfoBean list9 = this.dao.getBaseInfo1(uuid1);
            b4 = this.dao.getBaseInfo2(uuid1);
            FileDownWorkbookUtil.fillBaseInfoSheet(sheet11, list9.getBase1(), b4);
         }

         List list91;
         if(uuid2 != null && !"".equals(uuid2)) {
            sheet11 = wb.getSheetAt(1);
            list91 = this.dao.getInnerCtrl(uuid2);
            FileDownWorkbookUtil.fillInnerCtrlSheet(sheet11, list91);
         }

         if(uuid3 != null && !"".equals(uuid3)) {
            sheet11 = wb.getSheetAt(2);
            PostPersonBean list92 = this.dao.getPostPerson1(uuid3);
            b4 = this.dao.getPostPerson2(uuid3);
            FileDownWorkbookUtil.fillPostPersonSheet(sheet11, list92.getPerson1(), b4);
         }

         if(uuid4 != null && !"".equals(uuid4)) {
            sheet11 = wb.getSheetAt(3);
            list91 = this.dao.getCustomerRecognition(uuid4);
            FileDownWorkbookUtil.fillCustomerRecognitionSheet(sheet11, list91);
         }

         if(uuid5 != null && !"".equals(uuid5)) {
            sheet11 = wb.getSheetAt(4);
            LargeAndSuspiciousBean list93 = this.dao.getLargeAndSuspicious(uuid5);
            FileDownWorkbookUtil.fillLargeAndSuspiciousSheet(sheet11, list93.getDetail());
         }

         if(uuid6 != null && !"".equals(uuid6)) {
            sheet11 = wb.getSheetAt(5);
            list91 = this.dao.getPropaganda(uuid6);
            FileDownWorkbookUtil.fillPropagandaSheet(sheet11, list91);
         }

         if(uuid7 != null && !"".equals(uuid7)) {
            sheet11 = wb.getSheetAt(6);
            list91 = this.dao.getTrain(uuid7);
            FileDownWorkbookUtil.fillTrainSheet(sheet11, list91);
         }

         if(uuid8 != null && !"".equals(uuid8)) {
            sheet11 = wb.getSheetAt(7);
            list91 = this.dao.getInternalInspection(uuid8);
            FileDownWorkbookUtil.fillInternalInspectionSheet(sheet11, list91);
         }

         if(uuid9 != null && !"".equals(uuid9)) {
            sheet11 = wb.getSheetAt(8);
            list91 = this.dao.getAdministrativeInvestigation(uuid9);
            FileDownWorkbookUtil.fillAdministrativeInvestigationSheet(sheet11, list91);
         }

         if(uuid10 != null && !"".equals(uuid10)) {
            sheet11 = wb.getSheetAt(9);
            list91 = this.dao.getSiteInspection(uuid10);
            FileDownWorkbookUtil.fillSiteInspectionSheet(sheet11, list91);
         }

         if(uuid11 != null && !"".equals(uuid11)) {
            sheet11 = wb.getSheetAt(10);
            list91 = this.dao.getRiskCtrl(uuid11);
            FileDownWorkbookUtil.fillRiskCtrlSheet(sheet11, list91);
         }

         if(uuid12 != null && !"".equals(uuid12)) {
            sheet11 = wb.getSheetAt(11);
            list91 = this.dao.getAbroadBranch(uuid12);
            FileDownWorkbookUtil.fillAbroadBranchSheet(sheet11, list91);
         }

         e.close();
      } catch (Exception var20) {
         var20.printStackTrace();
      }

      return wb;
   }
}
