package com.rw.major.service;

import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.parser.PdfTextExtractor;
import com.rw.major.dao.BlacklistDao;
import com.rw.major.model.BlacklistQEBean;
import com.rw.major.model.BlacklistQIBean;
import com.rw.major.service.BlacklistBusiness;
import com.rw.major.util.RegexConfig;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class BlacklistBusinessImpl implements BlacklistBusiness {

   @Autowired
   private BlacklistDao dao;


   public void saveBlacklist(InputStream is) {
      String pdfContent = this.readPdfConetnt(is);
      String regexQI = RegexConfig.get("regexQI");
      System.out.println("regexQI === " + regexQI);
      List resultQI = this.paser(pdfContent, regexQI);
      List qilist = this.convertToQI(resultQI);
      String regexQE = RegexConfig.get("regexQE");
      System.out.println("regexQE === " + regexQE);
      List resultQE = this.paser(pdfContent, regexQE);
      List qelist = this.convertToQE(resultQE);
      System.out.println("qilist size === " + qilist.size());
      System.out.println("qelist size === " + qelist.size());
      if(qilist != null && !qilist.isEmpty()) {
         this.dao.saveQIBlacklist(qilist);
      }

      if(qelist != null && !qelist.isEmpty()) {
         this.dao.saveQEBlacklist(qelist);
      }

   }

   private String readPdfConetnt(InputStream is) {
      StringBuffer str = new StringBuffer();

      try {
         PdfReader e = new PdfReader(is);
         int num = e.getNumberOfPages();

         for(int i = 1; i <= num; ++i) {
            str.append(PdfTextExtractor.getTextFromPage(e, i));
         }
      } catch (Exception var6) {
         var6.printStackTrace();
      }

      return str.toString();
   }

   private List paser(String fileContent, String regex) {
      byte flag = 0;
      int var9 = flag | 2;
      var9 |= 8;
      var9 |= 32;
      Pattern p = Pattern.compile(regex, var9);
      Matcher m = p.matcher(fileContent);
      ArrayList rtn = new ArrayList();

      while(m.find()) {
         ArrayList list = new ArrayList();

         for(int i = 1; i <= m.groupCount(); ++i) {
            list.add(m.group(i));
         }

         rtn.add(list);
      }

      return rtn;
   }

   private List convertToQI(List resultQI) {
      ArrayList list = new ArrayList();
      Iterator var4 = resultQI.iterator();

      while(var4.hasNext()) {
         List qistr = (List)var4.next();
         BlacklistQIBean bean = new BlacklistQIBean();
         bean.setQino(((String)qistr.get(0)).trim());
         bean.setName((String)qistr.get(1));
         bean.setTitle(((String)qistr.get(2)).trim());
         bean.setDesignation(((String)qistr.get(3)).trim());
         bean.setDob(((String)qistr.get(4)).trim());
         bean.setPob(((String)qistr.get(5)).trim());
         bean.setGqaka(((String)qistr.get(6)).trim());
         bean.setLqaka(((String)qistr.get(7)).trim());
         bean.setNationality(((String)qistr.get(8)).trim());
         bean.setPassportno(((String)qistr.get(9)).trim());
         bean.setNationalidno(((String)qistr.get(10)).trim());
         bean.setAddress(((String)qistr.get(11)).trim());
         bean.setListedon(((String)qistr.get(12)).trim());
         bean.setOtherinfo(((String)qistr.get(13)).trim());
         list.add(bean);
      }

      return list;
   }

   private List convertToQE(List resultQE) {
      ArrayList list = new ArrayList();
      Iterator var4 = resultQE.iterator();

      while(var4.hasNext()) {
         List qestr = (List)var4.next();
         BlacklistQEBean bean = new BlacklistQEBean();
         bean.setQeno(((String)qestr.get(0)).trim());
         bean.setName((String)qestr.get(1));
         bean.setAka(((String)qestr.get(2)).trim());
         bean.setFka(((String)qestr.get(3)).trim());
         bean.setAddress(((String)qestr.get(4)).trim());
         bean.setListedon(((String)qestr.get(5)).trim());
         bean.setOtherinfo(((String)qestr.get(6)).trim());
         list.add(bean);
      }

      return list;
   }
}
