package com.rw.major.dao;

import com.rw.dao.BaseDAOImpl;
import com.rw.major.dao.NonSenceReportDao;
import com.rw.major.model.nonsence.AbroadBranchBean;
import com.rw.major.model.nonsence.AbroadBranchStatusBean;
import com.rw.major.model.nonsence.AdInStatusBean;
import com.rw.major.model.nonsence.AdministrativeInvestigationBean;
import com.rw.major.model.nonsence.BaseInfo1Bean;
import com.rw.major.model.nonsence.BaseInfo2Bean;
import com.rw.major.model.nonsence.BaseInfoBean;
import com.rw.major.model.nonsence.CustomerRecognitionBean;
import com.rw.major.model.nonsence.CustomerRecognitionStatusBean;
import com.rw.major.model.nonsence.InnerCtrlBean;
import com.rw.major.model.nonsence.InnerCtrlBeanStatusBean;
import com.rw.major.model.nonsence.InternalInspectionBean;
import com.rw.major.model.nonsence.InternalInspectionStatusBean;
import com.rw.major.model.nonsence.LargeAndSuspiciousBean;
import com.rw.major.model.nonsence.LargeAndSuspiciousDetailBean;
import com.rw.major.model.nonsence.MsgBean;
import com.rw.major.model.nonsence.PostPerson1Bean;
import com.rw.major.model.nonsence.PostPerson2Bean;
import com.rw.major.model.nonsence.PostPersonBean;
import com.rw.major.model.nonsence.PropagandaBean;
import com.rw.major.model.nonsence.PropagandaStatusBean;
import com.rw.major.model.nonsence.RiskCtrlBean;
import com.rw.major.model.nonsence.RiskCtrlStatusBean;
import com.rw.major.model.nonsence.SiteInspectionBean;
import com.rw.major.model.nonsence.SiteInspectionStatusBean;
import com.rw.major.model.nonsence.TrainBean;
import com.rw.major.model.nonsence.TrainStatusBean;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.CallableStatementCallback;
import org.springframework.jdbc.core.CallableStatementCreator;
import org.springframework.stereotype.Repository;

@Repository
public class NonSenceReportDaoImpl extends BaseDAOImpl implements NonSenceReportDao {

   public BaseInfoBean getBaseInfo1(final String uniqueRowid) {
      final String sql = "{call KINGSTAR.P7201103015_VW_01(?,?,?,?,?,?,?)}";
      final ArrayList list = new ArrayList(1);
      final BaseInfoBean base1 = new BaseInfoBean();
      this.getJdbcTemplate().execute(new CallableStatementCreator() {
         public CallableStatement createCallableStatement(Connection con) throws SQLException {
            CallableStatement cs = con.prepareCall(sql);
            cs.registerOutParameter(1, 2012);
            cs.setString(2, uniqueRowid);
            cs.registerOutParameter(3, 12);
            cs.registerOutParameter(4, 12);
            cs.registerOutParameter(5, 12);
            cs.registerOutParameter(6, 4);
            cs.registerOutParameter(7, 12);
            return cs;
         }
      }, new CallableStatementCallback() {
         public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
            cs.execute();
            String lmtFinal = cs.getString(3);
            String lmtDown = cs.getString(4);
            String functionId = cs.getString(5);
            Integer code = Integer.valueOf(cs.getInt(6));
            String msg = cs.getString(7);
            base1.setLmtFinal(lmtFinal);
            base1.setLmtDown(lmtDown);
            base1.setFunctionId(functionId);
            ResultSet rs = (ResultSet)cs.getObject(1);

            while(rs.next()) {
               BaseInfo1Bean b = new BaseInfo1Bean();
               b.setTbdw(rs.getString("TBDW"));
               b.setRmyh(rs.getString("RMYH"));
               b.setJgName(rs.getString("JG_NAME"));
               b.setJrjgCode(rs.getString("JRJG_CODE"));
               b.setJrxkCode(rs.getString("JRXK_CODE"));
               b.setZzjgCode(rs.getString("ZZJG_CODE"));
               b.setBgjgCode(rs.getString("BGJG_CODE"));
               b.setJgxyCode(rs.getString("JGXY_CODE"));
               b.setHylx(rs.getString("HYLX"));
               b.setZczb(rs.getString("ZCZB"));
               b.setSlsj(rs.getString("SLSJ"));
               b.setIfFr(rs.getString("IF_FR"));
               b.setIfWz(rs.getString("IF_WZ"));
               b.setZone(rs.getString("ZONE"));
               b.setJyfw(rs.getString("JYFW"));
               b.setAddress(rs.getString("ADDRESS"));
               b.setPhone(rs.getString("PHONE"));
               b.setFddbr(rs.getString("FDDBR"));
               b.setNextSubCount(rs.getString("NEXT_SUB_COUNT"));
               b.setNextSubZone(rs.getString("NEXT_SUB_ZONE"));
               b.setOverseasCount(rs.getString("OVERSEAS_COUNT"));
               b.setOverseasZone(rs.getString("OVERSEAS_ZONE"));
               b.setReportUser(rs.getString("REPORT_USER"));
               b.setReportDate(rs.getString("REPORT_DATE"));
               list.add(b);
            }

            rs.close();
            return null;
         }
      });
      BaseInfo1Bean bean = null;
      if(list != null && !list.isEmpty()) {
         bean = (BaseInfo1Bean)list.get(0);
      }

      base1.setBase1(bean);
      return base1;
   }

   public List getBaseInfo2(final String uniqueRowid) {
      final String sql = "{call KINGSTAR.P7201103015_VW_02(?,?,?,?)}";
      final ArrayList list = new ArrayList();
      this.getJdbcTemplate().execute(new CallableStatementCreator() {
         public CallableStatement createCallableStatement(Connection con) throws SQLException {
            CallableStatement cs = con.prepareCall(sql);
            cs.registerOutParameter(1, 2012);
            cs.setString(2, uniqueRowid);
            cs.registerOutParameter(3, 4);
            cs.registerOutParameter(4, 12);
            return cs;
         }
      }, new CallableStatementCallback() {
         public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
            cs.execute();
            Integer code = Integer.valueOf(cs.getInt(3));
            String msg = cs.getString(4);
            ResultSet rs = (ResultSet)cs.getObject(1);

            while(rs.next()) {
               BaseInfo2Bean b = new BaseInfo2Bean();
               b.setStockHolder(rs.getString("STOCKHOLDER"));
               b.setHoldStock(rs.getString("HOLD_STOCK"));
               list.add(b);
            }

            rs.close();
            return null;
         }
      });
      return list;
   }

   public List getInnerCtrl(final String uniqueRowid) {
      final String sql = "{call KINGSTAR.P7201103025_VW_02(?,?,?,?)}";
      final ArrayList list = new ArrayList();
      this.getJdbcTemplate().execute(new CallableStatementCreator() {
         public CallableStatement createCallableStatement(Connection con) throws SQLException {
            CallableStatement cs = con.prepareCall(sql);
            cs.registerOutParameter(1, 2012);
            cs.setString(2, uniqueRowid);
            cs.registerOutParameter(3, 4);
            cs.registerOutParameter(4, 12);
            return cs;
         }
      }, new CallableStatementCallback() {
         public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
            cs.execute();
            Integer code = Integer.valueOf(cs.getInt(3));
            String msg = cs.getString(4);
            ResultSet rs = (ResultSet)cs.getObject(1);

            while(rs.next()) {
               InnerCtrlBean b = new InnerCtrlBean();
               b.setOrderNumber(rs.getString("ORDER_NUMBER"));
               b.setName(rs.getString("NAME"));
               b.setImplementTime(rs.getString("IMPLEMENT_TIME"));
               b.setUnit(rs.getString("UNIT"));
               b.setRelevantDocument(rs.getString("RELEVANT_DOCUMENT"));
               b.setIfNew(rs.getString("IF_NEW"));
               b.setIfUpdate(rs.getString("IF_UPDATE"));
               b.setIfReport(rs.getString("IF_REPORT"));
               list.add(b);
            }

            rs.close();
            return null;
         }
      });
      return list;
   }

   public InnerCtrlBeanStatusBean getInnerCtrlBeanStatus(final String uniqueRowid) {
      final String sql = "{call KINGSTAR.P7201103025_VW_01(?,?,?,?,?,?)}";
      final InnerCtrlBeanStatusBean bean = new InnerCtrlBeanStatusBean();
      this.getJdbcTemplate().execute(new CallableStatementCreator() {
         public CallableStatement createCallableStatement(Connection con) throws SQLException {
            CallableStatement cs = con.prepareCall(sql);
            cs.setString(1, uniqueRowid);
            cs.registerOutParameter(2, 12);
            cs.registerOutParameter(3, 12);
            cs.registerOutParameter(4, 12);
            cs.registerOutParameter(5, 4);
            cs.registerOutParameter(6, 12);
            return cs;
         }
      }, new CallableStatementCallback() {
         public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
            cs.execute();
            String lmtFinal = cs.getString(2);
            String lmtDown = cs.getString(3);
            String functionId = cs.getString(4);
            Integer code = Integer.valueOf(cs.getInt(5));
            String msg = cs.getString(6);
            bean.setFunctionId(functionId);
            bean.setLmtDown(lmtDown);
            bean.setLmtFinal(lmtFinal);
            return null;
         }
      });
      return bean;
   }

   public PostPersonBean getPostPerson1(final String uniqueRowid) {
      final String sql = "{call KINGSTAR.P7201103035_VW_01(?,?,?,?,?,?,?)}";
      final ArrayList list = new ArrayList();
      final PostPersonBean person1 = new PostPersonBean();
      this.getJdbcTemplate().execute(new CallableStatementCreator() {
         public CallableStatement createCallableStatement(Connection con) throws SQLException {
            CallableStatement cs = con.prepareCall(sql);
            cs.registerOutParameter(1, 2012);
            cs.setString(2, uniqueRowid);
            cs.registerOutParameter(3, 12);
            cs.registerOutParameter(4, 12);
            cs.registerOutParameter(5, 12);
            cs.registerOutParameter(6, 4);
            cs.registerOutParameter(7, 12);
            return cs;
         }
      }, new CallableStatementCallback() {
         public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
            cs.execute();
            String lmtFinal = cs.getString(3);
            String lmtDown = cs.getString(4);
            String functionId = cs.getString(5);
            Integer code = Integer.valueOf(cs.getInt(6));
            String msg = cs.getString(7);
            person1.setLmtFinal(lmtFinal);
            person1.setLmtDown(lmtDown);
            person1.setFunctionId(functionId);
            ResultSet rs = (ResultSet)cs.getObject(1);

            while(rs.next()) {
               PostPerson1Bean b = new PostPerson1Bean();
               b.setDeptName(rs.getString("DEPT_NAME"));
               b.setQxzz(rs.getString("QXZZ"));
               b.setQxzzKy(rs.getString("QXZZ_KY"));
               b.setBjjg(rs.getString("BJJG"));
               b.setBjjgKy(rs.getString("BJJG_KY"));
               b.setQxjz(rs.getString("QXJZ"));
               b.setQxjzKy(rs.getString("QXJZ_KY"));
               b.setQxzzRate(rs.getString("QXZZ_RATE"));
               b.setQxjzRate(rs.getString("QXJZ_RATE"));
               list.add(b);
            }

            rs.close();
            return null;
         }
      });
      PostPerson1Bean bean = null;
      if(list != null && !list.isEmpty()) {
         bean = (PostPerson1Bean)list.get(0);
      }

      person1.setPerson1(bean);
      return person1;
   }

   public List getPostPerson2(final String uniqueRowid) {
      final String sql = "{call KINGSTAR.P7201103035_VW_02(?,?,?,?)}";
      final ArrayList list = new ArrayList();
      this.getJdbcTemplate().execute(new CallableStatementCreator() {
         public CallableStatement createCallableStatement(Connection con) throws SQLException {
            CallableStatement cs = con.prepareCall(sql);
            cs.registerOutParameter(1, 2012);
            cs.setString(2, uniqueRowid);
            cs.registerOutParameter(3, 4);
            cs.registerOutParameter(4, 12);
            return cs;
         }
      }, new CallableStatementCallback() {
         public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
            cs.execute();
            Integer code = Integer.valueOf(cs.getInt(3));
            String msg = cs.getString(4);
            ResultSet rs = (ResultSet)cs.getObject(1);

            while(rs.next()) {
               PostPerson2Bean b = new PostPerson2Bean();
               b.setTypeName(rs.getString("TYPE_NAME"));
               b.setName(rs.getString("NAME"));
               b.setPosition(rs.getString("POSITION"));
               b.setOfficePhone(rs.getString("OFFICE_PHONE"));
               b.setTelephone(rs.getString("TELEPHONE"));
               b.setEmail(rs.getString("EMAIL"));
               b.setQualifications(rs.getString("QUALIFICATIONS"));
               b.setFinanceTime(rs.getString("FINANCE_TIME"));
               b.setFxqTime(rs.getString("FXQ_TIME"));
               list.add(b);
            }

            rs.close();
            return null;
         }
      });
      return list;
   }

   public List getCustomerRecognition(final String uniqueRowid) {
      final String sql = "{call KINGSTAR.P7201103045_VW_02(?,?,?,?)}";
      final ArrayList list = new ArrayList();
      this.getJdbcTemplate().execute(new CallableStatementCreator() {
         public CallableStatement createCallableStatement(Connection con) throws SQLException {
            CallableStatement cs = con.prepareCall(sql);
            cs.registerOutParameter(1, 2012);
            cs.setString(2, uniqueRowid);
            cs.registerOutParameter(3, 4);
            cs.registerOutParameter(4, 12);
            return cs;
         }
      }, new CallableStatementCallback() {
         public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
            cs.execute();
            Integer code = Integer.valueOf(cs.getInt(3));
            String msg = cs.getString(4);
            ResultSet rs = (ResultSet)cs.getObject(1);

            while(rs.next()) {
               CustomerRecognitionBean b = new CustomerRecognitionBean();
               b.setTotalCount(rs.getString("TOTAL_COUNT"));
               b.setOpenCount(rs.getString("OPEN_COUNT"));
               b.setCloseCount(rs.getString("CLOSE_COUNT"));
               b.setNewIdentifyCount(rs.getString("NEW_IDENTIFY_COUNT"));
               b.setRepeatIdentifyCount(rs.getString("REPEAT_IDENTIFY_COUNT"));
               b.setStopCount(rs.getString("STOP_COUNT"));
               b.setMonitorCount(rs.getString("MONITOR_COUNT"));
               b.setLimitCount(rs.getString("LIMIT_COUNT"));
               b.setFrozenCount(rs.getString("FROZEN_COUNT"));
               b.setaCount(rs.getString("A_COUNT"));
               b.setAaCount(rs.getString("AA_COUNT"));
               b.setbCount(rs.getString("B_COUNT"));
               b.setBbCount(rs.getString("BB_COUNT"));
               b.setcCount(rs.getString("C_COUNT"));
               b.setCcCount(rs.getString("CC_COUNT"));
               b.setdCount(rs.getString("D_COUNT"));
               b.setDdCount(rs.getString("DD_COUNT"));
               b.seteCount(rs.getString("E_COUNT"));
               b.setEeCount(rs.getString("EE_COUNT"));
               list.add(b);
            }

            rs.close();
            return null;
         }
      });
      return list;
   }

   public CustomerRecognitionStatusBean getCustomerRecognitionStatusBean(final String uniqueRowid) {
      final String sql = "{call KINGSTAR.P7201103045_VW_01(?,?,?,?,?,?)}";
      final CustomerRecognitionStatusBean bean = new CustomerRecognitionStatusBean();
      this.getJdbcTemplate().execute(new CallableStatementCreator() {
         public CallableStatement createCallableStatement(Connection con) throws SQLException {
            CallableStatement cs = con.prepareCall(sql);
            cs.setString(1, uniqueRowid);
            cs.registerOutParameter(2, 12);
            cs.registerOutParameter(3, 12);
            cs.registerOutParameter(4, 12);
            cs.registerOutParameter(5, 4);
            cs.registerOutParameter(6, 12);
            return cs;
         }
      }, new CallableStatementCallback() {
         public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
            cs.execute();
            String lmtFinal = cs.getString(2);
            String lmtDown = cs.getString(3);
            String functionId = cs.getString(4);
            Integer code = Integer.valueOf(cs.getInt(5));
            String msg = cs.getString(6);
            bean.setFunctionId(functionId);
            bean.setLmtDown(lmtDown);
            bean.setLmtFinal(lmtFinal);
            return null;
         }
      });
      return bean;
   }

   public LargeAndSuspiciousBean getLargeAndSuspicious(final String uniqueRowid) {
      final String sql = "{call KINGSTAR.P7201103055_VW_01(?,?,?,?,?,?,?)}";
      final ArrayList list = new ArrayList();
      final LargeAndSuspiciousBean lasbean = new LargeAndSuspiciousBean();
      this.getJdbcTemplate().execute(new CallableStatementCreator() {
         public CallableStatement createCallableStatement(Connection con) throws SQLException {
            CallableStatement cs = con.prepareCall(sql);
            cs.registerOutParameter(1, 2012);
            cs.setString(2, uniqueRowid);
            cs.registerOutParameter(3, 12);
            cs.registerOutParameter(4, 12);
            cs.registerOutParameter(5, 12);
            cs.registerOutParameter(6, 4);
            cs.registerOutParameter(7, 12);
            return cs;
         }
      }, new CallableStatementCallback() {
         public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
            cs.execute();
            String lmtFinal = cs.getString(3);
            String lmtDown = cs.getString(4);
            String functionId = cs.getString(5);
            Integer code = Integer.valueOf(cs.getInt(6));
            String msg = cs.getString(7);
            lasbean.setFunctionId(functionId);
            lasbean.setLmtDown(lmtDown);
            lasbean.setLmtFinal(lmtFinal);
            ResultSet rs = (ResultSet)cs.getObject(1);

            while(rs.next()) {
               LargeAndSuspiciousDetailBean b = new LargeAndSuspiciousDetailBean();
               b.setDeCount(rs.getString("DE_COUNT"));
               b.setDeBzCount(rs.getString("DE_BZ_COUNT"));
               b.setAnalysisCount(rs.getString("ANALYSIS_COUNT"));
               b.setKyCount(rs.getString("KY_COUNT"));
               b.setKyBzCount(rs.getString("KY_BZ_COUNT"));
               b.setBankCount(rs.getString("BANK_COUNT"));
               b.setPoliceCount(rs.getString("POLICE_COUNT"));
               list.add(b);
            }

            rs.close();
            return null;
         }
      });
      LargeAndSuspiciousDetailBean bean = null;
      if(list != null && !list.isEmpty()) {
         bean = (LargeAndSuspiciousDetailBean)list.get(0);
      }

      lasbean.setDetail(bean);
      return lasbean;
   }

   public List getPropaganda(final String uniqueRowid) {
      final String sql = "{call KINGSTAR.P7201103065_VW_02(?,?,?,?)}";
      final ArrayList list = new ArrayList();
      this.getJdbcTemplate().execute(new CallableStatementCreator() {
         public CallableStatement createCallableStatement(Connection con) throws SQLException {
            CallableStatement cs = con.prepareCall(sql);
            cs.registerOutParameter(1, 2012);
            cs.setString(2, uniqueRowid);
            cs.registerOutParameter(3, 4);
            cs.registerOutParameter(4, 12);
            return cs;
         }
      }, new CallableStatementCallback() {
         public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
            cs.execute();
            Integer code = Integer.valueOf(cs.getInt(3));
            String msg = cs.getString(4);
            ResultSet rs = (ResultSet)cs.getObject(1);

            while(rs.next()) {
               PropagandaBean b = new PropagandaBean();
               b.setJgName(rs.getString("JG_NAME"));
               b.setJoinJg(rs.getString("JOIN_JG"));
               b.setContent(rs.getString("CONTENT"));
               b.setMethods(rs.getString("METHODS"));
               b.setStartDate(rs.getString("START_DATE"));
               b.setEndDate(rs.getString("END_DATE"));
               b.setAudienceCount(rs.getString("AUDIENCE_COUNT"));
               b.setDataCount(rs.getString("DATA_COUNT"));
               b.setEffect(rs.getString("EFFECT"));
               list.add(b);
            }

            rs.close();
            return null;
         }
      });
      return list;
   }

   public PropagandaStatusBean getPropagandaStatus(final String uniqueRowid) {
      final String sql = "{call KINGSTAR.P7201103065_VW_01(?,?,?,?,?,?)}";
      final PropagandaStatusBean bean = new PropagandaStatusBean();
      this.getJdbcTemplate().execute(new CallableStatementCreator() {
         public CallableStatement createCallableStatement(Connection con) throws SQLException {
            CallableStatement cs = con.prepareCall(sql);
            cs.setString(1, uniqueRowid);
            cs.registerOutParameter(2, 12);
            cs.registerOutParameter(3, 12);
            cs.registerOutParameter(4, 12);
            cs.registerOutParameter(5, 4);
            cs.registerOutParameter(6, 12);
            return cs;
         }
      }, new CallableStatementCallback() {
         public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
            cs.execute();
            String lmtFinal = cs.getString(2);
            String lmtDown = cs.getString(3);
            String functionId = cs.getString(4);
            Integer code = Integer.valueOf(cs.getInt(5));
            String msg = cs.getString(6);
            bean.setFunctionId(functionId);
            bean.setLmtDown(lmtDown);
            bean.setLmtFinal(lmtFinal);
            return null;
         }
      });
      return bean;
   }

   public List getTrain(final String uniqueRowid) {
      final String sql = "{call KINGSTAR.P7201103075_VW_02(?,?,?,?)}";
      final ArrayList list = new ArrayList();
      this.getJdbcTemplate().execute(new CallableStatementCreator() {
         public CallableStatement createCallableStatement(Connection con) throws SQLException {
            CallableStatement cs = con.prepareCall(sql);
            cs.registerOutParameter(1, 2012);
            cs.setString(2, uniqueRowid);
            cs.registerOutParameter(3, 4);
            cs.registerOutParameter(4, 12);
            return cs;
         }
      }, new CallableStatementCallback() {
         public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
            cs.execute();
            Integer code = Integer.valueOf(cs.getInt(3));
            String msg = cs.getString(4);
            ResultSet rs = (ResultSet)cs.getObject(1);

            while(rs.next()) {
               TrainBean b = new TrainBean();
               b.setDept(rs.getString("DEPT"));
               b.setContent(rs.getString("CONTENT"));
               b.setStartDate(rs.getString("START_DATE"));
               b.setEndDate(rs.getString("END_DATE"));
               b.setMethods(rs.getString("METHODS"));
               b.setParticipants(rs.getString("PARTICIPANTS"));
               b.setDays(rs.getString("DAYS"));
               b.setPassengers(rs.getString("PASSENGERS"));
               b.setEffect(rs.getString("EFFECT"));
               list.add(b);
            }

            rs.close();
            return null;
         }
      });
      return list;
   }

   public TrainStatusBean getTrainStatus(final String uniqueRowid) {
      final String sql = "{call KINGSTAR.P7201103075_VW_01(?,?,?,?,?,?)}";
      final TrainStatusBean bean = new TrainStatusBean();
      this.getJdbcTemplate().execute(new CallableStatementCreator() {
         public CallableStatement createCallableStatement(Connection con) throws SQLException {
            CallableStatement cs = con.prepareCall(sql);
            cs.setString(1, uniqueRowid);
            cs.registerOutParameter(2, 12);
            cs.registerOutParameter(3, 12);
            cs.registerOutParameter(4, 12);
            cs.registerOutParameter(5, 4);
            cs.registerOutParameter(6, 12);
            return cs;
         }
      }, new CallableStatementCallback() {
         public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
            cs.execute();
            String lmtFinal = cs.getString(2);
            String lmtDown = cs.getString(3);
            String functionId = cs.getString(4);
            Integer code = Integer.valueOf(cs.getInt(5));
            String msg = cs.getString(6);
            bean.setFunctionId(functionId);
            bean.setLmtDown(lmtDown);
            bean.setLmtFinal(lmtFinal);
            return null;
         }
      });
      return bean;
   }

   public List getInternalInspection(final String uniqueRowid) {
      final String sql = "{call KINGSTAR.P7201103085_VW_02(?,?,?,?)}";
      final ArrayList list = new ArrayList();
      this.getJdbcTemplate().execute(new CallableStatementCreator() {
         public CallableStatement createCallableStatement(Connection con) throws SQLException {
            CallableStatement cs = con.prepareCall(sql);
            cs.registerOutParameter(1, 2012);
            cs.setString(2, uniqueRowid);
            cs.registerOutParameter(3, 4);
            cs.registerOutParameter(4, 12);
            return cs;
         }
      }, new CallableStatementCallback() {
         public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
            cs.execute();
            Integer code = Integer.valueOf(cs.getInt(3));
            String msg = cs.getString(4);
            ResultSet rs = (ResultSet)cs.getObject(1);

            while(rs.next()) {
               InternalInspectionBean b = new InternalInspectionBean();
               b.setOrderNumber(rs.getString("ORDER_NUMBER"));
               b.setStartDate(rs.getString("START_DATE"));
               b.setEndDate(rs.getString("END_DATE"));
               b.setMainDept(rs.getString("MAIN_DEPT"));
               b.setBeCheckedDept(rs.getString("BE_CHECKED_DEPT"));
               b.setProblem(rs.getString("PROBLEM"));
               b.setRectify(rs.getString("RECTIFY"));
               b.setIfInner(rs.getString("IF_INNER"));
               list.add(b);
            }

            rs.close();
            return null;
         }
      });
      return list;
   }

   public InternalInspectionStatusBean getInternalInspectionStatus(final String uniqueRowid) {
      final String sql = "{call KINGSTAR.P7201103085_VW_01(?,?,?,?,?,?)}";
      final InternalInspectionStatusBean bean = new InternalInspectionStatusBean();
      this.getJdbcTemplate().execute(new CallableStatementCreator() {
         public CallableStatement createCallableStatement(Connection con) throws SQLException {
            CallableStatement cs = con.prepareCall(sql);
            cs.setString(1, uniqueRowid);
            cs.registerOutParameter(2, 12);
            cs.registerOutParameter(3, 12);
            cs.registerOutParameter(4, 12);
            cs.registerOutParameter(5, 4);
            cs.registerOutParameter(6, 12);
            return cs;
         }
      }, new CallableStatementCallback() {
         public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
            cs.execute();
            String lmtFinal = cs.getString(2);
            String lmtDown = cs.getString(3);
            String functionId = cs.getString(4);
            Integer code = Integer.valueOf(cs.getInt(5));
            String msg = cs.getString(6);
            bean.setFunctionId(functionId);
            bean.setLmtDown(lmtDown);
            bean.setLmtFinal(lmtFinal);
            return null;
         }
      });
      return bean;
   }

   public List getAdministrativeInvestigation(final String uniqueRowid) {
      final String sql = "{call KINGSTAR.P7201103095_VW_02(?,?,?,?)}";
      final ArrayList list = new ArrayList();
      this.getJdbcTemplate().execute(new CallableStatementCreator() {
         public CallableStatement createCallableStatement(Connection con) throws SQLException {
            CallableStatement cs = con.prepareCall(sql);
            cs.registerOutParameter(1, 2012);
            cs.setString(2, uniqueRowid);
            cs.registerOutParameter(3, 4);
            cs.registerOutParameter(4, 12);
            return cs;
         }
      }, new CallableStatementCallback() {
         public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
            cs.execute();
            Integer code = Integer.valueOf(cs.getInt(3));
            String msg = cs.getString(4);
            ResultSet rs = (ResultSet)cs.getObject(1);

            while(rs.next()) {
               AdministrativeInvestigationBean b = new AdministrativeInvestigationBean();
               b.setIfInner(rs.getString("IF_INNER"));
               b.setDept(rs.getString("DEPT"));
               b.setCoDept(rs.getString("CO_DEPT"));
               b.setFinishDate(rs.getString("FINISH_DATE"));
               b.setIfOnTime(rs.getString("IF_ON_TIME"));
               list.add(b);
            }

            rs.close();
            return null;
         }
      });
      return list;
   }

   public AdInStatusBean getAdInStatus(final String uniqueRowid) {
      final String sql = "{call KINGSTAR.P7201103095_VW_01(?,?,?,?,?,?)}";
      final AdInStatusBean bean = new AdInStatusBean();
      this.getJdbcTemplate().execute(new CallableStatementCreator() {
         public CallableStatement createCallableStatement(Connection con) throws SQLException {
            CallableStatement cs = con.prepareCall(sql);
            cs.setString(1, uniqueRowid);
            cs.registerOutParameter(2, 12);
            cs.registerOutParameter(3, 12);
            cs.registerOutParameter(4, 12);
            cs.registerOutParameter(5, 4);
            cs.registerOutParameter(6, 12);
            return cs;
         }
      }, new CallableStatementCallback() {
         public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
            cs.execute();
            String lmtFinal = cs.getString(2);
            String lmtDown = cs.getString(3);
            String functionId = cs.getString(4);
            Integer code = Integer.valueOf(cs.getInt(5));
            String msg = cs.getString(6);
            bean.setFunctionId(functionId);
            bean.setLmtDown(lmtDown);
            bean.setLmtFinal(lmtFinal);
            return null;
         }
      });
      return bean;
   }

   public List getSiteInspection(final String uniqueRowid) {
      final String sql = "{call KINGSTAR.P7201103105_VW_02(?,?,?,?)}";
      final ArrayList list = new ArrayList();
      this.getJdbcTemplate().execute(new CallableStatementCreator() {
         public CallableStatement createCallableStatement(Connection con) throws SQLException {
            CallableStatement cs = con.prepareCall(sql);
            cs.registerOutParameter(1, 2012);
            cs.setString(2, uniqueRowid);
            cs.registerOutParameter(3, 4);
            cs.registerOutParameter(4, 12);
            return cs;
         }
      }, new CallableStatementCallback() {
         public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
            cs.execute();
            Integer code = Integer.valueOf(cs.getInt(3));
            String msg = cs.getString(4);
            ResultSet rs = (ResultSet)cs.getObject(1);

            while(rs.next()) {
               SiteInspectionBean b = new SiteInspectionBean();
               b.setCheckNumber(rs.getString("CHECK_NUMBER"));
               b.setStartDate(rs.getString("START_DATA"));
               b.setEndDate(rs.getString("END_DATA"));
               b.setZcDept(rs.getString("ZC_DEPT"));
               b.setBcDept(rs.getString("BC_DEPT"));
               b.setQuestion(rs.getString("QUESTION"));
               b.setCfjeJg(rs.getString("CFJE_JG"));
               b.setCgCount(rs.getString("CG_COUNT"));
               b.setCfjeGr(rs.getString("CFJE_GR"));
               b.setRectify(rs.getString("RECTIFY"));
               list.add(b);
            }

            rs.close();
            return null;
         }
      });
      return list;
   }

   public SiteInspectionStatusBean getSiteInspectionStatus(final String uniqueRowid) {
      final String sql = "{call KINGSTAR.P7201103105_VW_01(?,?,?,?,?,?)}";
      final SiteInspectionStatusBean bean = new SiteInspectionStatusBean();
      this.getJdbcTemplate().execute(new CallableStatementCreator() {
         public CallableStatement createCallableStatement(Connection con) throws SQLException {
            CallableStatement cs = con.prepareCall(sql);
            cs.setString(1, uniqueRowid);
            cs.registerOutParameter(2, 12);
            cs.registerOutParameter(3, 12);
            cs.registerOutParameter(4, 12);
            cs.registerOutParameter(5, 4);
            cs.registerOutParameter(6, 12);
            return cs;
         }
      }, new CallableStatementCallback() {
         public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
            cs.execute();
            String lmtFinal = cs.getString(2);
            String lmtDown = cs.getString(3);
            String functionId = cs.getString(4);
            Integer code = Integer.valueOf(cs.getInt(5));
            String msg = cs.getString(6);
            bean.setFunctionId(functionId);
            bean.setLmtDown(lmtDown);
            bean.setLmtFinal(lmtFinal);
            return null;
         }
      });
      return bean;
   }

   public List getRiskCtrl(final String uniqueRowid) {
      final String sql = "{call KINGSTAR.P7201103115_VW_02(?,?,?,?)}";
      final ArrayList list = new ArrayList();
      this.getJdbcTemplate().execute(new CallableStatementCreator() {
         public CallableStatement createCallableStatement(Connection con) throws SQLException {
            CallableStatement cs = con.prepareCall(sql);
            cs.registerOutParameter(1, 2012);
            cs.setString(2, uniqueRowid);
            cs.registerOutParameter(3, 4);
            cs.registerOutParameter(4, 12);
            return cs;
         }
      }, new CallableStatementCallback() {
         public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
            cs.execute();
            Integer code = Integer.valueOf(cs.getInt(3));
            String msg = cs.getString(4);
            ResultSet rs = (ResultSet)cs.getObject(1);

            while(rs.next()) {
               RiskCtrlBean b = new RiskCtrlBean();
               b.setRiskName(rs.getString("RISK_NAME"));
               b.setFxjg(rs.getString("FXJG"));
               b.setStartTime(rs.getString("START_TIME"));
               b.setEndTime(rs.getString("END_TIME"));
               b.setBaseInfo(rs.getString("BASE_INFO"));
               b.setEffect(rs.getString("EFFECT"));
               b.setIfReport(rs.getString("IF_REPORT"));
               list.add(b);
            }

            rs.close();
            return null;
         }
      });
      return list;
   }

   public RiskCtrlStatusBean getRiskCtrlStatus(final String uniqueRowid) {
      final String sql = "{call KINGSTAR.P7201103115_VW_01(?,?,?,?,?,?)}";
      final RiskCtrlStatusBean bean = new RiskCtrlStatusBean();
      this.getJdbcTemplate().execute(new CallableStatementCreator() {
         public CallableStatement createCallableStatement(Connection con) throws SQLException {
            CallableStatement cs = con.prepareCall(sql);
            cs.setString(1, uniqueRowid);
            cs.registerOutParameter(2, 12);
            cs.registerOutParameter(3, 12);
            cs.registerOutParameter(4, 12);
            cs.registerOutParameter(5, 4);
            cs.registerOutParameter(6, 12);
            return cs;
         }
      }, new CallableStatementCallback() {
         public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
            cs.execute();
            String lmtFinal = cs.getString(2);
            String lmtDown = cs.getString(3);
            String functionId = cs.getString(4);
            Integer code = Integer.valueOf(cs.getInt(5));
            String msg = cs.getString(6);
            bean.setFunctionId(functionId);
            bean.setLmtDown(lmtDown);
            bean.setLmtFinal(lmtFinal);
            return null;
         }
      });
      return bean;
   }

   public List getAbroadBranch(final String uniqueRowid) {
      final String sql = "{call KINGSTAR.P7201103125_VW_02(?,?,?,?)}";
      final ArrayList list = new ArrayList();
      this.getJdbcTemplate().execute(new CallableStatementCreator() {
         public CallableStatement createCallableStatement(Connection con) throws SQLException {
            CallableStatement cs = con.prepareCall(sql);
            cs.registerOutParameter(1, 2012);
            cs.setString(2, uniqueRowid);
            cs.registerOutParameter(3, 4);
            cs.registerOutParameter(4, 12);
            return cs;
         }
      }, new CallableStatementCallback() {
         public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
            cs.execute();
            Integer code = Integer.valueOf(cs.getInt(3));
            String msg = cs.getString(4);
            ResultSet rs = (ResultSet)cs.getObject(1);

            while(rs.next()) {
               AbroadBranchBean b = new AbroadBranchBean();
               b.setOrderNumber(rs.getString("ORDER_NUMBER"));
               b.setName(rs.getString("NAME"));
               b.setCountry(rs.getString("COUNTRY"));
               b.setImplementTime(rs.getString("IMPLEMENT_TIME"));
               b.setUnitType(rs.getString("UNIT_TYPE"));
               b.setOutletsNumber(rs.getString("OUTLETS_NUMBER"));
               b.setLocalManage(rs.getString("LOCAL_MANAGE"));
               b.setRuledInfo(rs.getString("RULED_INFO"));
               b.setPunishInfo(rs.getString("PUNISH_INFO"));
               b.setOthers(rs.getString("OTHERS"));
               b.setIfSin(rs.getString("IF_SIN"));
               list.add(b);
            }

            rs.close();
            return null;
         }
      });
      return list;
   }

   public AbroadBranchStatusBean getAbroadBranchStatus(final String uniqueRowid) {
      final String sql = "{call KINGSTAR.P7201103125_VW_01(?,?,?,?,?,?)}";
      final AbroadBranchStatusBean bean = new AbroadBranchStatusBean();
      this.getJdbcTemplate().execute(new CallableStatementCreator() {
         public CallableStatement createCallableStatement(Connection con) throws SQLException {
            CallableStatement cs = con.prepareCall(sql);
            cs.setString(1, uniqueRowid);
            cs.registerOutParameter(2, 12);
            cs.registerOutParameter(3, 12);
            cs.registerOutParameter(4, 12);
            cs.registerOutParameter(5, 4);
            cs.registerOutParameter(6, 12);
            return cs;
         }
      }, new CallableStatementCallback() {
         public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
            cs.execute();
            String lmtFinal = cs.getString(2);
            String lmtDown = cs.getString(3);
            String functionId = cs.getString(4);
            Integer code = Integer.valueOf(cs.getInt(5));
            String msg = cs.getString(6);
            bean.setFunctionId(functionId);
            bean.setLmtDown(lmtDown);
            bean.setLmtFinal(lmtFinal);
            return null;
         }
      });
      return bean;
   }

   public MsgBean finalText(final String uniqueRowid, final String opType, final String lmtFinal, final String functionId, final String userCode) {
      final String sql = "{call KINGSTAR.P_OFST_COMM_OPT(?,?,?,?,?,?,?,?)}";
      final MsgBean bean = new MsgBean();
      this.getJdbcTemplate().execute(new CallableStatementCreator() {
         public CallableStatement createCallableStatement(Connection con) throws SQLException {
            CallableStatement cs = con.prepareCall(sql);
            cs.setString(1, uniqueRowid);
            cs.setString(2, opType);
            cs.setString(3, lmtFinal);
            cs.setLong(4, (new Long(functionId)).longValue());
            cs.setString(5, userCode);
            cs.setString(6, (String)null);
            cs.registerOutParameter(7, 4);
            cs.registerOutParameter(8, 12);
            return cs;
         }
      }, new CallableStatementCallback() {
         public Object doInCallableStatement(CallableStatement cs) throws SQLException, DataAccessException {
            cs.execute();
            Integer code = Integer.valueOf(cs.getInt(7));
            String msg = cs.getString(8);
            bean.setCode(code);
            bean.setMsg(msg);
            return null;
         }
      });
      return bean;
   }
}
