package com.rw.major.dao;

import com.rw.dao.BaseDAOImpl;
import com.rw.major.dao.BlacklistDao;
import com.rw.major.model.BlacklistQEBean;
import com.rw.major.model.BlacklistQIBean;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.stereotype.Repository;

@Repository
public class BlacklistDaoImpl extends BaseDAOImpl implements BlacklistDao {

   public void saveQIBlacklist(final List qilist) {
      String sql = "insert into amldata.t_blacklist_qi(qino, name, originalname, title, designation, dob, pob, gqaka, lqaka,nationality, passportno, nationalidno, address, listedon, otherinfo) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
      Object result = null;
      this.getJdbcTemplate().batchUpdate(sql, new BatchPreparedStatementSetter() {
         public void setValues(PreparedStatement ps, int index) throws SQLException {
            BlacklistQIBean bean = (BlacklistQIBean)qilist.get(index);
            ps.setString(1, bean.getQino());
            ps.setString(2, bean.getName());
            ps.setString(3, bean.getOriginalname());
            ps.setString(4, bean.getTitle());
            ps.setString(5, bean.getDesignation());
            ps.setString(6, bean.getDob());
            ps.setString(7, bean.getPob());
            ps.setString(8, bean.getGqaka());
            ps.setString(9, bean.getLqaka());
            ps.setString(10, bean.getNationality());
            ps.setString(11, bean.getPassportno());
            ps.setString(12, bean.getNationalidno());
            ps.setString(13, bean.getAddress());
            ps.setString(14, bean.getListedon());
            ps.setString(15, bean.getOtherinfo());
         }
         public int getBatchSize() {
            return qilist.size();
         }
      });
   }

   public void saveQEBlacklist(final List qelist) {
      String sql = "insert into amldata.t_blacklist_qe(qeno, name, originalname, aka, fka, address, listedon, otherinfo) values (?,?,?,?,?,?,?,?)";
      Object result = null;
      this.getJdbcTemplate().batchUpdate(sql, new BatchPreparedStatementSetter() {
         public void setValues(PreparedStatement ps, int index) throws SQLException {
            BlacklistQEBean bean = (BlacklistQEBean)qelist.get(index);
            ps.setString(1, bean.getQeno());
            ps.setString(2, bean.getName());
            ps.setString(3, bean.getOriginalname());
            ps.setString(4, bean.getAka());
            ps.setString(5, bean.getFka());
            ps.setString(6, bean.getAddress());
            ps.setString(7, bean.getListedon());
            ps.setString(8, bean.getOtherinfo());
         }
         public int getBatchSize() {
            return qelist.size();
         }
      });
   }
}
