package com.rw.filter;

import com.donfer.serivce.Encrypt3DES;
import com.wb.common.FileBuffer;
import com.wb.common.Session;
import com.wb.common.UrlBuffer;
import com.wb.common.Var;
import com.wb.util.DateUtil;
import com.wb.util.DbExtUtil;
import com.wb.util.SysUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URLEncoder;
import java.util.Date;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GTSSOFilter implements Filter {

   private static final Logger logger = LoggerFactory.getLogger(GTSSOFilter.class);
   private static String appid;
   private static String ssoLoginUrl;
   private static StringBuffer returnMainUrl;
   private static String key;
   private static String iv;


   public void destroy() {
   }

   public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain chain) throws IOException, ServletException {
      HttpServletRequest req = (HttpServletRequest)servletRequest;
      HttpServletResponse res = (HttpServletResponse)servletResponse;
      HttpSession session = req.getSession();
      String contextPath = StringUtils.defaultIfBlank(req.getContextPath(), "");
      StringBuffer lastAccessUrl = req.getRequestURL();
      String lastAccessUrlParams = req.getQueryString();
      if(StringUtils.isNotBlank(lastAccessUrlParams)) {
         lastAccessUrl.append("?");
         lastAccessUrl.append(lastAccessUrlParams);
      }

      String loginPagePath = contextPath + "/ofLoginPage.jhtml";
      String[] var10000 = new String[]{"/wb/css", "/wb/images", "/wb/libs", "/ck/static"};
      var10000 = new String[]{".js", ".png", ".jpg", ".gif", ".css", ".jpeg"};
      String servletPath = req.getServletPath();
      String xwl = UrlBuffer.get(servletPath);
      logger.info("请求地址：{}", servletPath);
      if(!servletPath.startsWith("/verify-user") && !servletPath.startsWith("/logout") && (!StringUtils.isNotBlank(lastAccessUrlParams) || !lastAccessUrlParams.contains("/get-verify-image") && !lastAccessUrlParams.contains("OA-interface")) && (!StringUtils.isNotBlank(lastAccessUrlParams) || !lastAccessUrlParams.contains("_token"))) {
         String ticket;
         if(xwl == null) {
            ticket = servletPath.toLowerCase();
            if(!ticket.startsWith("/wb/modules/") && !ticket.startsWith("/wb/system/")) {
               if(Var.cacheEnabled && ticket.startsWith("/wb/")) {
                  FileBuffer.service(servletPath, req, res);
               } else {
                  chain.doFilter(req, res);
               }
            } else {
               res.sendError(403, servletPath);
            }
         } else if(session.getAttribute("sys.username") == null) {
            logger.info("Session不存在,，获取SSO信息！");
            ticket = req.getParameter("SSO");
            String flag = req.getParameter("flag");
            logger.info("SSO信息:ticket=" + ticket + ",flag=" + flag);
            Encrypt3DES desenc = new Encrypt3DES();
            String createtime;
            if(!StringUtils.isNotBlank(flag)) {
               returnMainUrl = req.getRequestURL();
               if(StringUtils.contains(returnMainUrl.toString(), "ofLoginPage")) {
                  chain.doFilter(servletRequest, servletResponse);
               } else {
                  if(StringUtils.isNotBlank(req.getQueryString())) {
                     returnMainUrl.append("?").append(req.getQueryString());
                  }

                  logger.info("无SSO令牌信息，转到SSO登录界面,当前请求地址：" + returnMainUrl.toString());
                  createtime = DateUtil.format(new Date(), "yyyy-MM-dd");
                  String sparams1 = appid + "$" + desenc.encode3DES(createtime + "|" + returnMainUrl.toString(), key, iv);
                  res.sendRedirect(ssoLoginUrl + "?SSO=" + URLEncoder.encode(sparams1, "UTF-8"));
               }
            } else {
               createtime = null;
               if("0".equals(flag) && StringUtils.isNotBlank(ticket)) {
                  boolean sparams = false;
                  ConcurrentHashMap varMap = null;

                  label159: {
                     try {
                        varMap = new ConcurrentHashMap();
                        req.setAttribute("sys.varMap", varMap);
                        String e = desenc.decode3DES(ticket, key, iv);
                        String[] writer1 = e.split("\\|");
                        if(writer1.length > 0) {
                           createtime = writer1[0];
                        }

                        logger.info("SSO登录用户username=" + createtime);
                        req.setAttribute("username", createtime);
                        req.setAttribute("redirect", lastAccessUrl.toString());
                        Session.verifySSO(req, res);
                        break label159;
                     } catch (Exception var27) {
                        sparams = true;
                        logger.error("单点登录失败：本系统验证用户时失败【" + var27.getMessage() + "】");
                        res.addHeader("Pragma", "no-cache");
                        res.addHeader("Cache-Control", "no-cache");
                        res.addDateHeader("Expires", 0L);
                        res.setContentType("text/html;charset=utf-8");
                        PrintWriter writer = res.getWriter();
                        writer.write(SysUtil.getRootError(var27));
                        writer.close();
                     } finally {
                        DbExtUtil.closeObjects(varMap, sparams);
                     }

                     return;
                  }

                  logger.info("SSO登录成功，将用户ID：[" + createtime + "]存入当前会话session中，系统跳转到：" + lastAccessUrl);
                  chain.doFilter(servletRequest, servletResponse);
               } else {
                  logger.info("SSO登录失败，转到CK登录界面");
                  res.sendRedirect(loginPagePath);
               }
            }
         } else {
            logger.info("Session存在,用户名={}", session.getAttribute("sys.username"));
            chain.doFilter(servletRequest, servletResponse);
         }
      } else {
         chain.doFilter(servletRequest, servletResponse);
      }
   }

   public void init(FilterConfig config) throws ServletException {
      appid = config.getInitParameter("appid");
      ssoLoginUrl = config.getInitParameter("sso_login_url");
      key = config.getInitParameter("key");
      iv = config.getInitParameter("iv");
   }

}
