package com.rw.email.service;

import com.rw.dao.BaseDAO;
import com.rw.email.service.EmailService;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service("emailService")
public class EmailServiceImpl implements EmailService {

   @Autowired
   private BaseDAO baseDAO;


   public List getEmails(String sql) throws RuntimeException {
      return this.baseDAO.findList(sql);
   }

   public Map getData(String sql) throws RuntimeException {
      return this.baseDAO.findOne(sql);
   }

   public boolean updateSendedState(String sql, Object ... params) throws RuntimeException {
      return this.baseDAO.update(sql, params) >= 1;
   }

   public int savaLog(String sql, Object ... params) throws RuntimeException {
      return this.baseDAO.insert(sql, params);
   }

   public Map getVolckerReport(String spname, List args) throws RuntimeException {
      return this.baseDAO.querySp(spname, args);
   }

   public Map getState(String spname, List args) throws RuntimeException {
      return this.baseDAO.querySp(spname, args);
   }
}
