package com.rw.dao.assist;

import com.rw.model.sp.ProcedureArgument;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import org.springframework.jdbc.core.CallableStatementCreator;

public class CallableStatementCreatorImpl implements CallableStatementCreator {

   private List arguments;
   private String sql;


   public CallableStatementCreatorImpl(String sql, List arguments) {
      this.arguments = arguments;
      this.sql = sql;
   }

   public CallableStatement createCallableStatement(Connection conn) {
      CallableStatement cstmt = null;

      try {
         cstmt = conn.prepareCall(this.sql);
         int e = 1;

         for(Iterator var5 = this.arguments.iterator(); var5.hasNext(); ++e) {
            ProcedureArgument argument = (ProcedureArgument)var5.next();
            if("in".equalsIgnoreCase(argument.getDirection())) {
               cstmt.setObject(argument.getIndex() != 0?argument.getIndex():e, argument.getDefaultValue());
            } else {
               cstmt.registerOutParameter(argument.getIndex() != 0?argument.getIndex():e, argument.getDataType().intValue());
            }
         }

         return cstmt;
      } catch (SQLException var6) {
         throw new RuntimeException("查询错误[createCallableStatement]:" + var6.getMessage());
      } catch (Exception var7) {
         throw new RuntimeException("查询错误[doInCallableStatement]:" + var7.getMessage());
      }
   }
}
