package com.rw.dao.assist;

import com.rw.model.sp.ProcedureArgument;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.CallableStatementCallback;

public class CallableStatementCallbackImpl implements CallableStatementCallback {

   private List arguments;


   public CallableStatementCallbackImpl(List arguments) {
      this.arguments = arguments;
   }

   public Object doInCallableStatement(CallableStatement cs) {
      HashMap resultData = null;

      try {
         cs.execute();
         resultData = new HashMap();
         int e = 1;

         for(Iterator var5 = this.arguments.iterator(); var5.hasNext(); ++e) {
            ProcedureArgument argument = (ProcedureArgument)var5.next();
            if("out".equalsIgnoreCase(argument.getDirection())) {
               if(2012 != argument.getDataType().intValue() && -10 != argument.getDataType().intValue()) {
                  if(argument.getDataType().intValue() == 4 && !StringUtils.equalsIgnoreCase("O_TOTAL_COUNT", argument.getArgName())) {
                     resultData.put("O_RETURN_CODE", cs.getObject(argument.getIndex() != 0?argument.getIndex():e));
                  } else if(argument.getDataType().intValue() == 4 && StringUtils.equalsIgnoreCase("O_TOTAL_COUNT", argument.getArgName())) {
                     resultData.put("total", cs.getObject(argument.getIndex() != 0?argument.getIndex():e));
                  } else {
                     resultData.put("O_RETURN_MSG", StringUtils.trim(String.valueOf(cs.getObject(argument.getIndex() != 0?argument.getIndex():e))));
                  }

                  if(!StringUtils.equalsIgnoreCase(argument.getArgName(), "O_RETURN_CODE") && !StringUtils.equalsIgnoreCase(argument.getArgName(), "O_RETURN_MSG")) {
                     resultData.put(argument.getArgName(), cs.getObject(argument.getIndex() != 0?argument.getIndex():e));
                  }
               } else {
                  ResultSet rs = (ResultSet)cs.getObject(argument.getIndex() != 0?argument.getIndex():e);
                  ArrayList dataList = new ArrayList();

                  while(rs != null && rs.next()) {
                     HashMap rowData = new HashMap();
                     ResultSetMetaData rsmd = rs.getMetaData();
                     int columnCount = rsmd.getColumnCount();

                     for(int i = 1; i <= columnCount; ++i) {
                        if(rsmd.getColumnType(i) == 2005) {
                           Clob clob = rs.getClob(i);
                           if(clob != null && (int)clob.length() > 0) {
                              rowData.put(rsmd.getColumnName(i).toUpperCase(), clob.getSubString(1L, (int)clob.length()));
                           }
                        } else {
                           rowData.put(rsmd.getColumnName(i).toUpperCase(), rs.getObject(i));
                        }
                     }

                     dataList.add(rowData);
                  }

                  resultData.put("data", dataList);
               }
            }
         }
      } catch (SQLException var21) {
         throw new RuntimeException("查询错误[doInCallableStatement]:" + var21.getMessage());
      } catch (Exception var22) {
         throw new RuntimeException("查询错误[doInCallableStatement]:" + var22.getMessage());
      } finally {
         if(cs != null) {
            try {
               cs.close();
               cs = null;
            } catch (SQLException var20) {
               throw new RuntimeException("查询错误[doInCallableStatement]:" + var20.getMessage());
            }
         }

      }

      return resultData;
   }
}
