package com.rw.dao;

import com.rw.dao.BaseDAOImpl;
import com.rw.dao.FileDAO;
import com.rw.model.FileModel;
import com.wb.common.Base;
import com.wb.common.Var;
import com.wb.util.LogUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Repository;

@Repository("fileDAO")
public class FileDAOImpl extends BaseDAOImpl implements FileDAO {

   public List getFiles(String sql) throws Exception {
      Connection conn = null;
      PreparedStatement st = null;
      ResultSet rs = null;
      ArrayList filePath = null;
      InputStream is = null;

      ArrayList var13;
      try {
         conn = this.getConnection();
         st = conn.prepareStatement(sql);
         rs = st.executeQuery();
         if(rs != null) {
            filePath = new ArrayList();

            while(rs.next()) {
               String e = rs.getString("FILE_NAME");
               String fileType = rs.getString("FILE_TYPE");
               is = rs.getBinaryStream("FILE_DATA");
               String downloadFilePath = Var.getString("sys.controls.downloadFile");
               File tempFile = null;
               if(StringUtils.isNotBlank(downloadFilePath)) {
                  tempFile = new File(downloadFilePath + File.separatorChar + e);
               } else {
                  tempFile = new File(Base.path, "template" + File.separatorChar + "tempFile" + File.separatorChar + e);
               }

               if(is != null) {
                  FileOutputStream outputStream = new FileOutputStream(tempFile);
                  IOUtils.copy(is, outputStream);
                  is.close();
                  outputStream.close();
                  filePath.add(tempFile.getPath());
               }
            }
         }

         var13 = filePath;
      } catch (Exception var20) {
         LogUtil.error(var20.getMessage());
         throw new RuntimeException(var20);
      } finally {
         try {
            rs.close();
            st.close();
            conn.close();
         } catch (SQLException var19) {
            LogUtil.error(var19.getMessage());
            throw new RuntimeException(var19);
         }
      }

      return var13;
   }

   public List getFilesByObjectId(String objectId) throws Exception {
      return this.getFileFromDB(objectId);
   }

   public FileModel getFilesById(String Id) throws Exception {
      return this.getFileByIdFromDB(Id);
   }
}
