package com.rw.dao;

import com.rw.annotation.SystemDaoLog;
import com.rw.dao.BaseDAOImpl;
import com.rw.dao.ExcelDao;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository("excelDao")
public class ExcelDaoImpl extends BaseDAOImpl implements ExcelDao {

   @Autowired
   private JdbcTemplate jdbcTemplate;


   @SystemDaoLog(
      description = "批量导入数据"
   )
   public int batchUpdateSql(List sqlList) throws RuntimeException {
      String[] sqlArr = (String[])sqlList.toArray(new String[sqlList.size()]);
      int[] i = this.jdbcTemplate.batchUpdate(sqlArr);
      return i.length;
   }
}
