package com.rw.dao;

import com.rw.dao.BaseDAO;
import com.rw.dao.assist.CallableStatementCallbackImpl;
import com.rw.dao.assist.CallableStatementCreatorImpl;
import com.rw.model.FileModel;
import com.rw.util.DbKit;
import com.wb.util.DbUtil;
import com.wb.util.LogUtil;
import com.xiaoleilu.hutool.date.DateUtil;
import com.xiaoleilu.hutool.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Repository;

@Repository("baseDAO")
public class BaseDAOImpl implements BaseDAO {

   private static final Logger logger = LoggerFactory.getLogger(BaseDAOImpl.class);
   private JdbcTemplate jdbcTemplate;


   @Autowired
   public void setJdbcTemplate(JdbcTemplate jdbcTemplate) {
      this.jdbcTemplate = jdbcTemplate;
   }

   public JdbcTemplate getJdbcTemplate() {
      return this.jdbcTemplate;
   }

   public List findList(String sql) throws RuntimeException {
      List result = null;

      try {
         result = this.jdbcTemplate.queryForList(sql);
         return result;
      } catch (DataAccessException var4) {
         logger.error(var4.getMessage());
         throw new RuntimeException(var4.getMessage());
      }
   }

   public List findList(String sql, Object ... args) throws RuntimeException {
      try {
         return this.jdbcTemplate.queryForList(sql, args);
      } catch (DataAccessException var4) {
         logger.error(var4.getMessage());
         throw new RuntimeException(var4.getMessage());
      }
   }

   public Long count(String sql, Object ... args) throws RuntimeException {
      return Long.valueOf(this.jdbcTemplate.queryForLong(sql, args));
   }

   public Map findList(String sql, int currentPage, int pageSize, Object ... args) throws RuntimeException {
      String countsql = "select count(*) as ctnt from (" + sql + ") t";
      Long count = this.count(countsql, args);
      String pagingSql = DbKit.getPageSQL(sql, currentPage, pageSize);
      List dataList = this.findList(pagingSql, args);
      HashMap result = new HashMap();
      result.put("total", count);
      result.put("data", dataList);
      return result;
   }

   public Map findOne(String sql) throws RuntimeException {
      return this.jdbcTemplate.queryForMap(sql);
   }

   public Map findOne(String sql, Object ... args) throws RuntimeException {
      return this.jdbcTemplate.queryForMap(sql, args);
   }

   public int insert(String sql) throws RuntimeException {
      return this.jdbcTemplate.update(sql);
   }

   public int insert(String sql, Object ... args) throws RuntimeException {
      return this.jdbcTemplate.update(sql, args);
   }

   public int update(String sql) throws RuntimeException {
      return this.insert(sql);
   }

   public int update(String sql, Object ... args) throws RuntimeException {
      return this.insert(sql, args);
   }

   public int del(String sql) throws RuntimeException {
      return this.jdbcTemplate.update(sql);
   }

   public int del(String sql, Object ... args) throws RuntimeException {
      return this.jdbcTemplate.update(sql, args);
   }

   public Map querySp(String spName, List arguments) throws RuntimeException {
      String finalSql = DbKit.callSp(spName, arguments.size());
      Map result = (Map)this.jdbcTemplate.execute(new CallableStatementCreatorImpl(finalSql, arguments), new CallableStatementCallbackImpl(arguments));
      return result;
   }

   public List querySpOnlyCusor(String spName, List arguments) throws RuntimeException {
      String finalSql = DbKit.callSp(spName, arguments.size());
      Map result = (Map)this.jdbcTemplate.execute(new CallableStatementCreatorImpl(finalSql, arguments), new CallableStatementCallbackImpl(arguments));
      return (List)result.get("total");
   }

   public Connection getConnection() throws RuntimeException {
      try {
         Connection e = this.jdbcTemplate.getDataSource().getConnection();
         DbUtil.buffer.put(DateUtil.now(), e);
         return e;
      } catch (SQLException var2) {
         throw new RuntimeException("获取不到连接[getConnection]:" + var2.getMessage());
      }
   }

   public int batchUpdateSql(List sqlList) throws RuntimeException {
      String[] sqlArr = (String[])sqlList.toArray(new String[sqlList.size()]);
      int[] i = this.jdbcTemplate.batchUpdate(sqlArr);
      return i.length;
   }

   public int[] batchUpdateSql(String sql, List dataList, List colNameList) throws RuntimeException {
      ArrayList batchArgs = new ArrayList(dataList.size());
      int colSize = colNameList.size();
      Iterator var7 = dataList.iterator();

      while(var7.hasNext()) {
         Map data = (Map)var7.next();
         Object[] batchArg = new Object[colSize];

         for(int index = 0; index < colSize; ++index) {
            batchArg[index] = data.get(colNameList.get(index));
         }

         batchArgs.add(batchArg);
      }

      return this.jdbcTemplate.batchUpdate(sql, batchArgs);
   }

   public List getFileFromDB(String objectId) throws RuntimeException {
      StringBuilder sql = new StringBuilder();
      ArrayList list = new ArrayList();
      sql.append("select c.CONTENT,c.ID,f.NAME,f.CREATE_BY,f.CREATE_TIME,f.FILE_PATH,f.FILE_SIZE,f.EXTENSION from wolfdata.t_file_content c,wolfdata.t_files f where c.id = f.id and f.OBJECT_ID =?");
      Connection conn = null;
      PreparedStatement st = null;
      ResultSet rs = null;

      try {
         conn = this.getConnection();
         st = conn.prepareStatement(sql.toString());
         st.setString(1, objectId);
         rs = st.executeQuery();
         if(rs != null) {
            FileModel fileModel;
            for(; rs.next(); list.add(fileModel)) {
               fileModel = new FileModel();
               String e = rs.getString("ID");
               fileModel.setId(e);
               fileModel.setCreateBy(rs.getString("CREATE_BY"));
               fileModel.setCreateTime(rs.getDate("CREATE_TIME"));
               fileModel.setName(rs.getString("NAME"));
               fileModel.setFilePath(rs.getString("FILE_PATH"));
               fileModel.setFileSize(Long.valueOf(rs.getLong("FILE_SIZE")));
               fileModel.setExtension(rs.getString("EXTENSION"));
               String tempFileName = System.getProperty("java.io.tmpdir") + File.separator + e;
               Blob blob = rs.getBlob("CONTENT");
               if(blob != null) {
                  InputStream is = blob.getBinaryStream();
                  FileOutputStream outputStream = new FileOutputStream(tempFileName);
                  IOUtils.copy(is, outputStream);
                  is.close();
                  outputStream.close();
               }
            }

            ArrayList var14 = list;
            return var14;
         }
      } catch (Exception var22) {
         LogUtil.error(var22.getMessage());
         throw new RuntimeException(var22);
      } finally {
         try {
            rs.close();
            st.close();
            conn.close();
         } catch (SQLException var21) {
            LogUtil.error(var21.getMessage());
            throw new RuntimeException(var21);
         }
      }

      return null;
   }

   public String saveFileToDB(FileModel fileModel, File tempFile) throws SQLException, RuntimeException {
      String fileInfoSql = "insert into wolfdata.t_files(ID,OBJECT_ID,NAME,FILE_SIZE,EXTENSION,CREATE_BY,CREATE_TIME,FILE_FLAG) values(?,?,?,?,?,?,sysdate,?)";
      String sql = "insert into wolfdata.t_file_content(id,content) values(?,?)";
      Connection conn = null;
      PreparedStatement st = null;
      Object rset = null;
      boolean defaultCommit = true;

      String var11;
      try {
         conn = this.getConnection();
         conn.setAutoCommit(false);
         st = conn.prepareStatement(fileInfoSql);
         st.setString(1, fileModel.getId());
         st.setString(2, fileModel.getObjectId());
         st.setString(3, fileModel.getName());
         st.setDouble(4, (double)fileModel.getFileSize().longValue());
         st.setString(5, fileModel.getExtension());
         st.setString(6, fileModel.getCreateBy());
         st.setString(7, fileModel.getFileFlag());
         st.executeUpdate();
         st.close();
         FileInputStream e = new FileInputStream(tempFile);
         st = conn.prepareStatement(sql);
         st.setString(1, fileModel.getId());
         st.setBlob(2, e);
         st.executeUpdate();
         st.close();
         e.close();
         tempFile.delete();
         conn.commit();
         var11 = fileModel.getId();
      } catch (Exception var18) {
         conn.rollback();
         LogUtil.error(var18.getMessage());
         throw new RuntimeException(var18);
      } finally {
         try {
            conn.setAutoCommit(defaultCommit);
            st.close();
            conn.close();
         } catch (SQLException var17) {
            LogUtil.error(var17.getMessage());
            throw new RuntimeException(var17);
         }
      }

      return var11;
   }

   public FileModel getFileByIdFromDB(String id) throws RuntimeException {
      StringBuilder sql = new StringBuilder();
      sql.append("select c.CONTENT,c.ID,f.NAME,f.CREATE_BY,f.CREATE_TIME,f.FILE_PATH,f.FILE_SIZE,f.EXTENSION from wolfdata.t_file_content c,wolfdata.t_files f where c.id = f.id and f.id =?");
      Connection conn = null;
      PreparedStatement st = null;
      ResultSet rs = null;

      try {
         conn = this.getConnection();
         st = conn.prepareStatement(sql.toString());
         st.setString(1, id);
         rs = st.executeQuery();
         if(rs != null && rs.next()) {
            FileModel fileModel = new FileModel();
            String e = rs.getString("ID");
            fileModel.setId(e);
            fileModel.setCreateBy(rs.getString("CREATE_BY"));
            fileModel.setCreateTime(rs.getDate("CREATE_TIME"));
            fileModel.setName(rs.getString("NAME"));
            fileModel.setFilePath(rs.getString("FILE_PATH"));
            fileModel.setFileSize(Long.valueOf(rs.getLong("FILE_SIZE")));
            fileModel.setExtension(rs.getString("EXTENSION"));
            String tempFileName = System.getProperty("java.io.tmpdir") + File.separator + e;
            Blob blob = rs.getBlob("CONTENT");
            if(blob != null) {
               InputStream is = blob.getBinaryStream();
               FileOutputStream outputStream = new FileOutputStream(tempFileName);
               IOUtils.copy(is, outputStream);
               is.close();
               outputStream.close();
            } else {
               FileUtil.file(tempFileName);
            }

            FileModel var13 = fileModel;
            return var13;
         }
      } catch (Exception var21) {
         LogUtil.error(var21.getMessage());
         throw new RuntimeException(var21);
      } finally {
         try {
            rs.close();
            st.close();
            conn.close();
         } catch (SQLException var20) {
            LogUtil.error(var20.getMessage());
            throw new RuntimeException(var20);
         }
      }

      return null;
   }
}
