package com.rw.dao;

import com.rw.model.FileModel;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public interface BaseDAO {

   String SP_CODE = "O_RETURN_CODE";
   String SP_MSG = "O_RETURN_MSG";
   String SP_CURSOR = "O_CURSOR";
   String SP_TOTAL_COUNT = "O_TOTAL_COUNT";
   String TOTAL_COUNT = "total";
   String DATA = "data";


   List findList(String var1) throws RuntimeException;

   List findList(String var1, Object ... var2) throws RuntimeException;

   Map findList(String var1, int var2, int var3, Object ... var4) throws RuntimeException;

   Map findOne(String var1) throws RuntimeException;

   Map findOne(String var1, Object ... var2) throws RuntimeException;

   int insert(String var1) throws RuntimeException;

   int insert(String var1, Object ... var2) throws RuntimeException;

   int update(String var1) throws RuntimeException;

   int update(String var1, Object ... var2) throws RuntimeException;

   int del(String var1) throws RuntimeException;

   int del(String var1, Object ... var2) throws RuntimeException;

   Long count(String var1, Object ... var2) throws RuntimeException;

   Map querySp(String var1, List var2) throws RuntimeException;

   List querySpOnlyCusor(String var1, List var2) throws RuntimeException;

   Connection getConnection() throws RuntimeException;

   int batchUpdateSql(List var1) throws RuntimeException;

   int[] batchUpdateSql(String var1, List var2, List var3) throws RuntimeException;

   List getFileFromDB(String var1) throws RuntimeException;

   FileModel getFileByIdFromDB(String var1) throws RuntimeException;

   String saveFileToDB(FileModel var1, File var2) throws RuntimeException, SQLException;
}
