package com.rw.csdc.single;

import com.hundsun.t2sdk.impl.client.T2Services;
import com.hundsun.t2sdk.interfaces.T2SDKException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class T2SDKClient {

   private static final Logger logger = LoggerFactory.getLogger(T2SDKClient.class);
   private static T2Services sdkServices;


   public static T2Services getSdkServices() {
      try {
         if(sdkServices == null) {
            sdkServices = T2Services.getInstance();
            sdkServices.init();
            sdkServices.start();
         }
      } catch (T2SDKException var1) {
         logger.error(var1.getMessage());
      }

      return sdkServices;
   }

}
