package com.rw.csdc.service;

import com.hundsun.t2sdk.common.core.context.ContextUtil;
import com.hundsun.t2sdk.common.share.dataset.DatasetService;
import com.hundsun.t2sdk.impl.client.T2Services;
import com.hundsun.t2sdk.interfaces.IClient;
import com.hundsun.t2sdk.interfaces.T2SDKException;
import com.hundsun.t2sdk.interfaces.share.dataset.IDataset;
import com.hundsun.t2sdk.interfaces.share.dataset.IDatasets;
import com.hundsun.t2sdk.interfaces.share.event.IEvent;
import com.rw.annotation.SystemServiceLog;
import com.rw.csdc.dao.CsdcClientCheckDAO;
import com.rw.csdc.service.CsdcClientCheckService;
import com.rw.util.CommonException;
import com.rw.util.PropKit;
import com.xiaoleilu.hutool.util.StrUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service("csdcClientCheckService")
@Transactional(
   isolation = Isolation.DEFAULT,
   rollbackFor = {CommonException.class}
)
public class CsdcClientCheckServiceImpl implements CsdcClientCheckService {

   private static final Logger logger = LoggerFactory.getLogger(CsdcClientCheckServiceImpl.class);
   private static String op_branch_no;
   private static String op_station;
   private static String op_entrust_way;
   private static String branch_no;
   private static T2Services sdkServices;
   @Autowired
   CsdcClientCheckDAO csdcClientCheckDAO;


   @SystemServiceLog(
      description = "通过员工身份证号码获取中登账号定位串信息"
   )
   public Map getPositionStr(String csdc_id_no, String csdc_id_kind, String csdc_client_name, int gt_busin_checkflag, String userId, String flag) throws CommonException {
      logger.info("******************接口：10201093:开始******************");
      Object resultMap = new HashMap();
      IClient client = null;

      try {
         logger.info("*******************开始同步发送*******************");
         IEvent e;
         if("1".equals(flag)) {
            logger.info("********************接口：10201093,服务开关判断：开始*******************");
            logger.info("************获取IClient********************");
            client = sdkServices.getClient("myserver");
            IEvent businessBeginFlag = this.getEvent(1, csdc_id_no, csdc_id_kind, csdc_client_name, userId);
            e = client.sendReceive(businessBeginFlag, 10000L);
            resultMap = this.getPostion(e);
            logger.info("********************接口：10201093,服务开关判断:结束{}*******************", resultMap.toString());
         }

         boolean businessBeginFlag1 = "0".equals(flag) || !((Map)resultMap).isEmpty() && ((Map)resultMap).containsKey("deal_flag") && "0".equals(((Map)resultMap).get("deal_flag"));
         if(businessBeginFlag1) {
            logger.info("*******************接口：10201093,开始办理业务,获取position_str开始*******************");
            logger.info("************获取IClient********************");
            client = sdkServices.getClient("myserver");
            IEvent event = this.getEvent(0, csdc_id_no, csdc_id_kind, csdc_client_name, userId);
            e = client.sendReceive(event, 10000L);
            resultMap = this.getPostion(e);
            logger.info("*******************接口：10201093,开始办理业务,获取position_str结束{}*******************", resultMap.toString());
            if(((Map)resultMap).containsKey("position_str") && StrUtil.isNotBlank(((Map)resultMap).get("position_str").toString())) {
               String positionStr = ((Map)resultMap).get("position_str").toString();

               String assettrans_status;
               Map status;
               do {
                  do {
                     status = this.getStatus(positionStr, userId);
                     logger.info("***************接口：10200532轮训中登回报状态：开始*************************");
                  } while(!status.containsKey("assettrans_status"));

                  assettrans_status = (String)status.get("assettrans_status");
               } while(!"8".equals(assettrans_status) && !"9".equals(assettrans_status));

               logger.info("***************接口：10200532轮训中登回报状态:结束,assettrans_status={}*************************", status.get("assettrans_status"));
               if(StrUtil.isNotBlank(assettrans_status) && "9".equals(assettrans_status)) {
                  logger.info("***************接口：10200532轮训中登回报状态：失败*************************");
                  ((Map)resultMap).put("deal_flag", status.get("deal_flag"));
                  ((Map)resultMap).put("deal_info", (String)status.get("deal_info") + ",轮训中登回报状态失败");
               } else {
                  logger.info("***************接口：10200532轮训中登回报状态:成功*************************");
                  resultMap = this.getCsdcInfo(positionStr, userId);
                  logger.info("*************接口：10201090调用结束，返回结果:{}", resultMap.toString());
               }
            }
         } else {
            logger.info("*******************接口：10201093无法提供服务*******************");
         }

         return (Map)resultMap;
      } catch (T2SDKException var15) {
         logger.error("getPositionStr{}", var15.getMessage());
         ((Map)resultMap).put("error", var15.getMessage());
         throw new CommonException(var15.getMessage());
      } catch (Exception var16) {
         logger.error("getPositionStr{}", var16.getMessage());
         ((Map)resultMap).put("error", var16.getMessage());
         throw new CommonException(var16.getMessage());
      }
   }

   @SystemServiceLog(
      description = "通过员工定位串获取员工的司外账户信息"
   )
   public Map getCsdcInfo(String positionStr, String userId) throws CommonException {
      HashMap result = new HashMap(2);
      logger.info("*******************接口：10201090开始调用，通过定位串信息返回员工账户详情:开始*******************");

      try {
         IClient client = sdkServices.getClient("myserver");
         logger.info("*******************成功获取IClient*******************");
         IEvent e = ContextUtil.getServiceContext().getEventFactory().getEventByAlias("10201090", 0);
         IDataset iDataset = DatasetService.getDefaultInstance().getDataset();
         iDataset.addColumn("op_branch_no");
         iDataset.addColumn("operator_no");
         iDataset.addColumn("user_type");
         iDataset.addColumn("op_password");
         iDataset.addColumn("op_station");
         iDataset.addColumn("op_entrust_way");
         iDataset.addColumn("menu_id");
         iDataset.addColumn("function_id");
         iDataset.addColumn("branch_no");
         iDataset.addColumn("audit_action");
         iDataset.addColumn("position_str");
         iDataset.appendRow();
         logger.info("*******************构造dataset数据信息userId={};op_branch_no={};op_station={};op_entrust_way={};branch_no={};positionStr={}*******************", new Object[]{userId, op_branch_no, op_station, op_entrust_way, branch_no, positionStr});
         iDataset.updateString("op_branch_no", op_branch_no);
         iDataset.updateString("operator_no", userId);
         iDataset.updateString("user_type", "");
         iDataset.updateString("op_password", "");
         iDataset.updateString("op_station", op_station);
         iDataset.updateString("op_entrust_way", op_entrust_way);
         iDataset.updateString("menu_id", "");
         iDataset.updateString("function_id", "");
         iDataset.updateString("branch_no", branch_no);
         iDataset.updateString("audit_action", "");
         iDataset.updateString("position_str", positionStr);
         e.putEventData(iDataset);
         logger.info("*******************开始同步发送*******************");
         IEvent rsp = client.sendReceive(e, 10000L);
         logger.info("*******************开始获取同步发送结果returnCode:{}*******************", Integer.valueOf(rsp.getReturnCode()));
         if(rsp.getReturnCode() != 0) {
            result.put("error", rsp.getErrorNo() + " : " + rsp.getErrorInfo());
            logger.info(rsp.getErrorNo() + " : " + rsp.getErrorInfo());
         } else {
            logger.info("*******************开始获取IDatasets*******************");
            IDatasets eventDatas = rsp.getEventDatas();
            logger.info("*******************获取IDatasets中共有{}个dataSet*******************", Integer.valueOf(eventDatas.getDatasetCount()));

            for(int i = 0; i < eventDatas.getDatasetCount(); ++i) {
               logger.info("*******************DataSetName={}*******************", eventDatas.getDatasetName(i));
               IDataset ds = eventDatas.getDataset(i);
               if(null != ds) {
                  logger.info("*******************dataSetName的结果集存在*******************");
                  ArrayList resultList = new ArrayList();
                  int columnCount = ds.getColumnCount();
                  int index = 1;
                  logger.info("*******************获取Dataset的columnCount={}*******************", Integer.valueOf(columnCount));

                  int j;
                  for(j = 1; j <= columnCount; ++j) {
                     logger.info("第{}列：列名={},列类型={}", new Object[]{Integer.valueOf(j), ds.getColumnName(j), Character.valueOf(ds.getColumnType(j))});
                  }

                  ds.beforeFirst();
                  logger.info("*******************开始遍历Dataset行,共{}行数据*******************", Integer.valueOf(ds.getRowCount()));

                  while(ds.hasNext()) {
                     logger.info("*******************第{}行*******************", Integer.valueOf(index));
                     ds.next();
                     ++index;
                     LinkedHashMap resultMap = new LinkedHashMap(columnCount);
                     logger.info("*******************开始遍历Dataset列*******************");

                     for(j = 1; j <= columnCount; ++j) {
                        String columnName = ds.getColumnName(j);
                        char columnType = ds.getColumnType(j);
                        logger.info("*******************第{}列：columnName={},columnType={}*******************", new Object[]{Integer.valueOf(j), columnName, Character.valueOf(columnType)});
                        byte var27 = -1;
                        switch(columnName.hashCode()) {
                        case -1901730584:
                           if(columnName.equals("csdc_id_kind")) {
                              var27 = 4;
                           }
                           break;
                        case -1798551915:
                           if(columnName.equals("csdc_holder_status")) {
                              var27 = 1;
                           }
                           break;
                        case -1589062210:
                           if(columnName.equals("csdc_open_organ_name")) {
                              var27 = 6;
                           }
                           break;
                        case -1003095019:
                           if(columnName.equals("csdc_id_no")) {
                              var27 = 3;
                           }
                           break;
                        case -691768652:
                           if(columnName.equals("csdc_stock_account")) {
                              var27 = 0;
                           }
                           break;
                        case -522775761:
                           if(columnName.equals("csdc_client_name")) {
                              var27 = 5;
                           }
                           break;
                        case 158390636:
                           if(columnName.equals("csdc_acode_account")) {
                              var27 = 2;
                           }
                           break;
                        case 383482163:
                           if(columnName.equals("csdc_open_date")) {
                              var27 = 7;
                           }
                        }

                        switch(var27) {
                        case 0:
                           String csdc_stock_account = ds.getString("csdc_stock_account");
                           resultMap.put("csdc_stock_account", csdc_stock_account);
                           logger.debug("员工司外账户人-证券账户信息:" + csdc_stock_account);
                           break;
                        case 1:
                           String csdc_holder_status = ds.getString("csdc_holder_status");
                           resultMap.put("csdc_holder_status", csdc_holder_status);
                           logger.debug("员工司外账户人状态信息:" + csdc_holder_status);
                           break;
                        case 2:
                           String csdc_acode_account = ds.getString("csdc_acode_account");
                           resultMap.put("csdc_acode_account", csdc_acode_account);
                           logger.debug("员工司外账户人-一码通账户信息:" + csdc_acode_account);
                           break;
                        case 3:
                           String csdc_id_no = ds.getString("csdc_id_no");
                           resultMap.put("csdc_id_no", csdc_id_no);
                           logger.debug("员工司外账户人-证件号信息:" + csdc_id_no);
                           break;
                        case 4:
                           String csdc_id_kind = ds.getString("csdc_id_kind");
                           resultMap.put("csdc_id_kind", csdc_id_kind);
                           logger.debug("员工司外账户人-证件类型信息:" + csdc_id_kind);
                           break;
                        case 5:
                           String csdc_client_name = ds.getString("csdc_client_name");
                           resultMap.put("csdc_client_name", csdc_client_name);
                           logger.debug("员工司外账户人-姓名信息:" + csdc_client_name);
                           break;
                        case 6:
                           String csdc_open_organ_name = ds.getString("csdc_open_organ_name");
                           resultMap.put("csdc_open_organ_name", csdc_open_organ_name);
                           logger.debug("员工司外账户人-券商信息:" + csdc_open_organ_name);
                           break;
                        case 7:
                           String csdc_open_date = ds.getString("csdc_open_date");
                           resultMap.put("csdc_open_date", csdc_open_date);
                           logger.debug("员工司外账户人-开户日期信息:" + csdc_open_date);
                        }
                     }

                     resultList.add(resultMap);
                  }

                  result.put("dataSet", resultList);
               } else {
                  logger.info("*******************获取IDataset不存在*******************");
               }
            }
         }
      } catch (T2SDKException var28) {
         logger.error("getCsdcInfo发生错误T2SDKException：{}", var28.getMessage());
         result.put("error", var28.getMessage());
         throw new CommonException(var28.getMessage());
      } catch (Exception var29) {
         logger.error("getCsdcInfo发生错误Exception：{}", var29.getMessage());
         result.put("error", var29.getMessage());
         throw new CommonException(var29.getMessage());
      }

      logger.info("*******************通过定位串信息返回员工账户详情:结束*******************");
      return result;
   }

   @Transactional(
      propagation = Propagation.REQUIRED
   )
   public String addClient(List csdcInfo, String batch, String idNo, String userId) throws CommonException {
      ArrayList argValues = new ArrayList();
      Iterator flag = csdcInfo.iterator();

      while(flag.hasNext()) {
         Map csdc = (Map)flag.next();
         ArrayList values = new ArrayList(9);
         if(!StringUtils.isBlank((String)csdc.get("csdc_stock_account"))) {
            values.add(this.getUUID());
            values.add(StringUtils.defaultIfBlank((String)csdc.get("csdc_stock_account"), ""));
            values.add(StringUtils.defaultIfBlank((String)csdc.get("csdc_holder_status"), ""));
            values.add(StringUtils.defaultIfBlank((String)csdc.get("csdc_acode_account"), ""));
            values.add(StringUtils.defaultIfBlank((String)csdc.get("csdc_id_no"), ""));
            values.add(StringUtils.defaultIfBlank((String)csdc.get("csdc_id_kind"), ""));
            values.add(StringUtils.defaultIfBlank((String)csdc.get("csdc_client_name"), ""));
            values.add(StringUtils.defaultIfBlank((String)csdc.get("csdc_open_organ_name"), ""));
            values.add(StringUtils.defaultIfBlank((String)csdc.get("csdc_open_date"), ""));
            values.add(userId);
            values.add(idNo);
            values.add(batch);
            argValues.add(values.toArray());
         }
      }

      if(argValues.isEmpty()) {
         this.csdcClientCheckDAO.updateBatchStatus(idNo, batch, 1, userId);
         return "无有效的员工证券账户信息存在！";
      } else {
         boolean flag1 = this.csdcClientCheckDAO.addClientInfo(argValues);
         String msg;
         if(flag1) {
            this.csdcClientCheckDAO.updateBatchStatus(idNo, batch, 1, userId);
            msg = "员工证券账户信息成功入库！";
         } else {
            this.csdcClientCheckDAO.updateBatchStatus(idNo, batch, 2, userId);
            msg = "员工证券账户信息入库失败！";
         }

         return msg;
      }
   }

   public String createAllBatchData() throws CommonException {
      return this.csdcClientCheckDAO.inertAllBatchData();
   }

   public String insertPartBatchData(String[] idArr, String[] idNoArr, String[] nameArr) throws CommonException {
      return this.csdcClientCheckDAO.insertBatchData(Arrays.asList(idArr), Arrays.asList(idNoArr), Arrays.asList(nameArr));
   }

   @Transactional(
      rollbackFor = {CommonException.class},
      propagation = Propagation.REQUIRED
   )
   public boolean updateBatchStatus(String no, String batch, int status, String userId) throws CommonException {
      return this.csdcClientCheckDAO.updateBatchStatus(no, batch, status, userId);
   }

   private String getUUID() {
      return UUID.randomUUID().toString().replace("-", "");
   }

   private Map getPostion(IEvent rsp) throws Exception {
      HashMap resultMap = new HashMap();
      logger.info("*******************开始获取同步发送结果returnCode:{}*******************", Integer.valueOf(rsp.getReturnCode()));
      if(rsp.getReturnCode() != 0) {
         resultMap.put("error", rsp.getErrorNo() + " : " + rsp.getErrorInfo());
         logger.info(rsp.getErrorNo() + " : " + rsp.getErrorInfo());
      } else {
         logger.info("*******************开始获取IDatasets*******************");
         IDatasets result = rsp.getEventDatas();
         IDataset ds = null;
         int datasetCount = result.getDatasetCount();
         logger.info("*******************共有{}个dataset*******************", Integer.valueOf(datasetCount));

         for(int i = 0; i < datasetCount; ++i) {
            logger.info("*******************datasetName={}*******************", result.getDatasetName(i));
            ds = result.getDataset(i);
            if(null != ds) {
               logger.info("*******************dataSetName={}的结果集存在*******************", ds.getDatasetName());
               int columnCount = ds.getColumnCount();
               int index = 1;
               logger.info("*******************获取Dataset的columnCount={}*******************", Integer.valueOf(columnCount));

               int j;
               for(j = 1; j <= columnCount; ++j) {
                  logger.info("第{}列：列名={},列类型={}", new Object[]{Integer.valueOf(j), ds.getColumnName(j), Character.valueOf(ds.getColumnType(j))});
               }

               ds.beforeFirst();
               logger.info("*******************开始遍历Dataset行,共{}行数据*******************", Integer.valueOf(ds.getRowCount()));

               while(ds.hasNext()) {
                  logger.info("*******************第{}行*******************", Integer.valueOf(index));
                  ds.next();
                  ++index;
                  logger.info("*******************开始遍历Dataset列*******************");

                  for(j = 1; j <= columnCount; ++j) {
                     String columnName = ds.getColumnName(j);
                     char columnType = ds.getColumnType(j);
                     logger.info("*******************第{}列：columnName={},columnType={}*******************", new Object[]{Integer.valueOf(j), columnName, Character.valueOf(columnType)});
                     byte var16 = -1;
                     switch(columnName.hashCode()) {
                     case -1350262945:
                        if(columnName.equals("deal_flag")) {
                           var16 = 1;
                        }
                        break;
                     case -1350171487:
                        if(columnName.equals("deal_info")) {
                           var16 = 2;
                        }
                        break;
                     case 34392603:
                        if(columnName.equals("position_str")) {
                           var16 = 0;
                        }
                     }

                     switch(var16) {
                     case 0:
                        String position_str = ds.getString("position_str");
                        resultMap.put("position_str", position_str);
                        logger.info("员工司外账户人-position_str:" + position_str);
                        break;
                     case 1:
                        String deal_flag = ds.getString("deal_flag");
                        resultMap.put("deal_flag", deal_flag);
                        logger.info("员工司外账户人-deal_flag:" + deal_flag);
                        break;
                     case 2:
                        String deal_info = ds.getString("deal_info");
                        resultMap.put("deal_info", deal_info);
                        logger.info("员工司外账户人-deal_info:" + deal_info);
                     }
                  }
               }
            } else {
               logger.info("*******************获取IDataset不存在*******************");
            }
         }
      }

      return resultMap;
   }

   private Map getCsdc(String positionStr, String userId) throws CommonException {
      HashMap result = new HashMap(2);
      logger.info("*******************接口：10201090开始调用，通过定位串信息返回员工账户详情:开始*******************");

      try {
         IClient e = sdkServices.getClient("myserver");
         IEvent event = ContextUtil.getServiceContext().getEventFactory().getEventByAlias("10201090", 0);
         IDataset iDataset = DatasetService.getDefaultInstance().getDataset();
         iDataset.addColumn("op_branch_no");
         iDataset.addColumn("operator_no");
         iDataset.addColumn("user_type");
         iDataset.addColumn("op_password");
         iDataset.addColumn("op_station");
         iDataset.addColumn("op_entrust_way");
         iDataset.addColumn("menu_id");
         iDataset.addColumn("function_id");
         iDataset.addColumn("branch_no");
         iDataset.addColumn("audit_action");
         iDataset.addColumn("position_str");
         iDataset.appendRow();
         logger.info("*******************构造dataset数据信息user_Id={};op_branch_no={};op_station={};op_entrust_way={};branch_no={};positionStr={}*******************", new Object[]{userId, op_branch_no, op_station, op_entrust_way, branch_no, positionStr});
         iDataset.updateString("op_branch_no", op_branch_no);
         iDataset.updateString("operator_no", userId);
         iDataset.updateString("user_type", "");
         iDataset.updateString("op_password", "");
         iDataset.updateString("op_station", op_station);
         iDataset.updateString("op_entrust_way", op_entrust_way);
         iDataset.updateString("menu_id", "");
         iDataset.updateString("function_id", "");
         iDataset.updateString("branch_no", branch_no);
         iDataset.updateString("audit_action", "");
         iDataset.updateString("position_str", positionStr);
         event.putEventData(iDataset);
         logger.info("*******************开始同步发送*******************");
         IEvent rsp = e.sendReceive(event, 10000L);
         logger.info("*******************开始获取同步发送结果returnCode:{}*******************", Integer.valueOf(rsp.getReturnCode()));
         if(rsp.getReturnCode() != 0) {
            result.put("error", rsp.getErrorNo() + " : " + rsp.getErrorInfo());
            logger.info(rsp.getErrorNo() + " : " + rsp.getErrorInfo());
         } else {
            logger.info("*******************开始获取IDatasets*******************");
            IDatasets eventDatas = rsp.getEventDatas();
            logger.info("*******************获取IDatasets中共有{}个dataSet*******************", Integer.valueOf(eventDatas.getDatasetCount()));

            for(int i = 0; i < eventDatas.getDatasetCount(); ++i) {
               logger.info("*******************DataSetName={}*******************", eventDatas.getDatasetName(i));
               IDataset ds = eventDatas.getDataset(i);
               if(null != ds) {
                  logger.info("*******************dataSetName={}的结果集存在*******************", ds.getDatasetName());
                  ArrayList resultList = new ArrayList();
                  int columnCount = ds.getColumnCount();
                  int index = 1;
                  logger.info("*******************获取Dataset的columnCount={}*******************", Integer.valueOf(columnCount));

                  int j;
                  for(j = 1; j <= columnCount; ++j) {
                     logger.info("第{}列：列名={},列类型={}", new Object[]{Integer.valueOf(j), ds.getColumnName(j), Character.valueOf(ds.getColumnType(j))});
                  }

                  ds.beforeFirst();
                  logger.info("*******************开始遍历Dataset行,共{}行数据*******************", Integer.valueOf(ds.getRowCount()));

                  while(ds.hasNext()) {
                     logger.info("*******************第{}行*******************", Integer.valueOf(index));
                     ds.next();
                     ++index;
                     LinkedHashMap resultMap = new LinkedHashMap(columnCount);
                     logger.info("*******************开始遍历Dataset列*******************");

                     for(j = 1; j <= columnCount; ++j) {
                        String columnName = ds.getColumnName(j);
                        char columnType = ds.getColumnType(j);
                        logger.info("*******************第{}列：columnName={},columnType={}*******************", new Object[]{Integer.valueOf(j), columnName, Character.valueOf(columnType)});
                        byte var27 = -1;
                        switch(columnName.hashCode()) {
                        case -1901730584:
                           if(columnName.equals("csdc_id_kind")) {
                              var27 = 4;
                           }
                           break;
                        case -1798551915:
                           if(columnName.equals("csdc_holder_status")) {
                              var27 = 1;
                           }
                           break;
                        case -1589062210:
                           if(columnName.equals("csdc_open_organ_name")) {
                              var27 = 6;
                           }
                           break;
                        case -1003095019:
                           if(columnName.equals("csdc_id_no")) {
                              var27 = 3;
                           }
                           break;
                        case -691768652:
                           if(columnName.equals("csdc_stock_account")) {
                              var27 = 0;
                           }
                           break;
                        case -522775761:
                           if(columnName.equals("csdc_client_name")) {
                              var27 = 5;
                           }
                           break;
                        case 158390636:
                           if(columnName.equals("csdc_acode_account")) {
                              var27 = 2;
                           }
                           break;
                        case 383482163:
                           if(columnName.equals("csdc_open_date")) {
                              var27 = 7;
                           }
                        }

                        switch(var27) {
                        case 0:
                           String csdc_stock_account = ds.getString("csdc_stock_account");
                           resultMap.put("csdc_stock_account", csdc_stock_account);
                           logger.info("员工司外账户人-证券账户信息:" + csdc_stock_account);
                           break;
                        case 1:
                           String csdc_holder_status = ds.getString("csdc_holder_status");
                           resultMap.put("csdc_holder_status", csdc_holder_status);
                           logger.info("员工司外账户人状态信息:" + csdc_holder_status);
                           break;
                        case 2:
                           String csdc_acode_account = ds.getString("csdc_acode_account");
                           resultMap.put("csdc_acode_account", csdc_acode_account);
                           logger.info("员工司外账户人-一码通账户信息:" + csdc_acode_account);
                           break;
                        case 3:
                           String csdc_id_no = ds.getString("csdc_id_no");
                           resultMap.put("csdc_id_no", csdc_id_no);
                           logger.info("员工司外账户人-证件号信息:" + csdc_id_no);
                           break;
                        case 4:
                           String csdc_id_kind = ds.getString("csdc_id_kind");
                           resultMap.put("csdc_id_kind", csdc_id_kind);
                           logger.info("员工司外账户人-证件类型信息:" + csdc_id_kind);
                           break;
                        case 5:
                           String csdc_client_name = ds.getString("csdc_client_name");
                           resultMap.put("csdc_client_name", csdc_client_name);
                           logger.info("员工司外账户人-姓名信息:" + csdc_client_name);
                           break;
                        case 6:
                           String csdc_open_organ_name = ds.getString("csdc_open_organ_name");
                           resultMap.put("csdc_open_organ_name", csdc_open_organ_name);
                           logger.info("员工司外账户人-券商信息:" + csdc_open_organ_name);
                           break;
                        case 7:
                           String csdc_open_date = ds.getString("csdc_open_date");
                           resultMap.put("csdc_open_date", csdc_open_date);
                           logger.info("员工司外账户人-开户日期信息:" + csdc_open_date);
                        }
                     }

                     resultList.add(resultMap);
                  }

                  result.put("dataSet", resultList);
               } else {
                  logger.info("*******************获取IDataset不存在*******************");
               }
            }
         }
      } catch (T2SDKException var28) {
         logger.error("getCsdc发生错误T2SDKException：{}", var28.getMessage());
         result.put("error", var28.getMessage());
         throw new CommonException(var28.getMessage());
      } catch (Exception var29) {
         logger.error("getCsdc发生错误Exception：{}", var29.getMessage());
         result.put("error", var29.getMessage());
         throw new CommonException(var29.getMessage());
      }

      logger.info("*******************接口：10201090通过定位串信息返回员工账户详情:结束*******************");
      return result;
   }

   private Map getStatus(String positionStr, String userId) throws CommonException {
      HashMap result = new HashMap(2);
      logger.info("*******************接口：10200532开始调用，通过定位串信息返回状态信息:开始*******************");

      try {
         IClient e = sdkServices.getClient("myserver");
         IEvent event = ContextUtil.getServiceContext().getEventFactory().getEventByAlias("10200532", 0);
         IDataset iDataset = DatasetService.getDefaultInstance().getDataset();
         iDataset.addColumn("op_branch_no");
         iDataset.addColumn("operator_no");
         iDataset.addColumn("user_type");
         iDataset.addColumn("op_password");
         iDataset.addColumn("op_station");
         iDataset.addColumn("op_entrust_way");
         iDataset.addColumn("menu_id");
         iDataset.addColumn("function_id");
         iDataset.addColumn("branch_no");
         iDataset.addColumn("audit_action");
         iDataset.addColumn("position_str");
         iDataset.appendRow();
         logger.info("*******************构造dataset数据信息user_Id={};op_branch_no={};op_station={};op_entrust_way={};branch_no={};positionStr={}*******************", new Object[]{userId, op_branch_no, op_station, op_entrust_way, branch_no, positionStr});
         iDataset.updateString("op_branch_no", op_branch_no);
         iDataset.updateString("operator_no", userId);
         iDataset.updateString("user_type", "");
         iDataset.updateString("op_password", "");
         iDataset.updateString("op_station", op_station);
         iDataset.updateString("op_entrust_way", op_entrust_way);
         iDataset.updateString("menu_id", "");
         iDataset.updateString("function_id", "");
         iDataset.updateString("branch_no", branch_no);
         iDataset.updateString("audit_action", "");
         iDataset.updateString("position_str", positionStr);
         event.putEventData(iDataset);
         logger.info("*******************开始同步发送*******************");
         IEvent rsp = e.sendReceive(event, 10000L);
         logger.info("*******************开始获取同步发送结果returnCode:{}*******************", Integer.valueOf(rsp.getReturnCode()));
         if(rsp.getReturnCode() != 0) {
            result.put("error", rsp.getErrorNo() + " : " + rsp.getErrorInfo());
            logger.info(rsp.getErrorNo() + " : " + rsp.getErrorInfo());
         } else {
            logger.info("*******************开始获取IDatasets*******************");
            IDatasets eventDatas = rsp.getEventDatas();
            logger.info("*******************获取IDatasets中共有{}个dataSet*******************", Integer.valueOf(eventDatas.getDatasetCount()));

            for(int i = 0; i < eventDatas.getDatasetCount(); ++i) {
               logger.info("*******************DataSetName={}*******************", eventDatas.getDatasetName(i));
               IDataset ds = eventDatas.getDataset(i);
               if(null != ds) {
                  logger.info("*******************dataSetName={}的结果集存在*******************", ds.getDatasetName());
                  int columnCount = ds.getColumnCount();
                  int index = 1;
                  logger.info("*******************获取Dataset的columnCount={}*******************", Integer.valueOf(columnCount));

                  int j;
                  for(j = 1; j <= columnCount; ++j) {
                     logger.info("第{}列：列名={},列类型={}", new Object[]{Integer.valueOf(j), ds.getColumnName(j), Character.valueOf(ds.getColumnType(j))});
                  }

                  ds.beforeFirst();
                  logger.info("*******************开始遍历Dataset行,共{}行数据*******************", Integer.valueOf(ds.getRowCount()));

                  while(ds.hasNext()) {
                     logger.info("*******************第{}行*******************", Integer.valueOf(index));
                     ds.next();
                     ++index;
                     logger.info("*******************开始遍历Dataset列*******************");

                     for(j = 1; j <= columnCount; ++j) {
                        String columnName = ds.getColumnName(j);
                        char columnType = ds.getColumnType(j);
                        logger.info("*******************第{}列：columnName={},columnType={}*******************", new Object[]{Integer.valueOf(j), columnName, Character.valueOf(columnType)});
                        byte var25 = -1;
                        switch(columnName.hashCode()) {
                        case -1739911079:
                           if(columnName.equals("assettrans_status")) {
                              var25 = 1;
                           }
                           break;
                        case -1350262945:
                           if(columnName.equals("deal_flag")) {
                              var25 = 3;
                           }
                           break;
                        case -1350171487:
                           if(columnName.equals("deal_info")) {
                              var25 = 4;
                           }
                           break;
                        case 34392603:
                           if(columnName.equals("position_str")) {
                              var25 = 5;
                           }
                           break;
                        case 445978812:
                           if(columnName.equals("acode_account")) {
                              var25 = 2;
                           }
                           break;
                        case 1059501946:
                           if(columnName.equals("csdc_entrust_type")) {
                              var25 = 0;
                           }
                        }

                        switch(var25) {
                        case 0:
                           String csdc_entrust_type = ds.getString("csdc_entrust_type");
                           result.put("csdc_entrust_type", csdc_entrust_type);
                           logger.info("委托类别:" + csdc_entrust_type);
                           break;
                        case 1:
                           String assettrans_status = ds.getString("assettrans_status");
                           result.put("assettrans_status", assettrans_status);
                           logger.info("存管数据交换状态:" + assettrans_status);
                           break;
                        case 2:
                           String acode_account = ds.getString("acode_account");
                           result.put("acode_account", acode_account);
                           logger.info("一码通账户号码:" + acode_account);
                           break;
                        case 3:
                           String deal_flag = ds.getString("deal_flag");
                           result.put("deal_flag", deal_flag);
                           logger.info("处理标志:" + deal_flag);
                           break;
                        case 4:
                           String deal_info = ds.getString("deal_info");
                           result.put("deal_info", deal_info);
                           logger.info("处理信息:" + deal_info);
                           break;
                        case 5:
                           String position_str = ds.getString("position_str");
                           result.put("position_str", position_str);
                           logger.info("定位串:" + position_str);
                        }
                     }
                  }
               } else {
                  logger.info("*******************获取IDataset不存在*******************");
               }
            }
         }
      } catch (T2SDKException var32) {
         logger.error("getCsdc发生错误T2SDKException：{}", var32.getMessage());
         result.put("error", var32.getMessage());
         throw new CommonException(var32.getMessage());
      } catch (Exception var33) {
         logger.error("getCsdc发生错误Exception：{}", var33.getMessage());
         result.put("error", var33.getMessage());
         throw new CommonException(var33.getMessage());
      }

      logger.info("*******************接口：10200532通过定位串信息返回员工账户状态详情:结束*******************");
      return result;
   }

   private IEvent getEvent(int deal_flag, String csdc_id_no, String csdc_id_kind, String csdc_client_name, String userId) {
      IEvent event = ContextUtil.getServiceContext().getEventFactory().getEventByAlias("10201093", 0);
      IDataset dataset = DatasetService.getDefaultInstance().getDataset();
      dataset.addColumn("op_branch_no");
      dataset.addColumn("operator_no");
      dataset.addColumn("user_type");
      dataset.addColumn("op_password");
      dataset.addColumn("op_station");
      dataset.addColumn("op_entrust_way");
      dataset.addColumn("menu_id");
      dataset.addColumn("function_id");
      dataset.addColumn("branch_no");
      dataset.addColumn("audit_action");
      dataset.addColumn("csdc_id_no");
      logger.debug("员工证件号码:" + csdc_id_no);
      dataset.addColumn("csdc_id_kind");
      logger.debug("员工证件类型:" + csdc_id_kind);
      dataset.addColumn("csdc_client_name");
      logger.debug("员工姓名:" + csdc_client_name);
      dataset.addColumn("gt_busin_checkflag");
      dataset.appendRow();
      logger.info("*******************构造dataset数据信息csdc_id_no={};csdc_client_name={};op_branch_no={};op_station={};op_entrust_way={};branch_no={};*******************", new Object[]{csdc_id_no, csdc_client_name, op_branch_no, op_station, op_entrust_way, branch_no});
      dataset.updateString("op_branch_no", op_branch_no);
      dataset.updateString("operator_no", userId);
      dataset.updateString("user_type", "");
      dataset.updateString("op_password", "");
      dataset.updateString("op_station", op_station);
      dataset.updateString("op_entrust_way", op_entrust_way);
      dataset.updateString("menu_id", "");
      dataset.updateString("function_id", "");
      dataset.updateString("branch_no", branch_no);
      dataset.updateString("audit_action", "");
      dataset.updateString("csdc_id_no", csdc_id_no);
      dataset.updateString("csdc_id_kind", csdc_id_kind);
      dataset.updateString("csdc_client_name", csdc_client_name);
      dataset.updateInt("gt_busin_checkflag", deal_flag);
      event.putEventData(dataset);
      return event;
   }

   static {
      try {
         op_branch_no = PropKit.getProperty("csdc.op_branch_no");
         op_station = PropKit.getProperty("csdc.op_station");
         op_entrust_way = PropKit.getProperty("csdc.op_entrust_way");
         branch_no = PropKit.getProperty("csdc.branch_no");
         logger.info("op_branch_no={};op_station={};op_entrust_way={};branch_no={}", new Object[]{op_branch_no, op_station, op_entrust_way, branch_no});
         sdkServices = T2Services.getInstance();
         sdkServices.init();
         sdkServices.start();
         logger.info("T2SD服务启动成功！！！");
      } catch (CommonException var1) {
         logger.error("接口参数初始失败{}", var1.getMessage());
      } catch (T2SDKException var2) {
         logger.error("启动T2SD服务失败：{}", var2.getMessage());
      }

   }
}
