package com.rw.crawler;

import com.xiaoleilu.hutool.util.StrUtil;

public class EntryObject implements Comparable {

   private String pid;
   private String title;
   private String url;
   private String id;


   public String getPid() {
      return this.pid;
   }

   public void setPid(String pid) {
      this.pid = pid;
   }

   public String getTitle() {
      return this.title;
   }

   public void setTitle(String title) {
      this.title = title;
   }

   public String getUrl() {
      return this.url;
   }

   public void setUrl(String url) {
      this.url = url;
   }

   public String getId() {
      return this.id;
   }

   public void setId(String id) {
      this.id = id;
   }

   public String toString() {
      return "EntryObject [pid=" + this.pid + ", title=" + this.title + ", url=" + this.url + ", id=" + this.id + "]";
   }

   public int compareTo(EntryObject o) {
      String otherPid = o.getPid();
      if(StrUtil.isNotBlank(otherPid) && StrUtil.isNotBlank(this.pid)) {
         return this.pid.compareTo(otherPid);
      } else if(StrUtil.isBlank(this.pid) && StrUtil.isNotBlank(otherPid)) {
         System.out.println(this);
         return "0".compareTo(otherPid);
      } else if(StrUtil.isNotBlank(this.pid) && StrUtil.isBlank(otherPid)) {
         System.out.println(o);
         return this.pid.compareTo("0");
      } else {
         return 0;
      }
   }
}
