package com.rw.controller;

import com.google.gson.Gson;
import com.rw.annotation.SystemControllerLog;
import com.rw.service.FileService;
import com.wb.interact.Service;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping({"/file"})
public class FileController {

   @Autowired
   private FileService fileService;


   @SystemControllerLog(
      description = "指定表中的附件下载"
   )
   @RequestMapping({"/downFile.jhtml"})
   public void downFile(
      @RequestParam(
         value = "sql",
         required = true
      ) String sql, HttpServletRequest request, HttpServletResponse response) throws Exception {
      if(StringUtils.isNotBlank(sql)) {
         List filePath = this.fileService.getFilePath(sql);
         Gson gson = new Gson();
         if(filePath != null && filePath.size() > 0) {
            request.setAttribute("files", gson.toJson(filePath));
            Service.downloadAtAll(request, response);
         }
      }

   }

   @SystemControllerLog(
      description = "通过ObjectId附件下载"
   )
   @RequestMapping({"/downFileByObjectId.jhtml"})
   public void downFileByObjectId(
      @RequestParam(
         value = "objectId",
         required = true
      ) String objectId, HttpServletRequest request, HttpServletResponse response) throws Exception {
      if(StringUtils.isNotBlank(objectId)) {
         List filePath = this.fileService.getFilePathByObjectId(objectId);
         Gson gson = new Gson();
         if(filePath != null && filePath.size() > 0) {
            request.setAttribute("files", gson.toJson(filePath));
            Service.downloadAtApp(request, response);
         }
      }

   }

   @SystemControllerLog(
      description = "通过文件id附件下载"
   )
   @RequestMapping({"/downFileById.jhtml"})
   public void downFileById(
      @RequestParam(
         value = "id",
         required = true
      ) String id, HttpServletRequest request, HttpServletResponse response) throws Exception {
      if(StringUtils.isNotBlank(id)) {
         String filePath = this.fileService.getFilePathById(id);
         ArrayList filePaths = new ArrayList(1);
         if(filePath != null) {
            filePaths.add(filePath);
            Gson gson = new Gson();
            if(filePath != null) {
               request.setAttribute("files", gson.toJson(filePaths));
               Service.downloadAtApp(request, response);
            }
         }
      }

   }
}
