package com.rw.controller;

import com.google.gson.Gson;
import com.rw.annotation.SystemControllerLog;
import com.rw.model.excel.Col2Field;
import com.rw.model.excel.ExcelTemplate;
import com.rw.model.excel.ExcelTranslate;
import com.rw.model.excel.XCell;
import com.rw.model.excel.XRow;
import com.rw.model.excel.XSheet;
import com.rw.model.sp.Procedure;
import com.rw.service.ExcelService;
import com.rw.util.ExpressionKit;
import com.rw.util.WebKit;
import com.wb.interact.Service;
import com.wb.util.StringUtil;
import com.wb.util.SysUtil;
import com.wb.util.WebUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.Map.Entry;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.commons.CommonsMultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping({"/ck/excel"})
public class ExcelController {

   private static final Logger logger = LoggerFactory.getLogger(ExcelController.class);
   private String excelUploadPath;
   @Autowired
   private ExcelService excelService;


   public ExcelController() {
      this.excelUploadPath = WebKit.getBasePath() + File.separator + "IMPORT" + File.separator + "EXCEL";
   }

   @SystemControllerLog(
      description = "启动导入Excel的页面"
   )
   @RequestMapping(
      value = {"/iExcel.jhtml"},
      method = {RequestMethod.GET}
   )
   public ModelAndView index(
      @RequestParam(
         value = "modelCode",
         required = true
      ) String modelCode, 
      @RequestParam(
         value = "maxRow",
         defaultValue = "0",
         required = false
      ) Integer maxRow, HttpServletRequest request, HttpServletResponse response) {
      ModelAndView modelAndView = new ModelAndView();
      String filePath = this.excelService.getTemplateFilePath(modelCode);
      String userId = WebUtil.fetch(request, "sys.username");
      modelAndView.addObject("modelCode", modelCode);
      modelAndView.addObject("maxRow", maxRow);
      modelAndView.addObject("userId", userId);
      modelAndView.addObject("filePath", filePath);
      modelAndView.setViewName("iExcel");
      return modelAndView;
   }

   @SystemControllerLog(
      description = "下载模版"
   )
   @RequestMapping({"/downTemplateFile.jhtml"})
   public void downTemplateFile(HttpServletRequest request, HttpServletResponse response) throws Exception {
      String filePath = request.getParameter("filePath");
      if(StringUtils.isNotBlank(filePath)) {
         request.setAttribute("files", "[\'" + filePath + "\']");
         Service.downloadAtApp(request, response);
      }

   }

   @SystemControllerLog(
      description = "预览Excel"
   )
   @RequestMapping({"/previewExcel.jhtml"})
   public void previewExcel(HttpServletRequest request, HttpServletResponse response) throws Exception {
      logger.debug("upload is start.......");
      HashMap result = new HashMap();

      try {
         CommonsMultipartResolver e = new CommonsMultipartResolver();
         e.setDefaultEncoding("utf-8");
         e.setMaxUploadSize(5242880L);
         if(e.isMultipart(request)) {
            MultipartHttpServletRequest multipartHttpServletRequest = (MultipartHttpServletRequest)request;
            CommonsMultipartFile file = (CommonsMultipartFile)multipartHttpServletRequest.getFile("fileData");
            String modelCode = multipartHttpServletRequest.getParameter("modelCode");
            String fileName = file.getOriginalFilename();
            Integer maxRow = Integer.valueOf(request.getParameter("maxRow").equalsIgnoreCase("0")?30:(new Integer(request.getParameter("maxRow"))).intValue());
            Integer flag = new Integer(request.getParameter("flag"));
            if(StringUtils.isEmpty(fileName)) {
               result.put("error", "未选择文件！");
            } else if(!StringUtils.containsIgnoreCase(fileName, "xls") && !StringUtils.containsIgnoreCase(fileName, "xlsx")) {
               result.put("error", "非Excel文件!");
            } else {
               byte[] bytes = file.getBytes();
               File filePath = new File(this.excelUploadPath);
               if(!filePath.exists()) {
                  filePath.mkdirs();
               }

               File uploadedFile = new File(filePath, fileName);
               if(uploadedFile.exists()) {
                  String[] fis = StringUtil.split(fileName, ".");
                  fileName = StringUtil.concat(new String[]{fis[0], "-", SysUtil.getId(), ".", fis[1]});
                  uploadedFile = new File(filePath, fileName);
               }

               FileCopyUtils.copy(bytes, uploadedFile);
               logger.debug("upload is end.......");
               if(flag.intValue() == 1) {
                  FileInputStream fis1 = new FileInputStream(uploadedFile);
                  ExcelTranslate translate = new ExcelTranslate();
                  List excelTemplateInfo = this.excelService.getTemplateInfo(modelCode);
                  LinkedHashMap html = new LinkedHashMap();
                  int size = excelTemplateInfo.size();
                  if(size == 1) {
                     String sheetNameList = ((ExcelTemplate)excelTemplateInfo.get(0)).getTemplateSheetName();
                     String[] sheetList = new String[]{sheetNameList};
                     translate.readExcel(fileName, fis1, maxRow.intValue(), Arrays.asList(sheetList));
                     List sheet = translate.getSheetList();
                     if(sheet.size() > 0) {
                        Iterator sheetName = sheet.iterator();

                        while(sheetName.hasNext()) {
                           XSheet sheet1 = (XSheet)sheetName.next();
                           html.put(sheetNameList, sheet1.toHtml(((ExcelTemplate)excelTemplateInfo.get(0)).getStartRowsNum()));
                        }
                     }

                     result.put("msg", html);
                     result.put("filename", fileName);
                     logger.info("********************************");
                     logger.info(uploadedFile.getAbsolutePath());
                     logger.info(String.valueOf(bytes.length));
                     logger.info("********************************");
                  } else if(size > 1) {
                     ArrayList sheetNameList1 = new ArrayList(size);
                     Iterator sheet2 = excelTemplateInfo.iterator();

                     while(sheet2.hasNext()) {
                        ExcelTemplate sheetList1 = (ExcelTemplate)sheet2.next();
                        sheetNameList1.add(sheetList1.getTemplateSheetName());
                     }

                     translate.readExcel(fileName, fis1, maxRow.intValue(), sheetNameList1);
                     List sheetList2 = translate.getSheetList();
                     Iterator sheet4 = sheetList2.iterator();

                     while(sheet4.hasNext()) {
                        XSheet sheet3 = (XSheet)sheet4.next();
                        String sheetName1 = sheet3.getLabel();
                        html.put(sheetName1, sheet3.toHtml());
                     }

                     result.put("msg", html);
                     result.put("filename", fileName);
                     logger.info("********************************");
                     logger.info(uploadedFile.getAbsolutePath());
                     logger.info(String.valueOf(bytes.length));
                     logger.info("********************************");
                  } else {
                     result.put("error", "modelCode=" + modelCode + "的Excel导入模版不存在！");
                  }

                  if(fis1 != null) {
                     fis1.close();
                  }
               } else {
                  result.put("filename", fileName);
               }
            }
         } else {
            result.put("error", "非multipart表单数据!");
         }
      } catch (FileNotFoundException var25) {
         var25.printStackTrace();
         logger.error(SysUtil.getRootError(var25));
         result.put("error", SysUtil.getRootError(var25));
      } catch (Exception var26) {
         var26.printStackTrace();
         logger.error(SysUtil.getRootError(var26));
         result.put("error", SysUtil.getRootError(var26));
      }

      try {
         String e1 = (new Gson()).toJson(result);
         response.setContentType("text/html;charset=utf-8");
         response.getWriter().write(e1);
         response.getWriter().flush();
      } catch (IOException var24) {
         var24.printStackTrace();
         logger.error("导入预览Excel结果返回错误:" + var24.getMessage());
         throw new Exception("导入预览Excel结果返回错误:" + var24.getMessage());
      }
   }

   @SystemControllerLog(
      description = "导入Excel"
   )
   @RequestMapping({"/importExcel.jhtml"})
   public void importExcel(HttpServletRequest request, HttpServletResponse response) {
      LinkedHashMap result = new LinkedHashMap();

      try {
         HashMap e = new HashMap();
         JSONObject json = WebUtil.fetch(request);
         Iterator keys = json.keys();

         String filePath;
         String fileName;
         while(keys.hasNext()) {
            filePath = (String)keys.next();
            fileName = ObjectUtils.toString(json.get(filePath));
            e.put(filePath, fileName);
         }

         e.putAll(this.getCommonParas(WebUtil.fetch(request, "sys.username")));
         filePath = request.getParameter("filePath");
         fileName = request.getParameter("fileName");
         String modelCode = request.getParameter("modelCode");
         File uploadedFile = null;
         Object fis = null;
         if(StringUtils.isEmpty(filePath) && StringUtils.isNotEmpty(fileName)) {
            uploadedFile = new File(this.excelUploadPath + File.separator + fileName);
            fis = new FileInputStream(uploadedFile);
         } else if(StringUtils.startsWithIgnoreCase(filePath, "http")) {
            fis = (new URL(filePath)).openStream();
         } else {
            uploadedFile = new File(filePath);
            fis = new FileInputStream(uploadedFile);
         }

         Map excelTemplateMap = this.excelService.importExcel(modelCode, e);
         ExcelTranslate translate = new ExcelTranslate();
         translate.readExcel(fileName, (InputStream)fis, 0, new ArrayList(excelTemplateMap.keySet()));
         List sheetList = translate.getSheetList();
         Iterator var16 = excelTemplateMap.entrySet().iterator();

         while(var16.hasNext()) {
            Entry map = (Entry)var16.next();
            String sheetName = (String)map.getKey();
            if(StringUtils.contains(sheetName, "&|+|&")) {
               sheetName = StringUtils.substringBefore(sheetName, "&|+|&");
            }

            Iterator var19 = sheetList.iterator();

            while(var19.hasNext()) {
               XSheet xs = (XSheet)var19.next();
               if(StringUtils.equalsIgnoreCase(sheetName, xs.getLabel())) {
                  result.put((String)map.getKey(), this.executeTemplate((ExcelTemplate)map.getValue(), xs, e));
               }
            }
         }

         if(fis != null) {
            ((InputStream)fis).close();
         }
      } catch (FileNotFoundException var21) {
         var21.printStackTrace();
         logger.error(var21.getMessage());
         result.put("error", var21.getMessage());
      } catch (NullPointerException var22) {
         var22.printStackTrace();
         logger.error(var22.getMessage());
         result.put("error", var22.getMessage());
      } catch (SQLException var23) {
         var23.printStackTrace();
         logger.error(var23.getMessage());
         result.put("error", var23.getMessage());
      } catch (IndexOutOfBoundsException var24) {
         var24.printStackTrace();
         logger.error(var24.getMessage());
         result.put("error", var24.getMessage());
      } catch (Exception var25) {
         var25.printStackTrace();
         logger.error(var25.getMessage());
         result.put("error", var25.getMessage());
      }

      try {
         Gson e1 = new Gson();
         String json1 = e1.toJson(result);
         response.setContentType("text/html;charset=utf-8");
         response.getWriter().write(json1);
         response.getWriter().flush();
      } catch (IOException var20) {
         var20.printStackTrace();
         logger.error("导入Excel结果返回错误:" + var20.getMessage());
         throw new RuntimeException("导入Excel结果返回错误:" + var20.getMessage());
      }
   }

   private Map executeTemplate(ExcelTemplate excelTemplate, XSheet xs, Map reqParasMap) throws Exception {
      HashMap result = new HashMap();
      if(ObjectUtils.notEqual(excelTemplate.getStartExecSp(), (Object)null)) {
         Procedure batchInsertSql = excelTemplate.getStartExecSp();
         String colStr = batchInsertSql.getProceSql();
         List colStrIndex = batchInsertSql.getProcedureArguments();
         logger.info("importExcel of 执行前置SP：" + colStr);
         logger.info("importExcel of 执行前置SP参数：" + colStrIndex);
         result.put("sp1", this.excelService.importExcel4SP(colStr, colStrIndex));
      }

      ArrayList var21 = new ArrayList();
      StringBuilder var22 = new StringBuilder("(");
      Iterator xrList = excelTemplate.getCol2FieldList().iterator();

      while(xrList.hasNext()) {
         Col2Field var23 = (Col2Field)xrList.next();
         var22.append(var23.getColName());
         var22.append(",");
      }

      int var24 = var22.lastIndexOf(",");
      if(var24 >= 0) {
         var22 = var22.deleteCharAt(var24);
      }

      var22.append(")");
      List var25 = xs.getRowList();
      int endRow = excelTemplate.getEndRowsNum() == 0?xs.getRowList().size():(excelTemplate.getEndRowsNum() > xs.getRowList().size()?xs.getRowList().size():excelTemplate.getEndRowsNum());
      int count = excelTemplate.getStartRowsNum();

      while(count < endRow) {
         XRow procedure = (XRow)var25.get(count);
         StringBuilder sp = new StringBuilder("(");
         boolean paList = true;
         Iterator sql = excelTemplate.getCol2FieldList().iterator();

         while(true) {
            if(sql.hasNext()) {
               label111: {
                  Col2Field valStrIndex = (Col2Field)sql.next();
                  String value;
                  if(!StringUtils.isNotEmpty(valStrIndex.getXlsCol())) {
                     String var31 = valStrIndex.getFieldType();
                     value = valStrIndex.getDefaultValue();
                     reqParasMap.put("LINE_NO", String.valueOf(count));
                     value = ExpressionKit.replaceParas(value, reqParasMap);
                     if(var31.equalsIgnoreCase("NUMBER")) {
                        sp.append(StringUtils.isNotEmpty(value)?value:"null");
                        sp.append(",");
                     } else {
                        sp.append("\'");
                        sp.append(value);
                        sp.append("\'");
                        sp.append(",");
                     }
                     continue;
                  }

                  if(procedure.getCellList().size() <= valStrIndex.getFieldIndex()) {
                     sp.append("null");
                     sp.append(",");
                     continue;
                  }

                  XCell type = (XCell)procedure.getCellList().get(valStrIndex.getFieldIndex());
                  value = valStrIndex.getDefaultValue();
                  if(StringUtils.contains(value, "{$")) {
                     value = ExpressionKit.replaceParas(value, reqParasMap);
                  }

                  String value1 = ObjectUtils.toString(type.getValue(), "");
                  if(StringUtils.isEmpty(value1)) {
                     if(!valStrIndex.isEmptyIsImp()) {
                        paList = false;
                        break label111;
                     }

                     if(StringUtils.isNotEmpty(value)) {
                        value1 = value;
                     }
                  }

                  String type1 = valStrIndex.getFieldType();
                  if(type1.equalsIgnoreCase("NUMBER")) {
                     sp.append(StringUtils.isNotEmpty(value1)?value1:"null");
                     sp.append(",");
                  } else {
                     sp.append("\'");
                     sp.append(value1);
                     sp.append("\'");
                     sp.append(",");
                  }
                  continue;
               }
            }

            if(paList) {
               int var29 = sp.lastIndexOf(",");
               if(var29 >= 0) {
                  sp = sp.deleteCharAt(var29);
               }

               sp.append(")");
               String var30 = "INSERT INTO " + excelTemplate.getTemplateTbName() + var22.toString() + " VALUES" + sp.toString();
               logger.info(var30);
               var21.add(var30);
            }

            ++count;
            break;
         }
      }

      count = 0;
      if(var21.size() > 0) {
         try {
            count += this.excelService.insertBatch(var21);
         } catch (Exception var20) {
            result.put("error", var20.getMessage());
         }

         result.put("count", Integer.valueOf(count));
      }

      if(ObjectUtils.notEqual(excelTemplate.getEndExecSp(), (Object)null)) {
         Procedure var26 = excelTemplate.getEndExecSp();
         String var27 = var26.getProceSql();
         List var28 = var26.getProcedureArguments();
         logger.info("importExcel of 执行后置SP：" + var27);
         logger.info("importExcel of 执行后置SP参数：" + var28);
         result.put("sp2", this.excelService.importExcel4SP(var27, var28));
      }

      return result;
   }

   private Map getCommonParas(String userName) {
      HashMap paras = new HashMap();
      Date date = new Date();
      paras.put("CURRENT_USER_NAME", userName);
      SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
      SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
      paras.put("CURRENT_DATE", sdf.format(date));
      paras.put("CURRENT_TIME", dateformat.format(date));
      paras.put("GUID", UUID.randomUUID().toString().replaceAll("-", ""));
      return paras;
   }
}
