package com.rw.aml.manger.xml.xml;

import com.rw.aml.model.report.NssReportModel;
import com.rw.aml.model.table.TExpNssClientModel;
import com.rw.aml.model.table.TExpNssModel;
import com.rw.aml.model.table.TExpNssTradeModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class NssXmlBuilder {

   private static NssXmlBuilder builder;


   public static NssXmlBuilder getInstance() {
      if(builder == null) {
         builder = new NssXmlBuilder();
      }

      return builder;
   }

   public String build(NssReportModel reportModel) throws RuntimeException {
      String result = this.getReportXML(reportModel);
      return result;
   }

   public List build(List reportModelList) throws RuntimeException {
      ArrayList resultList = new ArrayList();
      Iterator var4 = reportModelList.iterator();

      while(var4.hasNext()) {
         NssReportModel reportModel = (NssReportModel)var4.next();
         String result = this.getReportXML(reportModel);
         resultList.add(result);
      }

      return resultList;
   }

   private String getReportXML(NssReportModel reportModel) throws RuntimeException {
      StringBuilder sb = new StringBuilder();
      sb.append("<?xml version=\"1.0\" encoding=\"GB18030\" ?>");
      if(reportModel == null) {
         return sb.toString();
      } else {
         TExpNssModel baseModel = reportModel.getBaseModel();
         List clientModelList = reportModel.getClientModelList();
         List tradeModelList = reportModel.getTradeModelList();
         Map clientCorpInfoMap = reportModel.getClientCorpInfoMap();
         int clientCnt = 0;
         if(clientModelList != null) {
            clientCnt = clientModelList.size();
         }

         int tradeCnt = 0;
         if(tradeModelList != null) {
            tradeCnt = tradeModelList.size();
         }

         sb.append("<SSTR>");
         sb.append(baseModel.GetRBIFInfo(clientCnt, tradeCnt));
         sb.append("<CTIFs>");
         int i;
         if(clientModelList != null) {
            for(i = 0; i < clientCnt; ++i) {
               TExpNssClientModel rpdi = (TExpNssClientModel)clientModelList.get(i);
               String fdac = rpdi.getFdac();
               List corpInfoList = (List)clientCorpInfoMap.get(fdac);
               sb.append(rpdi.getXmlString(corpInfoList));
            }
         }

         sb.append("</CTIFs>");
         sb.append("<RPDIs>");
         if(tradeModelList != null) {
            for(i = 0; i < tradeCnt; ++i) {
               TExpNssTradeModel var13 = (TExpNssTradeModel)tradeModelList.get(i);
               sb.append(var13.getXmlString());
            }
         }

         sb.append("</RPDIs>");
         sb.append("</SSTR>");
         return sb.toString();
      }
   }
}
