package com.rw.aml.manger.xml.xml;

import com.rw.aml.manger.xml.xml.XmlBuild;
import com.rw.aml.model.report.DshReportModel;
import com.rw.aml.model.table.TExpDshCustModel;
import com.rw.aml.model.table.TExpDshModel;
import com.rw.aml.model.table.VDshCihtrDetailModel;
import com.rw.aml.model.table.VDshDhtrDetailModel;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DshXmlBuilder extends XmlBuild {

   private static DshXmlBuilder builder;


   public static DshXmlBuilder getInstance() {
      if(builder == null) {
         builder = new DshXmlBuilder();
      }

      return builder;
   }

   public String build(DshReportModel reportModel, int actionId) throws RuntimeException {
      String result = "";
      switch(actionId) {
      case 0:
      case 1:
      case 2:
         result = this.getNRAReportXml(reportModel);
         break;
      case 3:
      case 4:
         result = this.getICReportXml(reportModel, actionId);
         break;
      case 5:
         result = this.getDReportXml(reportModel);
      }

      return result;
   }

   private String getNRAReportXml(DshReportModel reportModel) throws RuntimeException {
      StringBuilder sb = new StringBuilder();
      sb.append("<?xml version=\"1.0\" encoding=\"GB18030\" ?>");
      if(reportModel == null) {
         return sb.toString();
      } else {
         TExpDshModel baseModel = reportModel.getBaseModel();
         List clientModelList = reportModel.getClientModelList();
         Map totalTradeMap = reportModel.getTotalTradeMap();
         Map detailTradeMap = reportModel.getDetailTradeMap();
         int clientCnt = 0;
         if(clientModelList != null) {
            clientCnt = clientModelList.size();
         }

         sb.append("<HVTR>");
         sb.append("<RBIF>");
         sb.append(this.GetXmlElement("RINM", baseModel.getRinm()));
         sb.append(this.GetXmlElement("RICD", baseModel.getRicd()));
         sb.append(this.GetXmlElement("RPDT", baseModel.getRpdt()));
         sb.append(this.GetXmlElement("CTTN", String.valueOf(clientCnt)));
         sb.append("</RBIF>");
         sb.append("<CATIs>");
         if(clientModelList != null) {
            Iterator var9 = clientModelList.iterator();

            while(var9.hasNext()) {
               TExpDshCustModel client = (TExpDshCustModel)var9.next();
               String catiId = client.getCatiId();
               List tradeTotalList = (List)totalTradeMap.get(catiId);
               String clientXml = client.getXmlString(tradeTotalList, detailTradeMap);
               sb.append(clientXml);
            }
         }

         sb.append("</CATIs>");
         sb.append("</HVTR>");
         return sb.toString();
      }
   }

   private String getDReportXml(DshReportModel reportModel) throws RuntimeException {
      StringBuilder sb = new StringBuilder();
      sb.append("<?xml version=\"1.0\" encoding=\"GB18030\" ?>");
      if(reportModel == null) {
         return sb.toString();
      } else {
         TExpDshModel baseModel = reportModel.getBaseModel();
         List vwDshDhtrDetailList = reportModel.getVwDshDhtrDetailList();
         int detailSize = 0;
         if(vwDshDhtrDetailList != null) {
            detailSize = vwDshDhtrDetailList.size();
         }

         sb.append("<DHTR>");
         sb.append(baseModel.GetDRBIFInfo(detailSize));
         sb.append("<DTDTs>");
         if(vwDshDhtrDetailList != null) {
            Iterator var7 = vwDshDhtrDetailList.iterator();

            while(var7.hasNext()) {
               VDshDhtrDetailModel detail = (VDshDhtrDetailModel)var7.next();
               sb.append(detail.getXmlString());
            }
         }

         sb.append("</DTDTs>");
         sb.append("</DHTR>");
         return sb.toString();
      }
   }

   private String getICReportXml(DshReportModel reportModel, int actionId) throws RuntimeException {
      StringBuilder sb = new StringBuilder();
      sb.append("<?xml version=\"1.0\" encoding=\"GB18030\" ?>");
      if(reportModel == null) {
         return sb.toString();
      } else {
         TExpDshModel baseModel = reportModel.getBaseModel();
         List vwDshCihtrDetailList = reportModel.getVwDshCihtrDetailList();
         int detailSize = 0;
         if(vwDshCihtrDetailList != null) {
            detailSize = vwDshCihtrDetailList.size();
         }

         if(actionId == 3) {
            sb.append("<CHTR>");
         } else if(actionId == 4) {
            sb.append("<IHTR>");
         }

         sb.append(baseModel.GetICRBIFInfo(detailSize, actionId));
         sb.append("<TSDTs>");
         if(vwDshCihtrDetailList != null) {
            Iterator var8 = vwDshCihtrDetailList.iterator();

            while(var8.hasNext()) {
               VDshCihtrDetailModel detail = (VDshCihtrDetailModel)var8.next();
               sb.append(detail.getXmlString());
            }
         }

         sb.append("</TSDTs>");
         if(actionId == 3) {
            sb.append("</CHTR>");
         } else if(actionId == 4) {
            sb.append("</IHTR>");
         }

         return sb.toString();
      }
   }
}
