package com.rw.aml.manger.xml.data;

import com.rw.aml.dao.NssReportDAO;
import com.rw.aml.model.report.NssReportModel;
import com.rw.aml.model.table.TExpNssClientModel;
import com.rw.aml.model.table.TExpNssModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NssDataBuilder {

   @Autowired
   private NssReportDAO nssReportDAO;
   private static NssDataBuilder builder;


   public static NssDataBuilder getInstance() {
      if(builder == null) {
         builder = new NssDataBuilder();
      }

      return builder;
   }

   public List getNssReportInfo(List sstrIdList) throws Exception {
      ArrayList resultList = null;
      List baseModelList = this.nssReportDAO.getTExpNssInfo(sstrIdList);
      if(baseModelList != null && baseModelList.size() != 0) {
         int reportNum = baseModelList.size();
         resultList = new ArrayList(reportNum);
         Iterator var6 = baseModelList.iterator();

         while(var6.hasNext()) {
            TExpNssModel baseModel = (TExpNssModel)var6.next();
            NssReportModel reportModel = this.getNssReportInfo((TExpNssModel)baseModel);
            resultList.add(reportModel);
         }
      }

      return resultList;
   }

   public NssReportModel getNssReportInfo(String sstrId) throws Exception {
      TExpNssModel baseModel = this.nssReportDAO.getTExpNssInfo(sstrId);
      NssReportModel reportModel = this.getNssReportInfo((TExpNssModel)baseModel);
      return reportModel;
   }

   private NssReportModel getNssReportInfo(TExpNssModel baseModel) throws Exception {
      NssReportModel reportModel = null;
      if(baseModel != null) {
         reportModel = new NssReportModel();
         reportModel.setBaseModel(baseModel);
         String subSstrId = baseModel.getSstrId();
         List clientModelList = this.nssReportDAO.getTExpNssClientInfoLst(subSstrId);
         reportModel.setClientModelList(clientModelList);
         HashMap clientCorpInfoMap = null;
         if(clientModelList != null && clientModelList.size() != 0) {
            clientCorpInfoMap = new HashMap();
            Iterator reportId = clientModelList.iterator();

            while(reportId.hasNext()) {
               TExpNssClientModel tradeModelList = (TExpNssClientModel)reportId.next();
               String fileModelList = tradeModelList.getFdac();
               Object obj = clientCorpInfoMap.get(fileModelList);
               if(obj == null) {
                  List corpInfoList = this.nssReportDAO.getTExpClientCorpInfoLst(fileModelList);
                  clientCorpInfoMap.put(fileModelList, corpInfoList);
               }
            }
         }

         reportModel.setClientCorpInfoMap(clientCorpInfoMap);
         List tradeModelList1 = this.nssReportDAO.getTExpNssTradeInfoLst(subSstrId);
         reportModel.setTradeModelList(tradeModelList1);
         String reportId1 = baseModel.getReportId();
         List fileModelList1 = this.nssReportDAO.getTExpNssAttachmentInfoLst(reportId1);
         reportModel.setFileModelList(fileModelList1);
      }

      return reportModel;
   }
}
