package com.rw.aml.manger.xml.data;

import com.rw.aml.dao.DshReportDAO;
import com.rw.aml.model.report.DshReportModel;
import com.rw.aml.model.table.TExpDshCustModel;
import com.rw.aml.model.table.TExpDshModel;
import com.rw.aml.model.table.TExpDshTradeTotalModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DshDataBuilder {

   private static DshDataBuilder builder;
   @Autowired
   private DshReportDAO dshReportDAO;


   public static DshDataBuilder getInstance() {
      if(builder == null) {
         builder = new DshDataBuilder();
      }

      return builder;
   }

   public List getNshReportInfo(List dshIdList, int actionId) throws RuntimeException {
      ArrayList resultList = null;
      List baseModelList = this.dshReportDAO.getTExpDshInfo(dshIdList);
      if(baseModelList != null && baseModelList.size() != 0) {
         int reportNum = baseModelList.size();
         resultList = new ArrayList(reportNum);
         Iterator var7 = baseModelList.iterator();

         while(var7.hasNext()) {
            TExpDshModel model = (TExpDshModel)var7.next();
            DshReportModel reportModel = this.getNshReportInfo((TExpDshModel)model, actionId);
            resultList.add(reportModel);
         }
      }

      return resultList;
   }

   public DshReportModel getNshReportInfo(String dshId, int actionId) throws Exception {
      TExpDshModel baseModel = this.dshReportDAO.getTExpDshInfo(dshId);
      DshReportModel reportModel = this.getNshReportInfo((TExpDshModel)baseModel, actionId);
      return reportModel;
   }

   private DshReportModel getNshReportInfo(TExpDshModel baseModel, int actionId) throws RuntimeException {
      DshReportModel reportModel = null;
      if(baseModel != null) {
         reportModel = new DshReportModel();
         reportModel.setBaseModel(baseModel);
         String dshId = baseModel.getDshId();
         int records = this.dshReportDAO.getAllTradeDetailNumber(dshId);
         if(records > 10000) {
            throw new RuntimeException("该报文的所含交易笔数必须小于10000条!");
         }

         switch(actionId) {
         case 0:
         case 1:
         case 2:
            List clientModelList = this.dshReportDAO.getTExpDshCustInfoLst(dshId);
            reportModel.setClientModelList(clientModelList);
            if(clientModelList != null) {
               HashMap vwDshCihtrDetailList1 = new HashMap();
               HashMap vwDshDhtrDetailList1 = new HashMap();
               Iterator var10 = clientModelList.iterator();

               while(var10.hasNext()) {
                  TExpDshCustModel clientModel = (TExpDshCustModel)var10.next();
                  String catiId = clientModel.getCatiId();
                  List tradeTotalList = this.dshReportDAO.getTExpDshTradeTotalInfo(catiId);
                  vwDshCihtrDetailList1.put(catiId, tradeTotalList);
                  if(tradeTotalList != null) {
                     Iterator var14 = tradeTotalList.iterator();

                     while(var14.hasNext()) {
                        TExpDshTradeTotalModel tradeTotal = (TExpDshTradeTotalModel)var14.next();
                        String htcrId = tradeTotal.getHtcrId();
                        List tradeDetailList = this.dshReportDAO.getTExpDshTradeDetailInfoList(htcrId);
                        vwDshDhtrDetailList1.put(htcrId, tradeDetailList);
                     }
                  }
               }

               reportModel.setTotalTradeMap(vwDshCihtrDetailList1);
               reportModel.setDetailTradeMap(vwDshDhtrDetailList1);
            }
            break;
         case 3:
         case 4:
            List vwDshCihtrDetailList = this.dshReportDAO.getVDshCihtrDetailInfo(dshId);
            reportModel.setVwDshCihtrDetailList(vwDshCihtrDetailList);
            break;
         case 5:
            List vwDshDhtrDetailList = this.dshReportDAO.getVDshDhtrDetailModel(dshId);
            reportModel.setVwDshDhtrDetailList(vwDshDhtrDetailList);
         }
      }

      return reportModel;
   }
}
