package com.rw.aml.manger.xml.build.name;

import com.rw.aml.manger.xml.build.name.FileNameType;
import com.rw.aml.util.StrUtil;

public class CorrectFileNameType extends FileNameType {

   private static final String strFileType = "C";


   public CorrectFileNameType(String exchangeSign) {
      this.strExchangeSign = exchangeSign;
      this.strPackageType = "S";
   }

   public String generateXmlFileName(int reportNo, String oldCode) throws RuntimeException {
      String result = "";
      if("SS".equals(this.strExchangeSign)) {
         if(oldCode == null || "".equals(oldCode)) {
            throw new RuntimeException("可疑报告的纠错报文没有原来上报时候的编号！");
         }

         result = "C" + this.strExchangeSign + reportOrgNum + "-" + oldCode;
      } else {
         result = "C" + this.strExchangeSign + reportOrgNum + "-" + this.reportDate + "-" + StrUtil.cvtRegNo(this.zipNo) + "-" + StrUtil.cvtRegNo((long)reportNo);
         this.newCode = this.reportDate + "-" + StrUtil.cvtRegNo(this.zipNo) + "-" + StrUtil.cvtRegNo((long)reportNo);
      }

      return result;
   }
}
