package com.rw.aml.manger.xml.build;

import com.rw.aml.dao.AmlBaseDAO;
import com.rw.aml.dao.DshReportDAOImpl;
import com.rw.aml.manger.xml.build.name.AddFileNameType;
import com.rw.aml.manger.xml.build.name.CorrectFileNameType;
import com.rw.aml.manger.xml.build.name.DeleteFileNameType;
import com.rw.aml.manger.xml.build.name.FileNameType;
import com.rw.aml.manger.xml.build.name.NormalFileNameType;
import com.rw.aml.manger.xml.build.name.RectiFileNameType;
import com.rw.aml.manger.xml.build.name.ResendFileNameType;
import com.rw.aml.model.report.ZipFileModel;
import com.rw.aml.model.table.TFileModel;
import com.rw.aml.model.table.TReportFilesModel;
import com.rw.aml.util.StrUtil;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class ReportBuild {

   public static final String tblSchema = "amldata";
   @Autowired
   private DshReportDAOImpl dshReportDAO;
   @Autowired
   private AmlBaseDAO amlBaseDAO;


   protected abstract ZipFileModel build(List var1, int var2, String var3) throws Exception;

   public void processDataBuild(List sqlList, byte[] content, String fileUuid) {
      this.dshReportDAO.batchExcute(sqlList);
      this.dshReportDAO.insertFileContent(content, fileUuid);
   }

   protected FileNameType getFileNameTypeByAction(int actionId, String exchangeSign) throws RuntimeException {
      Object type = null;
      switch(actionId) {
      case 0:
         type = new NormalFileNameType(exchangeSign);
         break;
      case 1:
         type = new ResendFileNameType(exchangeSign);
         break;
      case 2:
         type = new AddFileNameType(exchangeSign);
         break;
      case 3:
         type = new CorrectFileNameType(exchangeSign);
         break;
      case 4:
         type = new RectiFileNameType(exchangeSign);
         break;
      case 5:
         if(!"SH".equals(exchangeSign)) {
            throw new RuntimeException("可疑报文不能执行删除操作！");
         }

         type = new DeleteFileNameType(exchangeSign);
      }

      if(type == null) {
         throw new RuntimeException("错误的操作类型！");
      } else {
         return (FileNameType)type;
      }
   }

   protected String getInstReportFileSql(TReportFilesModel model) {
      StringBuilder sql = new StringBuilder();
      sql.append("insert into amldata.t_report_files(pk_id, object_id, report_type, message_type, report_date, build_date, zip_no)");
      sql.append(" values(\'");
      sql.append(model.getId());
      sql.append("\',\'");
      sql.append(model.getObjectId());
      sql.append("\',\'");
      int exchangeSign = StrUtil.cvtReportTypeToInt(model.getReportType());
      sql.append(exchangeSign);
      sql.append("\',\'");
      sql.append(model.getMessageType());
      sql.append("\',\'");
      sql.append(model.getReportDate());
      sql.append("\',");
      sql.append("sysdate,");
      sql.append(model.getZipNo());
      sql.append(")");
      return sql.toString();
   }

   protected String getInstFileSql(TFileModel model) throws Exception {
      StringBuilder sql = new StringBuilder();
      sql.append("insert into wolfdata.t_files(id, object_id, name, file_size, extension, create_by, create_time, file_flag)");
      sql.append(" values(\'");
      sql.append(model.getId());
      sql.append("\',\'");
      sql.append(model.getObjectId());
      sql.append("\',\'");
      sql.append(model.getName());
      sql.append("\',\'");
      sql.append(model.getFileSize());
      sql.append("\',\'");
      sql.append(model.getExtension());
      sql.append("\',\'");
      sql.append(model.getCreateBy());
      sql.append("\',");
      sql.append("sysdate,\'");
      sql.append(model.getCreateBy());
      sql.append("\')");
      return sql.toString();
   }

   protected boolean checkZipFileSize(String fileName, long cmpSize) throws Exception {
      boolean blResult = Boolean.FALSE.booleanValue();
      long size = 0L;
      File file = new File(fileName);
      if(file.exists()) {
         FileInputStream fis = new FileInputStream(file);
         size = (long)fis.available();
         fis.close();
         if(size > cmpSize) {
            blResult = Boolean.TRUE.booleanValue();
         }

         return blResult;
      } else {
         throw new Exception("文件不存在！");
      }
   }

   protected List getUpdateOldCodeSql(Map codeMap, int type) throws Exception {
      ArrayList sqlList = null;
      if(codeMap != null && codeMap.size() != 0) {
         sqlList = new ArrayList();

         String sql;
         for(Iterator iter = codeMap.entrySet().iterator(); iter.hasNext(); sqlList.add(sql)) {
            Entry entry = (Entry)iter.next();
            String key = (String)entry.getKey();
            String value = (String)entry.getValue();
            sql = "";
            if(type == 1) {
               sql = "update amldata.T_EXP_DSH t set t.old_code = \'" + value + "\' where t.dsh_id = \'" + key + "\'";
            } else if(type == 2) {
               sql = "update amldata.T_EXP_NSS t set t.old_code = \'" + value + "\' where t.sstr_id = \'" + key + "\'";
            }
         }
      }

      return sqlList;
   }

   public TFileModel getFileContentByParameter(String objectIds, String reportType, String messageType) throws Exception {
      return this.amlBaseDAO.getFileContentByParameter(objectIds, reportType, messageType);
   }

   public TFileModel getFileContentByReportId(String reportId) throws Exception {
      return this.amlBaseDAO.getFileContentByReportId(reportId);
   }

   public ZipFileModel getFileContent(TFileModel model) throws Exception {
      ZipFileModel zipFileModel = new ZipFileModel();
      String id = model.getId();
      zipFileModel.setName(model.getName());
      zipFileModel.setExtension(model.getExtension());
      byte[] content = this.amlBaseDAO.getFileContent(id);
      zipFileModel.setContent(content);
      return zipFileModel;
   }
}
