package com.rw.aml.manger.xml.build;

import com.rw.aml.manger.xml.build.ReportBuild;
import com.rw.aml.manger.xml.build.name.FileNameType;
import com.rw.aml.manger.xml.data.NssDataBuilder;
import com.rw.aml.manger.xml.xml.NssXmlBuilder;
import com.rw.aml.model.report.NssReportModel;
import com.rw.aml.model.report.ZipFileModel;
import com.rw.aml.model.table.TFileModel;
import com.rw.aml.model.table.TReportFilesModel;
import com.rw.aml.util.FileUtil;
import com.rw.aml.util.StrUtil;
import com.rw.aml.util.XmlUtil;
import com.rw.aml.util.ZipUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NssReportBuilder extends ReportBuild {

   private static final Logger logger = Logger.getLogger(NssReportBuilder.class);
   @Autowired
   private NssDataBuilder nssDataBuilder;


   public ZipFileModel build(List sstrIdList, int actionId, String userCode) throws Exception {
      logger.debug("build start...");
      String dirPath = StrUtil.getZipDirPath();
      if(sstrIdList != null && sstrIdList.size() != 0) {
         List reportModelList = this.nssDataBuilder.getNssReportInfo(sstrIdList);
         if(reportModelList != null && reportModelList.size() != 0) {
            FileNameType fileNameType = this.getFileNameTypeByAction(actionId, "SS");
            String zipFileName = fileNameType.generateZipName(userCode);
            String zipPath = dirPath + zipFileName;
            File file = new File(zipPath);
            if(!file.exists()) {
               file.mkdir();
            }

            int serNo = 1;
            HashMap newCodeMap = new HashMap();

            String instReportFileSql;
            for(Iterator sqlList = reportModelList.iterator(); sqlList.hasNext(); ++serNo) {
               NssReportModel zipDestFile = (NssReportModel)sqlList.next();
               String rptFilesModel = NssXmlBuilder.getInstance().build(zipDestFile);
               String uuid = zipDestFile.getBaseModel().getOldCode();
               instReportFileSql = fileNameType.generateXmlFileName(serNo, uuid);
               String cdSqlList = fileNameType.getNewCode();
               String content;
               if(cdSqlList != null && !"".equals(cdSqlList)) {
                  content = zipDestFile.getBaseModel().getSstrId();
                  newCodeMap.put(content, cdSqlList);
               }

               content = zipPath + File.separator + instReportFileSql;
               XmlUtil.string2XmlFile(rptFilesModel, content + "." + "XML".toUpperCase());
               List result = zipDestFile.getFileModelList();
               if(result != null && result.size() > 0) {
                  File fileModel = new File(content);
                  if(!fileModel.exists()) {
                     fileModel.mkdir();
                  }

                  Iterator tbfileSql = result.iterator();

                  while(tbfileSql.hasNext()) {
                     TFileModel fileUuid = (TFileModel)tbfileSql.next();
                     String attachFileName = fileUuid.getName() + "." + fileUuid.getExtension();
                     logger.debug("attachFileName:" + attachFileName);
                     FileUtil.byteToFile(fileUuid.getContent(), content + File.separator + attachFileName);
                  }

                  String var32 = zipPath + File.separator + instReportFileSql + "." + "ZIP".toUpperCase();
                  ZipUtil.zip(content, var32);
                  if(this.checkZipFileSize(var32, 2097152L)) {
                     FileUtil.delDir(fileModel);
                     throw new RuntimeException("附件大小超过2M!");
                  }

                  FileUtil.delDir(fileModel);
               }
            }

            String var24 = dirPath + File.separator + zipFileName + "." + "ZIP".toUpperCase();
            ZipUtil.zip(zipPath, var24);
            if(this.checkZipFileSize(var24, 5242880L)) {
               FileUtil.delDir(file);
               throw new RuntimeException("数据包大小超过5M!");
            } else {
               FileUtil.delDir(file);
               ArrayList var25 = new ArrayList();
               TReportFilesModel var26 = new TReportFilesModel();
               UUID var27 = UUID.randomUUID();
               var26.setId(var27.toString());
               var26.setMessageType(String.valueOf(actionId));
               var26.setObjectId(StrUtil.listToString(sstrIdList, ','));
               var26.setReportType("SS");
               var26.setReportDate(fileNameType.getReportDate());
               var26.setZipNo(fileNameType.getZipNo());
               instReportFileSql = this.getInstReportFileSql(var26);
               var25.add(instReportFileSql);
               List var28 = this.getUpdateOldCodeSql(newCodeMap, 2);
               if(var28 != null) {
                  var25.addAll(var28);
               }

               byte[] var29 = FileUtil.fileToByte(var24);
               ZipFileModel var30 = new ZipFileModel();
               var30.setContent(var29);
               var30.setName(zipFileName);
               var30.setExtension("ZIP".toUpperCase());
               TFileModel var31 = new TFileModel();
               var31.setCreateBy(userCode);
               var31.setFileFlag(userCode);
               var31.setObjectId(var27.toString());
               UUID var33 = UUID.randomUUID();
               var31.setId(var33.toString());
               var31.setName(zipFileName);
               var31.setFileSize(String.valueOf(var29.length));
               var31.setExtension("ZIP".toUpperCase());
               String var34 = this.getInstFileSql(var31);
               var25.add(var34);
               this.processDataBuild(var25, var29, var33.toString());
               logger.debug("build end...");
               return var30;
            }
         } else {
            throw new RuntimeException("该报告无数据!");
         }
      } else {
         throw new RuntimeException("该选择报告!");
      }
   }
}
