package com.rw.aml.manger.xml.build;

import com.rw.aml.manger.xml.build.ReportBuild;
import com.rw.aml.manger.xml.build.name.FileNameType;
import com.rw.aml.manger.xml.data.DshDataBuilder;
import com.rw.aml.manger.xml.xml.DshXmlBuilder;
import com.rw.aml.model.report.DshReportModel;
import com.rw.aml.model.report.ZipFileModel;
import com.rw.aml.model.table.TFileModel;
import com.rw.aml.model.table.TReportFilesModel;
import com.rw.aml.util.FileUtil;
import com.rw.aml.util.StrUtil;
import com.rw.aml.util.XmlUtil;
import com.rw.aml.util.ZipUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DshReportBuilder extends ReportBuild {

   private static final Logger logger = Logger.getLogger(DshReportBuilder.class);
   @Autowired
   private DshDataBuilder dshDataBuilder;


   public ZipFileModel build(List dshIdList, int actionId, String userCode) throws Exception {
      logger.debug("build start...");
      String dirPath = StrUtil.getZipDirPath();
      if(dshIdList != null && dshIdList.size() != 0) {
         List reportModelList = this.dshDataBuilder.getNshReportInfo(dshIdList, actionId);
         if(reportModelList != null && reportModelList.size() != 0) {
            FileNameType fileNameType = this.getFileNameTypeByAction(actionId, "SH");
            String zipFileName = fileNameType.generateZipName(userCode);
            String zipPath = dirPath + zipFileName;
            File file = new File(zipPath);
            if(!file.exists()) {
               file.mkdir();
            }

            int serNo = 1;
            HashMap newCodeMap = new HashMap();

            String instReportFileSql;
            for(Iterator sqlList = reportModelList.iterator(); sqlList.hasNext(); ++serNo) {
               DshReportModel zipDestFile = (DshReportModel)sqlList.next();
               String rptFilesModel = DshXmlBuilder.getInstance().build(zipDestFile, actionId);
               String uuid = zipDestFile.getBaseModel().getOldCode();
               instReportFileSql = fileNameType.generateXmlFileName(serNo, uuid);
               String cdSqlList = fileNameType.getNewCode();
               String content;
               if(cdSqlList != null && !"".equals(cdSqlList)) {
                  content = zipDestFile.getBaseModel().getDshId();
                  newCodeMap.put(content, cdSqlList);
               }

               content = zipPath + File.separator + instReportFileSql;
               XmlUtil.string2XmlFile(rptFilesModel, content + "." + "XML".toUpperCase());
            }

            String var23 = dirPath + File.separator + zipFileName + "." + "ZIP".toUpperCase();
            ZipUtil.zip(zipPath, var23);
            if(this.checkZipFileSize(var23, 5242880L)) {
               FileUtil.delDir(file);
               throw new RuntimeException("数据包大小超过5M!");
            } else {
               FileUtil.delDir(file);
               ArrayList var24 = new ArrayList();
               TReportFilesModel var25 = new TReportFilesModel();
               UUID var26 = UUID.randomUUID();
               var25.setId(var26.toString());
               var25.setMessageType(String.valueOf(actionId));
               var25.setObjectId(StrUtil.listToString(dshIdList, ','));
               var25.setReportType("SH");
               var25.setReportDate(fileNameType.getReportDate());
               var25.setZipNo(fileNameType.getZipNo());
               instReportFileSql = this.getInstReportFileSql(var25);
               var24.add(instReportFileSql);
               List var27 = this.getUpdateOldCodeSql(newCodeMap, 1);
               if(var27 != null) {
                  var24.addAll(var27);
               }

               byte[] var28 = FileUtil.fileToByte(var23);
               ZipFileModel result = new ZipFileModel();
               result.setContent(var28);
               result.setName(zipFileName);
               result.setExtension("ZIP".toUpperCase());
               TFileModel fileModel = new TFileModel();
               fileModel.setCreateBy(userCode);
               fileModel.setFileFlag(userCode);
               fileModel.setObjectId(var26.toString());
               UUID fileUuid = UUID.randomUUID();
               fileModel.setId(fileUuid.toString());
               fileModel.setName(zipFileName);
               fileModel.setFileSize(String.valueOf(var28.length));
               fileModel.setExtension("ZIP".toUpperCase());
               String tbfileSql = this.getInstFileSql(fileModel);
               var24.add(tbfileSql);
               this.processDataBuild(var24, var28, fileUuid.toString());
               logger.debug("build end...");
               return result;
            }
         } else {
            throw new RuntimeException("该报告无数据!");
         }
      } else {
         throw new RuntimeException("请选择报告!");
      }
   }
}
