package com.rw.aml.dao;

import com.rw.aml.dao.AmlBaseDAOImpl;
import com.rw.aml.dao.NssReportDAO;
import com.rw.aml.model.table.TExpClientCorpInfoModel;
import com.rw.aml.model.table.TExpNssClientModel;
import com.rw.aml.model.table.TExpNssModel;
import com.rw.aml.model.table.TExpNssTradeModel;
import com.rw.aml.model.table.TFileModel;
import com.rw.util.CommonKit;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository("nssReportDAO")
public class NssReportDAOImpl extends AmlBaseDAOImpl implements NssReportDAO {

   private static final Logger logger = LoggerFactory.getLogger(NssReportDAOImpl.class);


   public List getTExpNssInfo(List sstrIdList) throws RuntimeException {
      logger.debug("getTExpNssInfo start...");
      String sql = "select * from amldata.T_EXP_NSS t ";
      if(sstrIdList != null && sstrIdList.size() > 0) {
         StringBuilder list = new StringBuilder();
         list.append(sql);
         list.append(" where t.sstr_id in");
         list.append("(");
         Iterator map = sstrIdList.iterator();

         while(map.hasNext()) {
            String modelList = (String)map.next();
            list.append("\'");
            list.append(modelList);
            list.append("\'");
            list.append(",");
         }

         list.deleteCharAt(list.length() - 1);
         list.append(")");
         sql = list.toString();
      }

      List list1 = this.findList(sql);
      ArrayList modelList1 = new ArrayList(list1.size());
      Iterator var6 = list1.iterator();

      while(var6.hasNext()) {
         Map map1 = (Map)var6.next();
         TExpNssModel model = (TExpNssModel)CommonKit.mapToModel(map1, new TExpNssModel());
         modelList1.add(model);
      }

      return modelList1;
   }

   public TExpNssModel getTExpNssInfo(String sstrId) throws RuntimeException {
      logger.debug("getTExpNssInfo start...");
      String sql = "select * from amldata.T_EXP_NSS t where t.sstr_id= ?";
      List list = this.findList(sql, new Object[]{sstrId});
      if(list.size() > 0) {
         Map map = (Map)list.get(0);
         TExpNssModel model = (TExpNssModel)CommonKit.mapToModel(map, new TExpNssModel());
         return model;
      } else {
         return null;
      }
   }

   public List getTExpNssClientInfoLst(String sstrId) throws RuntimeException {
      logger.debug("getTExpNssClientInfoLst start...");
      String sql = "select * from amldata.T_EXP_NSS_CLIENT t where t.sstr_id= ? order by chif_seqno";
      List list = this.findList(sql, new Object[]{sstrId});
      ArrayList modelList = new ArrayList(list.size());
      Iterator var6 = list.iterator();

      while(var6.hasNext()) {
         Map map = (Map)var6.next();
         TExpNssClientModel model = (TExpNssClientModel)CommonKit.mapToModel(map, new TExpNssClientModel());
         modelList.add(model);
      }

      return modelList;
   }

   public List getTExpClientCorpInfoLst(String fdac) throws RuntimeException {
      logger.debug("getTExpClientCorpInfoLst start...");
      String sql = "select * from amldata.T_EXP_CLIENT_CORP_INFO t where t.CLIENT_ID = ?";
      List list = this.findList(sql, new Object[]{fdac});
      ArrayList modelList = new ArrayList(list.size());
      Iterator var6 = list.iterator();

      while(var6.hasNext()) {
         Map map = (Map)var6.next();
         TExpClientCorpInfoModel model = (TExpClientCorpInfoModel)CommonKit.mapToModel(map, new TExpClientCorpInfoModel());
         modelList.add(model);
      }

      return modelList;
   }

   public List getTExpNssTradeInfoLst(String sstrId) throws RuntimeException {
      logger.debug("getTExpNssTradeInfoLst start...");
      String sql = "select * from amldata.T_EXP_NSS_TRADE t where t.sstr_id= ? order by rpdi_seqno";
      List list = this.findList(sql, new Object[]{sstrId});
      ArrayList modelList = new ArrayList(list.size());
      Iterator var6 = list.iterator();

      while(var6.hasNext()) {
         Map map = (Map)var6.next();
         TExpNssTradeModel model = (TExpNssTradeModel)CommonKit.mapToModel(map, new TExpNssTradeModel());
         modelList.add(model);
      }

      return modelList;
   }

   public List getTExpNssAttachmentInfoLst(String reportId) throws RuntimeException {
      logger.debug("getTExpNssAttachmentInfoLst start...");
      String sql = "select * from WOLFDATA.t_files f, wolfdata.t_file_content c where f.id = c.id and f.object_id = ?";
      List list = this.findList(sql, new Object[]{reportId});
      ArrayList modelList = new ArrayList(list.size());
      Iterator var6 = list.iterator();

      while(var6.hasNext()) {
         Map map = (Map)var6.next();
         TFileModel model = (TFileModel)CommonKit.mapToModel(map, new TFileModel());
         modelList.add(model);
      }

      return modelList;
   }
}
