package com.rw.aml.dao;

import com.rw.aml.dao.AmlBaseDAOImpl;
import com.rw.aml.dao.DshReportDAO;
import com.rw.aml.model.table.TExpDshCustModel;
import com.rw.aml.model.table.TExpDshModel;
import com.rw.aml.model.table.TExpDshTradeDetailModel;
import com.rw.aml.model.table.TExpDshTradeTotalModel;
import com.rw.aml.model.table.VDshCihtrDetailModel;
import com.rw.aml.model.table.VDshDhtrDetailModel;
import com.rw.annotation.SystemDaoLog;
import com.rw.util.CommonKit;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository("dshReportDAO")
public class DshReportDAOImpl extends AmlBaseDAOImpl implements DshReportDAO {

   private static final Logger logger = LoggerFactory.getLogger(DshReportDAOImpl.class);


   @SystemDaoLog(
      description = "获取单个大额上报信息"
   )
   public TExpDshModel getTExpDshInfo(String dshId) throws RuntimeException {
      logger.debug("getTExpDshInfo start...");
      String sql = "select * from amldata.T_EXP_DSH t where t.dsh_id= ?";
      List list = this.findList(sql, new Object[]{dshId});
      if(list.size() > 0) {
         Map map = (Map)list.get(0);
         TExpDshModel model = (TExpDshModel)CommonKit.mapToModel(map, new TExpDshModel());
         return model;
      } else {
         return null;
      }
   }

   @SystemDaoLog(
      description = "获取一组大额上报信息"
   )
   public List getTExpDshInfo(List dshIdList) throws RuntimeException {
      logger.debug("getTExpDshInfo start...");
      String sql = "select * from amldata.T_EXP_DSH t ";
      if(dshIdList != null && dshIdList.size() > 0) {
         StringBuilder list = new StringBuilder();
         list.append(sql);
         list.append(" where t.dsh_id in");
         list.append("(");
         Iterator map = dshIdList.iterator();

         while(map.hasNext()) {
            String modelList = (String)map.next();
            list.append("\'");
            list.append(modelList);
            list.append("\'");
            list.append(",");
         }

         list.deleteCharAt(list.length() - 1);
         list.append(")");
         sql = list.toString();
      }

      List list1 = this.findList(sql);
      ArrayList modelList1 = new ArrayList(list1.size());
      Iterator var6 = list1.iterator();

      while(var6.hasNext()) {
         Map map1 = (Map)var6.next();
         TExpDshModel model = (TExpDshModel)CommonKit.mapToModel(map1, new TExpDshModel());
         modelList1.add(model);
      }

      return modelList1;
   }

   @SystemDaoLog(
      description = "获取大额交易明细数据总数"
   )
   public int getAllTradeDetailNumber(String dshId) throws RuntimeException {
      logger.debug("getAllTradeDetailNumber start...");
      int size = 0;
      String sql = "select count(dsh_id) as records from amldata.T_EXP_DSH_TRADE_D t where t.dsh_id= ?";
      List list = this.findList(sql, new Object[]{dshId});
      if(list.size() > 0) {
         Map map = (Map)list.get(0);
         size = ((BigDecimal)map.get("RECORDS")).intValue();
      }

      logger.debug("getAllTradeDetailNumber end...");
      return size;
   }

   @SystemDaoLog(
      description = "获取大额交易客户"
   )
   public List getTExpDshCustInfoLst(String dshId) throws RuntimeException {
      logger.debug("getTExpDshCustInfoLst start...");
      String sql = "select * from amldata.T_EXP_DSH_CUST t where t.dsh_id= ? order by t.cati_seqno";
      List list = this.findList(sql, new Object[]{dshId});
      ArrayList modelList = new ArrayList(list.size());
      Iterator var6 = list.iterator();

      while(var6.hasNext()) {
         Map map = (Map)var6.next();
         TExpDshCustModel model = (TExpDshCustModel)CommonKit.mapToModel(map, new TExpDshCustModel());
         modelList.add(model);
      }

      return modelList;
   }

   @SystemDaoLog(
      description = "获取大额交易总数信息"
   )
   public List getTExpDshTradeTotalInfo(String catiId) throws RuntimeException {
      logger.debug("getTExpDshTradeTotalInfo start...");
      String sql = "select * from amldata.T_EXP_DSH_TRADE_T t where t.cati_id= ?";
      List list = this.findList(sql, new Object[]{catiId});
      ArrayList modelList = new ArrayList(list.size());
      Iterator var6 = list.iterator();

      while(var6.hasNext()) {
         Map map = (Map)var6.next();
         TExpDshTradeTotalModel model = (TExpDshTradeTotalModel)CommonKit.mapToModel(map, new TExpDshTradeTotalModel());
         modelList.add(model);
      }

      return modelList;
   }

   @SystemDaoLog(
      description = "获取大额交易明细数据"
   )
   public List getTExpDshTradeDetailInfoList(String htcrId) throws RuntimeException {
      logger.debug("getTExpDshTradeDetailInfo start...");
      String sql = "select * from amldata.T_EXP_DSH_TRADE_D t where t.htcr_id= ? order　 by t.tsdt_seqno ";
      List list = this.findList(sql, new Object[]{htcrId});
      ArrayList modelList = new ArrayList(list.size());
      Iterator var6 = list.iterator();

      while(var6.hasNext()) {
         Map map = (Map)var6.next();
         TExpDshTradeDetailModel model = (TExpDshTradeDetailModel)CommonKit.mapToModel(map, new TExpDshTradeDetailModel());
         String cratValue = model.getCrat();
         model.setCrat(this.formateCratValue(cratValue));
         modelList.add(model);
      }

      return modelList;
   }

   private String formateCratValue(String cratValue) {
      if(cratValue != null & !"".equals(cratValue)) {
         double cratDblValue = Double.parseDouble(cratValue);
         if(cratDblValue < 0.0D) {
            cratDblValue *= -1.0D;
         }

         String pattern = "0.###";
         DecimalFormat fmt = new DecimalFormat(pattern);
         cratValue = fmt.format(Double.valueOf(cratDblValue)).toString();
         return cratValue;
      } else {
         return null;
      }
   }

   @SystemDaoLog(
      description = "获取大额上报报文客户交易流水信息"
   )
   public List getVDshCihtrDetailInfo(String dshId) throws RuntimeException {
      logger.debug("getVDshCihtrDetailInfo end...");
      String sql = "SELECT * FROM  AMLCONFIG.V_DSH_CIHTR_DETAIL v where v.dsh_id = ? by v.TSDT_SEQNO";
      List list = this.findList(sql, new Object[]{dshId});
      ArrayList modelList = new ArrayList(list.size());
      Iterator var6 = list.iterator();

      while(var6.hasNext()) {
         Map map = (Map)var6.next();
         VDshCihtrDetailModel model = (VDshCihtrDetailModel)CommonKit.mapToModel(map, new VDshCihtrDetailModel());
         modelList.add(model);
      }

      return modelList;
   }

   @SystemDaoLog(
      description = "获取大额上报报文客户基本信息"
   )
   public List getVDshDhtrDetailModel(String dshId) throws RuntimeException {
      logger.debug("getVDshDhtrDetailModel end...");
      String sql = "SELECT * FROM  AMLCONFIG.V_DSH_DHTR_DETAIL  v where v.dsh_id = ? order by v.seqno";
      List list = this.findList(sql, new Object[]{dshId});
      ArrayList modelList = new ArrayList(list.size());
      Iterator var6 = list.iterator();

      while(var6.hasNext()) {
         Map map = (Map)var6.next();
         VDshDhtrDetailModel model = (VDshDhtrDetailModel)CommonKit.mapToModel(map, new VDshDhtrDetailModel());
         modelList.add(model);
      }

      return modelList;
   }
}
