package com.rw.aml.dao;

import com.rw.aml.dao.AmlBaseDAO;
import com.rw.aml.model.table.TFileModel;
import com.rw.aml.model.table.TReportModel;
import com.rw.aml.util.StrUtil;
import com.rw.annotation.SystemDaoLog;
import com.rw.dao.BaseDAOImpl;
import com.rw.util.CommonKit;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Repository;

@Repository("amlBaseDAO")
public class AmlBaseDAOImpl extends BaseDAOImpl implements AmlBaseDAO {

   private static final Logger logger = LoggerFactory.getLogger(AmlBaseDAOImpl.class);
   public static final String tblSchema = "amldata";
   public static final String IS_SUB_COMPANY_CODE = "0";


   @SystemDaoLog(
      description = "查询报表"
   )
   public TReportModel findReport(String uniqueId) throws RuntimeException {
      String sql = "select * from amldata.T_REPORT t where t.unique_rowid = ?";
      List list = this.findList(sql, new Object[]{uniqueId});
      if(list.size() > 0) {
         Map map = (Map)list.get(0);
         TReportModel model = (TReportModel)CommonKit.mapToModel(map, new TReportModel());
         String reportInTime = model.getReportInTime();
         reportInTime = reportInTime.substring(0, reportInTime.length() - 2);
         model.setReportInTime(reportInTime);
         return model;
      } else {
         return null;
      }
   }

   @SystemDaoLog(
      description = "获取上报机构代码"
   )
   public String getReportOrgNum(String userId) throws RuntimeException {
      logger.debug("getReportOrgNum start...");
      String result = "";
      String sql = "";
      if("1".equals("0")) {
         sql = "SELECT a.dept_id   FROM (SELECT DISTINCT tdg.dept_id, tdg.parent_dept, tdg.dept_name   FROM wolf.wb_dept tdg   START WITH (EXISTS (SELECT 1   FROM (select c.dept_id from wolf.wb_user a   inner join wolf.wb_user_role b    on a.user_id = b.user_id    inner join wolf.t_dept_privilege c     on b.role_id = c.role_id     union all select a.dept_id  from wolf.wb_user a  inner join wolf.wb_dept b   on a.dept_id = b.dept_id) tdc    WHERE tdc.dept_id = tdg.dept_id))   CONNECT BY PRIOR parent_dept = dept_id) a   LEFT JOIN (SELECT trdp.dept_id, MAX(1) enable_flag            FROM wolf.t_dept_privilege trdp   JOIN wolf.wb_user_role tur   ON trdp.role_id = tur.role_id  inner  join wolf.wb_user tu     on tur.user_id = tu.user_id   WHERE tu.user_name = \'" + userId + "\'" + "              GROUP BY trdp.dept_id) b  ON a.dept_id = b.dept_id   where a.parent_dept = \'-1\'";
      } else {
         sql = "SELECT * FROM  amldata.T_EXP_COMPANY_CODE";
      }

      List list = this.findList(sql);
      if(list.size() > 0) {
         Map map = (Map)list.get(0);
         String area_code = (String)map.get("COMPANY_CODE");
         result = area_code;
      }

      logger.debug("getReportOrgNum end...");
      return result;
   }

   @SystemDaoLog(
      description = "获取上报机构代码"
   )
   public Map getReportBaseData(String userId) throws RuntimeException {
      logger.debug("getReportBaseData start");
      String sql = "";
      if("1".equals("0")) {
         sql = "SELECT a.dept_id   FROM (SELECT DISTINCT tdg.dept_id, tdg.parent_dept, tdg.dept_name   FROM wolf.wb_dept tdg   START WITH (EXISTS (SELECT 1   FROM (select c.dept_id from wolf.wb_user a   inner join wolf.wb_user_role b    on a.user_id = b.user_id    inner join wolf.t_dept_privilege c     on b.role_id = c.role_id     union all select a.dept_id  from wolf.wb_user a  inner join wolf.wb_dept b   on a.dept_id = b.dept_id) tdc    WHERE tdc.dept_id = tdg.dept_id))   CONNECT BY PRIOR parent_dept = dept_id) a   LEFT JOIN (SELECT trdp.dept_id, MAX(1) enable_flag            FROM wolf.t_dept_privilege trdp   JOIN wolf.wb_user_role tur   ON trdp.role_id = tur.role_id  inner  join wolf.wb_user tu     on tur.user_id = tu.user_id   WHERE tu.user_name = \'" + userId + "\'" + "  GROUP BY trdp.dept_id) b  ON a.dept_id = b.dept_id   where a.parent_dept = \'-1\'";
      } else {
         sql = "select distinct t.code as typecode from amldata.T_EXP_COMPANY_CODE t";
      }

      List list = this.findList(sql);
      if(list.size() == 1) {
         logger.debug("list size is 1");
         Map map = (Map)list.get(0);
         return map;
      } else if(list.size() > 1) {
         logger.debug("list size > 1");
         throw new RuntimeException("数据库有脏数据存在!");
      } else {
         return null;
      }
   }

   @SystemDaoLog(
      description = "获取报表创建时间"
   )
   public String getReportDate() throws RuntimeException {
      logger.debug("getReportDate start...");
      String result = "";
      String sql = "select to_char(sysdate, \'yyyyMMdd\') as reportDate from dual";
      List list = this.findList(sql);
      if(list.size() > 0) {
         Map map = (Map)list.get(0);
         result = (String)map.get("REPORTDATE");
      }

      logger.debug("getReportDate end...");
      return result;
   }

   @SystemDaoLog(
      description = "获取上报报表zipNO"
   )
   public int getZipNoInReportFile(String reportType) throws RuntimeException {
      logger.debug("getZipNoInReportFile start...");
      int exchangeSign = StrUtil.cvtReportTypeToInt(reportType);
      int zipNo = 0;
      String sql = "SELECT nvl(max(t.zip_no),0)+1 zip_no FROM amldata.T_REPORT_FILES t WHERE t.report_date=to_char(SYSDATE,\'yyyymmdd\') and t.report_type = ?";
      List list = this.findList(sql, new Object[]{Integer.valueOf(exchangeSign)});
      if(list.size() > 0) {
         Map map = (Map)list.get(0);
         zipNo = ((BigDecimal)map.get("ZIP_NO")).intValue();
      }

      logger.debug("getZipNoInReportFile end...");
      return zipNo;
   }

   @SystemDaoLog(
      description = "插入附件T_FILES"
   )
   public void instFileSql(TFileModel model) throws RuntimeException {
      StringBuilder sql = new StringBuilder();
      sql.append("insert into wolfDATA.t_files(id, object_id, name, file_size, extension, create_by, create_time, file_flag)");
      sql.append(" values(\'");
      sql.append(model.getId());
      sql.append("\',\'");
      sql.append(model.getObjectId());
      sql.append("\',\'");
      sql.append(model.getName());
      sql.append("\',\'");
      sql.append(model.getFileSize());
      sql.append("\',\'");
      sql.append(model.getExtension());
      sql.append("\',\'");
      sql.append(model.getCreateBy());
      sql.append("\',");
      sql.append("sysdate,\'");
      sql.append(model.getCreateBy());
      sql.append("\')");
      this.insert(sql.toString());
   }

   @SystemDaoLog(
      description = "批量执行SQL"
   )
   public int batchExcute(List sqlList) throws RuntimeException {
      return sqlList != null && sqlList.size() > 0?this.batchUpdateSql(sqlList):0;
   }

   protected String isEmpty(String temp) {
      return StringUtils.isEmpty(temp)?"0":temp;
   }

   @SystemDaoLog(
      description = "插入文件内容到L_FILESTORE"
   )
   public void insertFileContent(byte[] content, String id) throws RuntimeException {
      String tableName = this.getFileContentTableName(id);
      if(StringUtils.isNotBlank(tableName)) {
         String sql = "insert into " + tableName + "(id, content) values(?, ?)";
         this.insert(sql, new Object[]{id, content});
      }

   }

   @SystemDaoLog(
      description = "通过objectId获取文件信息"
   )
   public TFileModel getFileContentId(String reportId) throws RuntimeException {
      String sql = "SELECT f.* FROM WOLFDATA.t_files f,WOLFDATA.T_FILE_CONTENT c where f.id=c.id and f.object_id = \'" + reportId + "\'";
      List list = this.findList(sql);
      if(list.size() == 1) {
         Map map = (Map)list.get(0);
         TFileModel model = (TFileModel)CommonKit.mapToModel(map, new TFileModel());
         return model;
      } else if(list.size() > 1) {
         throw new RuntimeException("数据库有脏数据存在!");
      } else {
         return null;
      }
   }

   @SystemDaoLog(
      description = "删除附件"
   )
   public void deleteFileContentId(String reportId) throws RuntimeException {
      String sql = "delete from WOLFDATA.t_files f where f.object_id = \'" + reportId + "\'";
      this.del(sql);
      sql = "delete from  WOLFDATA.t_file_content c where c.id in (select f.id from wolfdata.t_files f where f.object_id = \'" + reportId + "\')";
      this.del(sql);
   }

   @SystemDaoLog(
      description = "获取报表附件信息"
   )
   public TFileModel getFileContentByParameter(String ids, String reportType, String messageType) throws RuntimeException {
      String sql = "SELECT f.* FROM wolfdata.t_files f,WOLFDATA.T_FILE_CONTENT c,amldata.T_REPORT_FILES t where  f.id = c.id and f.object_id = t.id and  t.object_id = \'" + ids + "\' and  t.report_type = \'" + reportType + "\' and t.message_type = \'" + messageType + "\'";
      List list = this.findList(sql);
      if(list.size() == 1) {
         Map map = (Map)list.get(0);
         TFileModel model = (TFileModel)CommonKit.mapToModel(map, new TFileModel());
         return model;
      } else if(list.size() > 1) {
         throw new RuntimeException("数据库有脏数据存在!");
      } else {
         return null;
      }
   }

   @SystemDaoLog(
      description = "根据报表ID获取报表附件信息"
   )
   public TFileModel getFileContentByReportId(String reportId) throws RuntimeException {
      String sql = "SELECT f.* FROM wolfdata.t_files f, WOLFDATA.T_FILE_CONTENT c,amldata.T_REPORT_FILES t where  f.id = c.id and  f.object_id = t.id and  t.id = \'" + reportId + "\'";
      List list = this.findList(sql);
      if(list.size() == 1) {
         Map map = (Map)list.get(0);
         TFileModel model = (TFileModel)CommonKit.mapToModel(map, new TFileModel());
         return model;
      } else if(list.size() > 1) {
         throw new RuntimeException("数据库有脏数据存在!");
      } else {
         return null;
      }
   }

   @SystemDaoLog(
      description = "获取附件内容"
   )
   public byte[] getFileContent(String id) throws RuntimeException {
      byte[] result = null;
      String tableName = this.getFileContentTableName(id);
      if(StringUtils.isNotBlank(tableName)) {
         String sql = "select content from " + tableName + " where id=\'" + id + "\'";
         List list = this.findList(sql);
         if(list.size() > 0) {
            Map map = (Map)list.get(0);
            result = (byte[])map.get("CONTENT");
         }
      }

      return result;
   }

   private String getFileContentTableName(String id) {
      return "WOLFDATA.T_FILE_CONTENT";
   }
}
