/*
 * Decompiled with CFR 0.152.
 */
package ks.fintech.wb.impl.service;

import com.wb.common.Var;
import com.wb.util.StringUtil;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Random;
import javax.imageio.ImageIO;
import ks.fintech.wb.api.ICaptcha;

public class CaptchaImplService
implements ICaptcha {
    public static final String VERIFY_CODES = "23456789ABCDEFGHJKLMNPQRSTUVWXYZ";
    public static final int DEFAULT_VERIFY_SIZE = 5;
    private static final long serialVersionUID = 1L;

    @Override
    public String generateVerifyCode(int verifySize, String sources) {
        Random rand = new Random(System.currentTimeMillis());
        StringBuilder verifyCode = new StringBuilder(verifySize);
        if (sources == null || sources.length() == 0) {
            int i = 0;
            while (i < verifySize) {
                verifyCode.append(CaptchaImplService.getRandomChar());
                ++i;
            }
        } else {
            int codesLen = sources.length();
            int i = 0;
            while (i < verifySize) {
                verifyCode.append(sources.charAt(rand.nextInt(codesLen - 1)));
                ++i;
            }
        }
        return verifyCode.toString();
    }

    @Override
    public String generateVerifyCode(int verifySize) {
        return this.generateVerifyCode(verifySize, null);
    }

    @Override
    public String generateVerifyCode() {
        return this.generateVerifyCode(5, null);
    }

    @Override
    public void outputImage(OutputStream output, String code) throws IOException {
        this.outputImage(140, 35, output, code);
    }

    @Override
    public void outputImage(int w, int h, OutputStream output, String code) throws IOException {
        if (output == null) {
            throw new IOException("OutputStream is null.");
        }
        String varPrefix = "sys.session.verifyImage.";
        String[] styles = new String[]{"plain", "bold", "italic"};
        int fontStyle = StringUtil.indexOf(styles, Var.getString(String.valueOf(varPrefix) + "fontStyle").toLowerCase());
        if (fontStyle == -1) {
            fontStyle = 1;
        }
        Font font = new Font(Var.getString(String.valueOf(varPrefix) + "fontName"), fontStyle, 16);
        BufferedImage image = new BufferedImage(w, h, 1);
        Graphics g = image.getGraphics();
        try {
            int yl;
            int xl;
            int y;
            int x;
            Random random = new Random();
            g.setColor(CaptchaImplService.getRandColor(200, 250));
            g.fillRect(1, 1, w - 1, h - 1);
            g.setColor(new Color(102, 102, 102));
            g.drawRect(0, 0, w - 1, h - 1);
            g.setFont(font);
            g.setColor(CaptchaImplService.getRandColor(160, 200));
            int i = 0;
            while (i < 155) {
                x = random.nextInt(w - 1);
                y = random.nextInt(w - 1);
                xl = random.nextInt(6) + 1;
                yl = random.nextInt(12) + 1;
                g.drawLine(x, y, x + xl, y + yl);
                ++i;
            }
            i = 0;
            while (i < 70) {
                x = random.nextInt(w - 1);
                y = random.nextInt(h - 1);
                xl = random.nextInt(12) + 1;
                yl = random.nextInt(6) + 1;
                g.drawLine(x, y, x - xl, y - yl);
                ++i;
            }
            i = 0;
            while (i < code.length()) {
                g.setColor(new Color(20 + random.nextInt(110), 20 + random.nextInt(110), 20 + random.nextInt(110)));
                g.drawString(String.valueOf(code.charAt(i)), 25 * i + 15, 23);
                ++i;
            }
        }
        finally {
            g.dispose();
        }
        ImageIO.write((RenderedImage)image, "jpeg", output);
    }

    private static Color getRandColor(int fc, int bc) {
        Random random = new Random();
        int r = fc + random.nextInt(bc - fc);
        int g = fc + random.nextInt(bc - fc);
        int b = fc + random.nextInt(bc - fc);
        return new Color(245, 247, 244);
    }

    private static String getRandomChar() {
        int rand = (int)Math.round(Math.random() * 2.0);
        switch (rand) {
            case 1: {
                long itmp = Math.round(Math.random() * 25.0 + 65.0);
                int ctmp = (int)itmp;
                if (ctmp == 73 || ctmp == 76) {
                    ctmp = 49;
                } else if (ctmp == 79) {
                    ctmp = 48;
                }
                return String.valueOf((char)ctmp);
            }
            case 2: {
                long itmp = Math.round(Math.random() * 25.0 + 97.0);
                int ctmp = (int)itmp;
                if (ctmp == 105 || ctmp == 108) {
                    ctmp = 49;
                } else if (ctmp == 111) {
                    ctmp = 48;
                }
                return String.valueOf((char)ctmp);
            }
        }
        long itmp = Math.round(Math.random() * 9.0);
        return String.valueOf(itmp);
    }
}

