/*
 * Decompiled with CFR 0.152.
 */
package com.wb.workflow;

import com.wb.util.DbUtil;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class FlowPatch {
    private static final Logger log = LoggerFactory.getLogger(FlowPatch.class);

    public static List<Map<String, Object>> getDeptUserSchedules(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String deptIds = request.getParameter("deptIds");
        if (!StringUtils.isEmpty((Object)deptIds)) {
            Connection conn = null;
            try {
                List<Map<String, Object>> schedules;
                conn = DbUtil.getConnection();
                String[] deptArr = deptIds.split(",");
                String inSqlExp = FlowPatch.getInSqlExp(deptArr);
                String[] userIds = FlowPatch.getUserIds(conn, inSqlExp);
                inSqlExp = FlowPatch.getInSqlExp(userIds);
                List<Map<String, Object>> list = schedules = FlowPatch.getSchedules(conn, inSqlExp);
                return list;
            }
            catch (Exception e) {
                log.error("\u6839\u636e\u90e8\u95e8deptIds\uff1a" + deptIds + "\u83b7\u53d6\u90e8\u95e8\u7528\u6237\u7684\u5f85\u529e\u96c6\u5408\u6709\u8bef", (Throwable)e);
                ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
                return arrayList;
            }
            finally {
                DbUtil.close(conn);
            }
        }
        throw new Exception("\u53c2\u6570deptIds\u4e0d\u80fd\u4e3a\u7a7a!");
    }

    private static List<Map<String, Object>> getSchedules(Connection conn, String inSqlExp) throws SQLException {
        if (inSqlExp == null) {
            return new ArrayList<Map<String, Object>>(16);
        }
        ArrayList<Map<String, Object>> schedules = new ArrayList<Map<String, Object>>();
        String sql = "select b.routeid,b.recdate,b.node,b.flow,b.flowid,b.lastuser,a.user_id from wb_route_part_type_user a left join wb_route_part b on a.routeid = b.routeid where a.type = '1' and b.status = '1' and a.user_id in " + inSqlExp;
        PreparedStatement pstmt = conn.prepareStatement(sql, 1003, 1007);
        ResultSet rs = pstmt.executeQuery();
        String[] columnLabels = FlowPatch.getColumnLabels(rs);
        while (rs.next()) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            String[] stringArray = columnLabels;
            int n = columnLabels.length;
            int n2 = 0;
            while (n2 < n) {
                String columnLabel = stringArray[n2];
                map.put(columnLabel, rs.getObject(columnLabel));
                ++n2;
            }
            schedules.add(map);
        }
        DbUtil.close(rs);
        DbUtil.close(pstmt);
        return schedules;
    }

    private static String[] getColumnLabels(ResultSet rs) throws SQLException {
        ResultSetMetaData metaData = rs.getMetaData();
        int columnCount = metaData.getColumnCount();
        String[] columns = new String[columnCount];
        int i = 1;
        while (i <= columnCount) {
            columns[i - 1] = metaData.getColumnLabel(i);
            ++i;
        }
        return columns;
    }

    private static String[] getUserIds(Connection conn, String inSqlExp) throws SQLException {
        if (inSqlExp == null) {
            return new String[0];
        }
        ArrayList<String> userIdList = new ArrayList<String>();
        String sql = "select user_id from wolf.wb_user where dept_id in " + inSqlExp;
        PreparedStatement pstmt = conn.prepareStatement(sql, 1003, 1007);
        ResultSet rs = pstmt.executeQuery();
        while (rs.next()) {
            Object userId = rs.getObject(1);
            userIdList.add(userId == null ? "" : userId.toString());
        }
        String[] userIds = new String[userIdList.size()];
        userIdList.toArray(userIds);
        DbUtil.close(rs);
        DbUtil.close(pstmt);
        return userIds;
    }

    private static String getInSqlExp(String[] deptArr) {
        if (deptArr == null || deptArr.length == 0) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        String[] stringArray = deptArr;
        int n = deptArr.length;
        int n2 = 0;
        while (n2 < n) {
            String dept = stringArray[n2];
            sb.append("'").append(dept).append("'").append(",");
            ++n2;
        }
        return sb.delete(sb.length() - 1, sb.length()).append(")").toString();
    }

    public static void updateFlowDealUser(HttpServletRequest request, HttpServletResponse response) throws Exception {
        String routeId = request.getParameter("routeId");
        String fromUserId = request.getParameter("fromUserId");
        String toUserId = request.getParameter("toUserId");
        if (!(StringUtils.isEmpty((Object)routeId) || StringUtils.isEmpty((Object)fromUserId) || StringUtils.isEmpty((Object)toUserId))) {
            Connection conn = null;
            try {
                try {
                    conn = DbUtil.getConnection();
                    conn.setAutoCommit(false);
                    String sql = "update wb_route_part_type_user set user_id=? where user_id=? and routeid=?";
                    PreparedStatement pstmt = conn.prepareStatement(sql);
                    pstmt.setString(1, toUserId);
                    pstmt.setString(2, fromUserId);
                    pstmt.setString(3, routeId);
                    pstmt.execute();
                    conn.commit();
                }
                catch (Exception e) {
                    log.error("", (Throwable)e);
                    conn.rollback();
                    conn.setAutoCommit(true);
                    DbUtil.close(conn);
                }
            }
            finally {
                conn.setAutoCommit(true);
                DbUtil.close(conn);
            }
        } else {
            throw new Exception("\u53c2\u6570routeId,fromUserId,toUserId\u4e0d\u80fd\u4e3a\u7a7a!");
        }
    }
}

