/*
 * Decompiled with CFR 0.152.
 */
package com.wb.workflow;

import cn.hutool.core.util.StrUtil;
import com.wb.common.Base;
import com.wb.interact.ResourceManager;
import com.wb.util.DbUtil;
import com.wb.util.FileUtil;
import com.wb.util.JsonUtil;
import com.wb.util.StringUtil;
import com.wb.util.WbUtil;
import com.wb.util.WebUtil;
import com.wb.workflow.FlowObject;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONArray;
import org.json.JSONObject;

public class Flow {
    private static Log log = LogFactory.getLog(Flow.class);

    public static String startSubFlow(String filename, JSONObject params, HttpServletRequest request, HttpServletResponse response, Connection conn) throws Exception {
        FlowObject flowObject = Flow.getFlowObject(filename, params, request, response);
        flowObject.verifyAllNode();
        flowObject.getEntrustUser(filename);
        JSONObject paramsObject = flowObject.getParams();
        WebUtil.applyAttributes(request, paramsObject);
        if (!flowObject.startRobot(false, conn)) {
            flowObject.insert(conn);
            flowObject.setSubFlowNode();
            flowObject.recordFlowTo(conn);
            flowObject.isSendMail();
            flowObject.isSendSms();
        }
        return flowObject.getFlowId();
    }

    public static void start(String filename, JSONObject params, Connection conn) throws Exception {
        FlowObject flowObject = Flow.getFlowObject(filename, params, null, null);
        flowObject.verifyAllNode();
        flowObject.getEntrustUser(filename);
    }

    public static String start(String filename, JSONObject params, HttpServletRequest request, HttpServletResponse response) throws Exception {
        WebUtil.applyAttributes(request, params);
        FlowObject flowObject = Flow.getFlowObject(filename, params, request, response);
        flowObject.verifyAllNode();
        flowObject.getEntrustUser(filename);
        JSONObject paramsObject = flowObject.getParams();
        WebUtil.applyAttributes(request, paramsObject);
        Connection conn = null;
        try {
            try {
                conn = DbUtil.getConnection();
                conn.setAutoCommit(false);
                if (!flowObject.startRobot(false, conn)) {
                    flowObject.insert(conn);
                    flowObject.recordFlowTo(conn);
                    flowObject.setSubFlowNode();
                    flowObject.isSendMail();
                    flowObject.isSendSms();
                }
            }
            catch (Exception e) {
                conn.rollback();
                log.error((Object)"error", (Throwable)e);
                throw new Exception(e.getMessage());
            }
        }
        finally {
            if (conn != null) {
                conn.commit();
                conn.close();
            }
        }
        return flowObject.getFlowId();
    }

    public static void start(String filename) throws Exception {
        Flow.start(filename, null, null);
    }

    public static void start(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Flow.doOpen(request, response, 0);
    }

    public static void open(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Flow.doOpen(request, response, 1);
    }

    public static void view(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Flow.doOpen(request, response, 2);
    }

    private static void doOpen(HttpServletRequest request, HttpServletResponse response, int mode) throws Exception {
        FlowObject flowObject;
        JSONObject dialog = null;
        int flowNum = 0;
        String flowIds = null;
        String viewType = "";
        JSONObject params = JsonUtil.getObject(request.getParameter("params"));
        HttpSession session = request.getSession();
        session.removeAttribute("flow.id");
        if (mode == 0) {
            flowObject = Flow.getFlowObject(request.getParameter("filename"), params, request, response);
        } else {
            flowIds = request.getParameter("flowId");
            viewType = request.getParameter("type");
            String[] flowIdArray = flowIds.split(",");
            flowNum = flowIdArray.length;
            flowObject = new FlowObject(Flow.getFlowData(flowIdArray[0], request), params, request, response, null, false);
        }
        JSONObject paramsObject = flowObject.getParams();
        WebUtil.applyAttributes(request, paramsObject);
        if (mode == 0) {
            flowObject.verifyAllNode();
            flowObject.getEntrustUser(request.getParameter("filename"));
            flowObject.verifyStartNode();
        }
        if (mode != 0) {
            flowObject.checkActiveNode(request.getParameter("nodeName"));
        }
        if (mode == 2) {
            dialog = flowObject.getViewDialog(viewType);
            if (dialog == null) {
                throw new NullPointerException("\u6d41\u7a0b\u5f53\u524d\u8282\u70b9\u6ca1\u6709\u914d\u7f6e\u67e5\u770b\u5bf9\u8bdd\u6846\u5c5e\u6027\u3002");
            }
        } else {
            Connection conn = null;
            try {
                try {
                    conn = DbUtil.getConnection();
                    conn.setAutoCommit(false);
                    if (flowObject.startRobot(mode == 0, conn)) {
                        dialog = new JSONObject();
                        dialog.put("robot", true);
                    } else {
                        dialog = flowObject.getDialog(flowNum, flowIds);
                        if (mode == 0) {
                            String id = paramsObject.optString("flow.id");
                            session.setAttribute("flow.id", (Object)id);
                        }
                        if (dialog == null) {
                            throw new NullPointerException("\u6d41\u7a0b\u5f53\u524d\u8282\u70b9\u6ca1\u6709\u914d\u7f6e\u5904\u7406\u5bf9\u8bdd\u6846\u5c5e\u6027\u3002");
                        }
                    }
                }
                catch (Exception e) {
                    conn.rollback();
                    log.error((Object)"error", (Throwable)e);
                    throw new Exception(e.getMessage());
                }
            }
            finally {
                if (conn != null) {
                    conn.commit();
                    conn.close();
                }
            }
        }
        WebUtil.send(response, (Object)dialog);
    }

    private static void doAction(HttpServletRequest request, HttpServletResponse response, String actionName, String flowId, boolean needSend, Connection conn) throws Exception {
        JSONObject paramsObject;
        FlowObject flowObject;
        JSONObject flowParams = new JSONObject(request.getParameter("xFlowParams"));
        JSONObject extraParams = JsonUtil.getObject(request.getParameter("params"));
        JSONObject result = null;
        JSONObject userData = flowParams.optJSONObject("userData");
        String opinionData = flowParams.optString("opinionData");
        String newNodeName = flowParams.optString("newNodeName");
        String passName = flowParams.optString("passName");
        String nodeTitle = flowParams.optString("nodeTitle");
        String passUsers = flowParams.optString("passUsers");
        String procSql = flowParams.optString("procSql");
        boolean isSpecify = false;
        String fillUser = null;
        boolean isStart = StringUtil.isEmpty(flowId);
        if (isStart) {
            String filename = flowParams.optString("filename");
            if (StringUtil.isEmpty(filename)) {
                throw new RuntimeException("Neither filename nor flowId is specified.");
            }
            flowObject = Flow.getFlowObject(filename, extraParams, request, response);
            flowObject.recordActionUser();
            paramsObject = flowObject.getParams();
            WebUtil.applyAttributes(request, paramsObject);
            flowObject.insertStartUser(conn);
            flowObject.getEntrustUser(filename);
            flowObject.forward();
            isSpecify = flowObject.isSpecify(true, conn);
        } else {
            boolean isMainFlow;
            flowObject = new FlowObject(Flow.getFlowData(flowId, request), extraParams, request, response, null, false);
            flowObject.recordActionUser();
            flowObject.checkActiveNode(flowParams.optString("nodeName"));
            paramsObject = flowObject.getParams();
            WebUtil.applyAttributes(request, paramsObject);
            if ("pass".equals(actionName)) {
                flowObject.forward();
                isSpecify = flowObject.isSpecify(false, conn);
            } else if ("reject".equals(actionName)) {
                JSONArray rejectTo = flowParams.optJSONArray("rejectTo");
                isMainFlow = flowParams.optBoolean("isMainFlow");
                fillUser = flowObject.reject(rejectTo, isMainFlow, conn);
            } else if ("beforeSign".equals(actionName)) {
                flowObject.beforeSign(newNodeName, passName, nodeTitle, passUsers, userData);
            } else if ("afterSign".equals(actionName)) {
                flowObject.afterSign(newNodeName, passName, nodeTitle, passUsers, userData);
            } else if ("plusSign".equals(actionName)) {
                flowObject.plusSign(userData);
            } else if ("turn".equals(actionName)) {
                flowObject.turn(userData, opinionData);
            } else if ("fillSign".equals(actionName)) {
                JSONArray fillSignTo = flowParams.optJSONArray("fillSignTo");
                isMainFlow = flowParams.optBoolean("isMainFlow");
                fillUser = flowObject.fillSign(fillSignTo, isMainFlow, conn);
            } else if ("counterSign".equals(actionName)) {
                flowObject.counterSign(newNodeName, passName, nodeTitle, "100%", userData);
            } else if ("assistSign".equals(actionName)) {
                flowObject.assistSign(userData, opinionData);
            } else if ("multSign".equals(actionName)) {
                flowObject.multSign(newNodeName, passName, nodeTitle, passUsers, userData);
            }
        }
        if (isSpecify) {
            result = flowObject.doSpecify(isStart);
        } else {
            String id;
            HashMap map;
            Object res;
            Flow.executeModule(request, flowObject.getFlowAttribute("beforeModule"), paramsObject);
            flowObject.remove(actionName);
            if (StrUtil.isNotBlank((CharSequence)procSql) && "pass".equals(actionName) && (res = DbUtil.run(request, procSql)) != null && ObjectUtils.notEqual((Object)(map = (HashMap)res).get("O_RETURN_CODE").toString(), (Object)"0")) {
                throw new RuntimeException(map.get("O_RETURN_MSG").toString());
            }
            Flow.executeModule(request, flowParams.optString("module"), paramsObject);
            Flow.executeModule(request, flowObject.getFlowAttribute("afterModule"), paramsObject);
            if (isStart) {
                result = flowObject.insert(conn);
            } else {
                result = flowObject.update(conn, fillUser, actionName);
                Flow.checkSubFlowEnd(result.getInt("STATUS"), flowObject.getParentFlowId(), request, response, null, conn);
            }
            flowObject.isSendMail();
            flowObject.isSendSms();
            flowObject.checkSubFlowStart(conn);
            flowObject.recordFlowTo(conn);
            HttpSession session = request.getSession();
            if (session != null && StrUtil.isNotBlank((CharSequence)(id = (String)request.getSession().getAttribute("flow.id")))) {
                session.removeAttribute("flow.id");
            }
        }
        if (needSend) {
            WebUtil.send(response, (Object)result);
        }
    }

    private static void executeModule(HttpServletRequest request, String module, JSONObject params) throws Exception {
        if (!StringUtil.isEmpty(module)) {
            request.setAttribute("sys.params", (Object)params);
            if (WbUtil.canAccess(request, module)) {
                WbUtil.run(module, params, request, true);
            } else {
                throw new RuntimeException("Access denied: " + module);
            }
        }
    }

    public static void multDoAction(HttpServletRequest request, HttpServletResponse response, String actionName) throws Exception {
        JSONObject flowParams = new JSONObject(request.getParameter("xFlowParams"));
        String flowIds = flowParams.optString("flowId");
        Connection conn = null;
        try {
            try {
                conn = DbUtil.getConnection();
                conn.setAutoCommit(false);
                if (StrUtil.isNotBlank((CharSequence)flowIds)) {
                    String[] idArray = flowIds.split(",");
                    int i = 0;
                    while (i < idArray.length) {
                        boolean needSend = false;
                        String flowId = idArray[i];
                        if (i == idArray.length - 1) {
                            needSend = true;
                        }
                        Flow.doAction(request, response, actionName, flowId, needSend, conn);
                        ++i;
                    }
                } else {
                    Flow.doAction(request, response, actionName, flowIds, true, conn);
                }
            }
            catch (Exception e) {
                conn.rollback();
                log.error((Object)"error", (Throwable)e);
                throw new Exception(e.getMessage());
            }
        }
        finally {
            if (conn != null) {
                conn.commit();
                conn.close();
            }
        }
    }

    public static void pass(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Flow.multDoAction(request, response, "pass");
    }

    public static void reject(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Flow.multDoAction(request, response, "reject");
    }

    public static void beforeSign(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Flow.multDoAction(request, response, "beforeSign");
    }

    public static void afterSign(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Flow.multDoAction(request, response, "afterSign");
    }

    public static void plusSign(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Flow.multDoAction(request, response, "plusSign");
    }

    public static void fillSign(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Flow.multDoAction(request, response, "fillSign");
    }

    public static void counterSign(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Flow.multDoAction(request, response, "counterSign");
    }

    public static void assistSign(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Flow.multDoAction(request, response, "assistSign");
    }

    public static void cancelAssiSign(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Flow.delAssiOrTurn(request, response, "cancelAssiSign");
    }

    public static void cancelTurn(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Flow.delAssiOrTurn(request, response, "cancelTurn");
    }

    public static void delAssiOrTurn(HttpServletRequest request, HttpServletResponse response, String actionName) throws Exception {
        JSONObject flowParams = new JSONObject(request.getParameter("xFlowParams"));
        JSONObject extraParams = JsonUtil.getObject(request.getParameter("params"));
        JSONObject result = null;
        String flowId = flowParams.optString("flowId");
        String opinionData = flowParams.optString("opinionData");
        String nodeName = flowParams.optString("nodeName");
        FlowObject flowObject = new FlowObject(Flow.getFlowData(flowId, request), extraParams, request, response, null, false);
        flowObject.checkActiveNode(nodeName);
        flowObject.recordHistory(actionName);
        JSONObject paramsObject = flowObject.getParams();
        Flow.executeModule(request, flowObject.getFlowAttribute("afterModule"), paramsObject);
        Connection conn = null;
        try {
            try {
                conn = DbUtil.getConnection();
                conn.setAutoCommit(false);
                result = flowObject.cancelAssiOrTurn(actionName, opinionData, conn);
                flowObject.recordFlowTo(conn);
            }
            catch (Exception e) {
                conn.rollback();
                log.error((Object)"error", (Throwable)e);
                throw new Exception(e.getMessage());
            }
        }
        finally {
            if (conn != null) {
                conn.commit();
                conn.close();
            }
        }
        WebUtil.send(response, (Object)result);
    }

    public static void multSign(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Flow.multDoAction(request, response, "multSign");
    }

    public static void turn(HttpServletRequest request, HttpServletResponse response) throws Exception {
        Flow.multDoAction(request, response, "turn");
    }

    public static void retreat(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject flowParams = new JSONObject(request.getParameter("xFlowParams"));
        JSONObject extraParams = JsonUtil.getObject(request.getParameter("params"));
        JSONObject result = null;
        String flowId = flowParams.optString("flowId");
        String opinionData = flowParams.optString("opinionData");
        String nodeName = flowParams.optString("nodeName");
        FlowObject flowObject = new FlowObject(Flow.getFlowData(flowId, request), extraParams, request, response, null, false);
        flowObject.checkActiveNode(nodeName);
        JSONObject paramsObject = flowObject.getParams();
        Boolean needChange = flowObject.needChange();
        Boolean isDeal = flowObject.isDeal();
        Flow.executeModule(request, flowObject.getFlowAttribute("afterModule"), paramsObject);
        Connection conn = null;
        try {
            try {
                conn = DbUtil.getConnection();
                conn.setAutoCommit(false);
                result = flowObject.doRetreat(isDeal, opinionData, conn);
                result.put("NEED_PROCESS", 1);
                result.put("IS_CC", 0);
                if (needChange.booleanValue()) {
                    FlowObject mainFlow = new FlowObject(Flow.getFlowData(flowObject.getParentFlowId(), request), null, request, response, null, false);
                    mainFlow.changeMainFlow(conn);
                }
                flowObject.recordFlowTo(conn);
            }
            catch (Exception e) {
                conn.rollback();
                log.error((Object)"error", (Throwable)e);
                throw new Exception(e.getMessage());
            }
        }
        finally {
            if (conn != null) {
                conn.commit();
                conn.close();
            }
        }
        WebUtil.send(response, (Object)result);
    }

    public static JSONObject getFlowData(String flowId, HttpServletRequest request) throws Exception {
        String result;
        Connection conn = null;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            conn = DbUtil.getConnection(request);
            st = conn.prepareStatement("select FLOW_DATA from WB_FLOW_INSTANCE where FLOW_ID=?");
            st.setString(1, flowId);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new IllegalArgumentException("\u6d41\u7a0b\u201c" + flowId + "\u201d\u4e0d\u5b58\u5728\u3002");
            }
            result = (String)DbUtil.getObject(rs, 1, 2011);
        }
        catch (Throwable throwable) {
            DbUtil.close(rs);
            DbUtil.close(st);
            throw throwable;
        }
        DbUtil.close(rs);
        DbUtil.close(st);
        return new JSONObject(result);
    }

    private static FlowObject getFlowObject(String filename, JSONObject params, HttpServletRequest request, HttpServletResponse response) throws Exception {
        File file = new File(ResourceManager.basePath, filename);
        return new FlowObject(ResourceManager.getExecuteObject(request, file), params, request, response, file.getName(), true);
    }

    private static void checkSubFlowEnd(int status, String parentFlowId, HttpServletRequest request, HttpServletResponse response, JSONObject params, Connection conn) throws Exception {
        if (status == 2 && !StringUtil.isEmpty(parentFlowId)) {
            JSONObject parentFlowData = Flow.getFlowData(parentFlowId, request);
            int subFlowCount = parentFlowData.optInt("subFlowCount");
            parentFlowData.put("subFlowCount", --subFlowCount);
            FlowObject flowObject = new FlowObject(parentFlowData, params, request, response, null, false);
            if (subFlowCount == 0) {
                JSONObject paramsObject = flowObject.getParams();
                WebUtil.applyAttributes(request, paramsObject);
                flowObject.doFinishAllSubFlow(conn);
            } else {
                flowObject.updateMainFlow(conn);
            }
        }
    }

    public static void specifyUsers(HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONArray userIdsArray;
        JSONObject flowParams = new JSONObject(request.getParameter("xFlowParams"));
        JSONObject extraParams = JsonUtil.getObject(request.getParameter("params"));
        String procSql = flowParams.optString("procSql");
        String ids = request.getParameter("userIds");
        HashSet<String> hs = new HashSet<String>();
        if (StrUtil.isNotBlank((CharSequence)ids) && (userIdsArray = new JSONArray(ids)).length() > 0) {
            int j = 0;
            while (j < userIdsArray.length()) {
                JSONObject user = userIdsArray.getJSONObject(j);
                String userId = user.getString("USER_ID");
                hs.add(userId);
                ++j;
            }
        }
        String flowIds = request.getParameter("flowId");
        boolean isStart = "true".equals(request.getParameter("isStart"));
        String[] idArray = flowIds.split(",");
        Connection conn = null;
        try {
            try {
                conn = DbUtil.getConnection();
                conn.setAutoCommit(false);
                int i = 0;
                while (i < idArray.length) {
                    String id;
                    HashMap map;
                    Object res;
                    FlowObject flowObject;
                    String flowId = idArray[i];
                    if (isStart) {
                        String filename = request.getParameter("fileName");
                        flowObject = Flow.getFlowObject(filename, extraParams, request, response);
                        flowObject.insertStartUser(conn);
                        flowObject.getEntrustUser(filename);
                    } else {
                        flowObject = new FlowObject(Flow.getFlowData(flowId, request), extraParams, request, response, null, false);
                    }
                    flowObject.recordActionUser();
                    JSONObject paramsObject = flowObject.getParams();
                    WebUtil.applyAttributes(request, paramsObject);
                    Flow.executeModule(request, flowObject.getFlowAttribute("beforeModule"), paramsObject);
                    flowObject.forward();
                    flowObject.remove("pass");
                    if (StrUtil.isNotBlank((CharSequence)procSql) && (res = DbUtil.run(request, procSql)) != null && ObjectUtils.notEqual((Object)(map = (HashMap)res).get("O_RETURN_CODE").toString(), (Object)"0")) {
                        throw new RuntimeException(map.get("O_RETURN_MSG").toString());
                    }
                    Flow.executeModule(request, flowParams.optString("module"), paramsObject);
                    Flow.executeModule(request, flowObject.getFlowAttribute("afterModule"), paramsObject);
                    if (hs.size() > 0) {
                        flowObject.reloadSpecifyUsers(hs, flowId, false, conn, isStart);
                    }
                    if (isStart) {
                        flowObject.insert(conn);
                    } else {
                        flowObject.update(conn, "", "pass");
                    }
                    flowObject.recordFlowTo(conn);
                    flowObject.isSendMail();
                    flowObject.isSendSms();
                    HttpSession session = request.getSession();
                    if (session != null && StrUtil.isNotBlank((CharSequence)(id = (String)request.getSession().getAttribute("flow.id")))) {
                        session.removeAttribute("flow.id");
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                conn.rollback();
                log.error((Object)"error", (Throwable)e);
                throw new Exception(e.getMessage());
            }
        }
        finally {
            if (conn != null) {
                conn.commit();
                conn.close();
            }
        }
    }

    public static void getAllFiles(HttpServletRequest request, HttpServletResponse response) throws IOException {
        List list = cn.hutool.core.io.FileUtil.loopFiles((File)new File(Base.path, "wb/system/resources/workflow"));
        JSONArray rows = new JSONArray();
        int i = 0;
        while (i < list.size()) {
            File file = (File)list.get(i);
            String path = FileUtil.getPath(file);
            String endWith = path.substring(path.length() - 4, path.length());
            if (".flw".equals(endWith)) {
                String name = StringUtil.select(file.getName(), path);
                JSONObject item = new JSONObject();
                item.put("name", (Object)name);
                int index = path.lastIndexOf("workflow");
                item.put("value", (Object)path.substring(index));
                rows.put((Object)item);
            }
            ++i;
        }
        WebUtil.send(response, (Object)rows);
    }
}

