/*
 * Decompiled with CFR 0.152.
 */
package com.wb.util;

import cn.hutool.core.util.StrUtil;
import com.syspatch.zip.ZipInputStream;
import com.syspatch.zip.ZipOutputStream;
import com.wb.common.Var;
import com.wb.interact.IDEModulesPerm;
import com.wb.interact.Service;
import com.wb.util.FileUtil;
import com.wb.util.JsonUtil;
import com.wb.util.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.json.JSONObject;

public class ZipUtil {
    public static void zip(File[] source, OutputStream outputStream) throws IOException {
        zipStream.fileCharset = Var.getString("sys.locale.filenameCharset");
        try (ZipOutputStream zipStream = new ZipOutputStream(outputStream);){
            File[] fileArray = source;
            int n = source.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                ZipUtil.zip(file, zipStream, file.getName());
                ++n2;
            }
        }
    }

    public static void zip(File[] source, File zipFile) throws Exception {
        ZipUtil.zip(source, new FileOutputStream(zipFile));
    }

    private static void zip(File source, ZipOutputStream zipStream, String base) throws IOException {
        if (source.isDirectory()) {
            File[] fileList;
            com.syspatch.zip.ZipEntry entry = new com.syspatch.zip.ZipEntry(String.valueOf(base) + '/');
            entry.setTime(source.lastModified());
            zipStream.putNextEntry(entry);
            if (!StringUtil.isEmpty(base)) {
                base = String.valueOf(base) + '/';
            }
            File[] fileArray = fileList = FileUtil.listFiles(source);
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                ZipUtil.zip(file, zipStream, String.valueOf(base) + file.getName());
                ++n2;
            }
        } else {
            com.syspatch.zip.ZipEntry entry = new com.syspatch.zip.ZipEntry(base);
            entry.setTime(source.lastModified());
            zipStream.putNextEntry(entry);
            try (FileInputStream in = new FileInputStream(source);){
                IOUtils.copy((InputStream)in, (OutputStream)zipStream);
            }
        }
    }

    public static void unZip(String srcFile, String dest, boolean deleteFile) throws Exception {
        File file = new File(srcFile);
        if (!file.exists()) {
            throw new Exception("\u89e3\u538b\u6587\u4ef6\u4e0d\u5b58\u5728!");
        }
        ZipFile zipFile = new ZipFile(file);
        Enumeration e = zipFile.getEntries();
        while (e.hasMoreElements()) {
            ZipEntry zipEntry = (ZipEntry)e.nextElement();
            if (zipEntry.isDirectory()) {
                String name = zipEntry.getName();
                Service.checkMoudle(name, null);
                name = name.substring(0, name.length() - 1);
                File f = new File(String.valueOf(dest) + name);
                f.mkdirs();
                continue;
            }
            File f = new File(String.valueOf(dest) + zipEntry.getName());
            f.getParentFile().mkdirs();
            f.createNewFile();
            InputStream is = zipFile.getInputStream(zipEntry);
            InputStreamReader isr = new InputStreamReader(is, "utf-8");
            FileOutputStream fos = new FileOutputStream(f);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "utf-8");
            char[] chr = new char[1024];
            int length = 0;
            while ((length = isr.read(chr, 0, 1024)) != -1) {
                osw.write(chr, 0, length);
            }
            isr.close();
            osw.close();
        }
        if (zipFile != null) {
            zipFile.close();
        }
        if (deleteFile) {
            file.delete();
        }
    }

    public static void unZip(String srcFile, String dest, boolean deleteFile, boolean isRoot) throws Exception {
        File file = new File(srcFile);
        if (!file.exists()) {
            throw new Exception("\u89e3\u538b\u6587\u4ef6\u4e0d\u5b58\u5728!");
        }
        ZipFile zipFile = new ZipFile(file);
        Enumeration e = zipFile.getEntries();
        while (e.hasMoreElements()) {
            ZipEntry zipEntry = (ZipEntry)e.nextElement();
            if (zipEntry.isDirectory()) {
                String name = zipEntry.getName();
                if (isRoot) {
                    Service.checkMoudle(name, null);
                }
                name = name.substring(0, name.length() - 1);
                File f = new File(String.valueOf(dest) + name);
                f.mkdirs();
                continue;
            }
            File f = new File(String.valueOf(dest) + zipEntry.getName());
            f.getParentFile().mkdirs();
            f.createNewFile();
            InputStream is = zipFile.getInputStream(zipEntry);
            InputStreamReader isr = new InputStreamReader(is, "utf-8");
            FileOutputStream fos = new FileOutputStream(f);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "utf-8");
            char[] chr = new char[1024];
            int length = 0;
            while ((length = isr.read(chr, 0, 1024)) != -1) {
                osw.write(chr, 0, length);
            }
            isr.close();
            osw.close();
        }
        if (zipFile != null) {
            zipFile.close();
        }
        if (deleteFile) {
            file.delete();
        }
    }

    public static void main(String[] args) throws Exception {
        ZipUtil.unZip("C:\\Users\\admin\\Desktop\\alarm.zip", "D:\\code\\", false);
    }

    public static void unzip(HttpServletRequest request, InputStream inputStream, File dest) throws IOException {
        zipStream.fileCharset = Var.getString("sys.locale.filenameCharset");
        try (ZipInputStream zipStream = new ZipInputStream(inputStream);){
            com.syspatch.zip.ZipEntry z;
            while ((z = zipStream.getNextEntry()) != null) {
                File f;
                String name = z.getName();
                if (z.isDirectory()) {
                    f = new File(dest, name = name.substring(0, name.length() - 1));
                    if (!f.exists()) {
                        f.mkdir();
                    }
                } else {
                    FileOutputStream out;
                    boolean xwlExist;
                    f = new File(dest, name);
                    if (!f.exists()) {
                        if (!f.getParentFile().exists()) {
                            f.getParentFile().mkdirs();
                        }
                        f.createNewFile();
                        xwlExist = false;
                    } else if (StrUtil.endWithIgnoreCase((CharSequence)name, (CharSequence)".xwl")) {
                        xwlExist = true;
                        JSONObject root = JsonUtil.readObject(f);
                        JSONObject destRoot = new JSONObject(IOUtils.toString((InputStream)zipStream, (String)"UTF-8"));
                        if (root.has("pkId")) {
                            destRoot.put("pkId", (Object)root.getString("pkId"));
                        }
                        destRoot.put("roles", (Object)root.getJSONObject("roles"));
                        destRoot.put("isDefaultRole", root.has("isDefaultRole") ? root.getBoolean("isDefaultRole") : false);
                        out = new FileOutputStream(f);
                        try {
                            IOUtils.copy((InputStream)IOUtils.toInputStream((String)destRoot.toString(), (String)"UTF-8"), (OutputStream)out);
                        }
                        finally {
                            out.close();
                        }
                    } else {
                        xwlExist = false;
                    }
                    if (!xwlExist) {
                        out = new FileOutputStream(f);
                        try {
                            IOUtils.copy((InputStream)zipStream, (OutputStream)out);
                        }
                        finally {
                            out.close();
                        }
                        if (StrUtil.endWithIgnoreCase((CharSequence)name, (CharSequence)".xwl")) {
                            IDEModulesPerm.uploadFiles(request, f);
                        }
                    }
                }
                f.setLastModified(z.getTime());
            }
        }
    }

    public static void unzip(HttpServletRequest request, File zipFile, File dest) throws IOException {
        ZipUtil.unzip(request, new FileInputStream(zipFile), dest);
    }

    public static File doZip(String sourceDir, String zipFilePath) throws IOException {
        File file = new File(sourceDir);
        File zipFile = new File(zipFilePath);
        ZipOutputStream zos = null;
        try {
            FileOutputStream os = new FileOutputStream(zipFile);
            BufferedOutputStream bos = new BufferedOutputStream(os);
            zos = new ZipOutputStream((OutputStream)bos);
            String basePath = null;
            basePath = file.isDirectory() ? file.getPath() : file.getParent();
            ZipUtil.zipFile(file, basePath, zos);
        }
        finally {
            if (zos != null) {
                zos.closeEntry();
                zos.close();
            }
        }
        return zipFile;
    }

    private static void zipFile(File source, String basePath, ZipOutputStream zos) throws IOException {
        File[] files = null;
        files = source.isDirectory() ? source.listFiles() : new File[]{source};
        InputStream is = null;
        BufferedInputStream bis = null;
        byte[] buf = new byte[1024];
        int length = 0;
        try {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String pathName;
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    pathName = String.valueOf(file.getPath().substring(basePath.length() + 1)) + "/";
                    zos.putNextEntry(new com.syspatch.zip.ZipEntry(pathName));
                    ZipUtil.zipFile(file, basePath, zos);
                } else {
                    pathName = file.getPath().substring(basePath.length() + 1);
                    is = new FileInputStream(file);
                    bis = new BufferedInputStream(is);
                    zos.putNextEntry(new com.syspatch.zip.ZipEntry(pathName));
                    while ((length = bis.read(buf)) > 0) {
                        zos.write(buf, 0, length);
                        zos.flush();
                    }
                }
                ++n2;
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (bis != null) {
                bis.close();
            }
        }
    }
}

