/*
 * Decompiled with CFR 0.152.
 */
package com.wb.util;

import com.wb.common.Var;
import com.wb.tool.WebVarConstant;
import com.wb.util.StringUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.json.JSONArray;
import org.json.JSONObject;

public class WhitesUtil {
    private static Log log = LogFactory.getLog(WhitesUtil.class);

    public static List<String> getWhiteList(String whites, String regex) {
        String[] whiteArray;
        List<String> whilteList = new ArrayList<String>();
        if (!StringUtil.isEmpty(whites) && (whiteArray = whites.split(regex)).length > 0) {
            whilteList = Arrays.asList(whiteArray);
        }
        return whilteList;
    }

    public static Set<String> getFilterKeySet(String prefix, Map<String, Map<String, String>> filterInfoMap) {
        HashSet<String> desSet = null;
        if (filterInfoMap != null) {
            desSet = new HashSet<String>();
            Set<String> keySet = filterInfoMap.keySet();
            for (String key : keySet) {
                Map<String, String> secMap = filterInfoMap.get(key);
                if (secMap == null) continue;
                Set<String> secMapkeySet = secMap.keySet();
                for (String secMapkey : secMapkeySet) {
                    desSet.add(String.valueOf(prefix) + "." + key + "." + secMapkey);
                }
            }
        }
        return desSet;
    }

    public static boolean isExistFilterKey(Set<String> filterSet) {
        for (String key : filterSet) {
            if (Var.nameIsExist(key)) continue;
            return false;
        }
        return true;
    }

    public static JSONObject getPerFilterJson(String filterName, Map<String, String> paramMap) {
        JSONObject perFilter = new JSONObject();
        for (Map.Entry<String, String> en : paramMap.entrySet()) {
            String key = en.getKey();
            String value = en.getValue();
            String describe = WhitesUtil.getParamDescribe(String.valueOf(filterName) + "-" + key);
            if (StringUtil.isEmpty(describe)) continue;
            WhitesUtil.putChildJsonArray(perFilter, key, value, describe);
        }
        return perFilter;
    }

    private static String getParamDescribe(String param) {
        Map<String, String> paramMap = WebVarConstant.paramMap;
        return paramMap.get(param);
    }

    private static void putChildJsonArray(JSONObject parent, String key, String value, String describe) {
        JSONArray childJsonArray = new JSONArray();
        JSONObject type = new JSONObject();
        childJsonArray.add(0, (Object)value);
        childJsonArray.add(1, (Object)describe);
        childJsonArray.add(2, (Object)type.put("type", (Object)"string"));
        parent.put(key, (Object)childJsonArray);
    }

    public static Map<String, Map<String, String>> getFilterInfoMap(String webFilePath) {
        HashMap<String, Map<String, String>> filterMap = null;
        List<Element> list = WhitesUtil.getWhiteFilters(webFilePath);
        if (list != null && list.size() > 0) {
            filterMap = new HashMap<String, Map<String, String>>();
            for (Element element : list) {
                String filterText;
                Map<String, String> perFilterParamMap = WhitesUtil.getInitParamMap(element, filterText = element.element("filter-name").getTextTrim());
                if (perFilterParamMap.isEmpty()) continue;
                filterMap.put(filterText, perFilterParamMap);
            }
        }
        return filterMap;
    }

    public static Map<String, String> getInitParamMap(Element parent, String filterName) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        Iterator<Element> it = WhitesUtil.getIterator(parent, "init-param");
        while (it != null && it.hasNext()) {
            Element e = it.next();
            String paramName = e.elementText("param-name");
            if ("xwlWhiteList".equals(paramName)) {
                if ("XssEscape".equals(filterName)) {
                    paramName = "xwlWhites";
                } else if ("antiSqlInjectionfilter".equals(filterName)) {
                    paramName = "xwlWhiteCollect";
                }
            } else if ("puburi".equals(paramName) && "csrffilter".equals(filterName)) {
                paramName = "puburis";
            }
            String paramValue = e.elementText("param-value");
            paramMap.put(paramName, paramValue);
        }
        return paramMap;
    }

    private static List<Element> getWhiteFilters(String filePath) {
        Document doc = WhitesUtil.getDocument(filePath);
        if (doc == null) {
            return null;
        }
        ArrayList<Element> list = new ArrayList<Element>();
        List<String> desFilters = Arrays.asList(WebVarConstant.FILTERS);
        Element root = doc.getRootElement();
        Iterator<Element> it = WhitesUtil.getIterator(root, "filter");
        while (it != null && it.hasNext()) {
            Element e = it.next();
            String elementText = e.elementText("filter-name");
            if (!desFilters.contains(elementText)) continue;
            list.add(e);
        }
        return list;
    }

    private static Iterator<Element> getIterator(Element parent, String nodeName) {
        if (parent == null) {
            return null;
        }
        Iterator<Element> it = parent.elements(nodeName).iterator();
        return it;
    }

    private static Document getDocument(String xmlFile) {
        File file = new File(xmlFile);
        if (!file.exists()) {
            return null;
        }
        SAXReader reader = new SAXReader();
        reader.setEncoding("UTF-8");
        Document doc = null;
        try {
            doc = reader.read(file);
        }
        catch (DocumentException e) {
            log.error((Object)("\u6587\u4ef6" + xmlFile + "\u8bfb\u53d6\u9519\u8bef"), (Throwable)e);
        }
        return doc;
    }
}

