/*
 * Decompiled with CFR 0.152.
 */
package com.wb.util;

import com.wb.util.IpUtils;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public final class SystemKit {
    private static Set<String> _localAddress;

    public static String getIpAddr(HttpServletRequest request) {
        String ip = request.getHeader("X-Real-IP");
        if (ip != null && !"".equals(ip) && !"unknown".equalsIgnoreCase(ip)) {
            return ip;
        }
        ip = request.getHeader("X-Forwarded-For");
        if (ip != null && !"".equals(ip) && !"unknown".equalsIgnoreCase(ip)) {
            int index = ip.indexOf(44);
            if (index != -1) {
                return ip.substring(0, index);
            }
            return ip;
        }
        return request.getRemoteAddr();
    }

    public static String getRequestBrowserInfo(HttpServletRequest request) {
        String browserVersion = null;
        String header = request.getHeader("user-agent");
        if (header == null || header.equals("")) {
            return "";
        }
        if (header.indexOf("MSIE") > 0) {
            browserVersion = "IE";
        } else if (header.indexOf("Firefox") > 0) {
            browserVersion = "Firefox";
        } else if (header.indexOf("Chrome") > 0) {
            browserVersion = "Chrome";
        } else if (header.indexOf("Safari") > 0) {
            browserVersion = "Safari";
        } else if (header.indexOf("Camino") > 0) {
            browserVersion = "Camino";
        } else if (header.indexOf("Konqueror") > 0) {
            browserVersion = "Konqueror";
        }
        return browserVersion;
    }

    public static String getRequestSystemInfo(HttpServletRequest request) {
        String systenInfo = null;
        String header = request.getHeader("user-agent");
        if (header == null || header.equals("")) {
            return "";
        }
        if (header.indexOf("NT 6.0") > 0) {
            systenInfo = "Windows Vista/Server 2008";
        } else if (header.indexOf("NT 5.2") > 0) {
            systenInfo = "Windows Server 2003";
        } else if (header.indexOf("NT 5.1") > 0) {
            systenInfo = "Windows XP";
        } else if (header.indexOf("NT 6.0") > 0) {
            systenInfo = "Windows Vista";
        } else if (header.indexOf("NT 6.1") > 0) {
            systenInfo = "Windows 7";
        } else if (header.indexOf("NT 6.2") > 0) {
            systenInfo = "Windows Slate";
        } else if (header.indexOf("NT 6.3") > 0) {
            systenInfo = "Windows 9";
        } else if (header.indexOf("NT 5") > 0) {
            systenInfo = "Windows 2000";
        } else if (header.indexOf("NT 4") > 0) {
            systenInfo = "Windows NT4";
        } else if (header.indexOf("Me") > 0) {
            systenInfo = "Windows Me";
        } else if (header.indexOf("98") > 0) {
            systenInfo = "Windows 98";
        } else if (header.indexOf("95") > 0) {
            systenInfo = "Windows 95";
        } else if (header.indexOf("Mac") > 0) {
            systenInfo = "Mac";
        } else if (header.indexOf("Unix") > 0) {
            systenInfo = "UNIX";
        } else if (header.indexOf("Linux") > 0) {
            systenInfo = "Linux";
        } else if (header.indexOf("SunOS") > 0) {
            systenInfo = "SunOS";
        }
        return systenInfo;
    }

    public static String getHostName(String ip) {
        try {
            InetAddress inet = InetAddress.getByName(ip);
            return inet.getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static String getClientIP(HttpServletRequest request) {
        String userIP = IpUtils.getClientIP(request);
        if ("127.0.0.1".equals(userIP) || "0:0:0:0:0:0:0:1".equals(userIP)) {
            try {
                userIP = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return userIP;
    }

    private static String callCmd(String[] cmd) {
        String result = "";
        String line = "";
        try {
            Process proc = Runtime.getRuntime().exec(cmd);
            InputStreamReader is = new InputStreamReader(proc.getInputStream());
            BufferedReader br = new BufferedReader(is);
            while ((line = br.readLine()) != null) {
                result = String.valueOf(result) + line;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    private static String callCmd(String[] cmd, String[] another) {
        String result = "";
        String line = "";
        try {
            Runtime rt = Runtime.getRuntime();
            Process proc = rt.exec(cmd);
            proc.waitFor();
            proc = rt.exec(another);
            InputStreamReader is = new InputStreamReader(proc.getInputStream(), Charset.forName("GBK"));
            BufferedReader br = new BufferedReader(is);
            while ((line = br.readLine()) != null) {
                result = String.valueOf(result) + line + "\r\n";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void main(String[] args) {
        String[] cmd = new String[]{"cmd", "/c", "ping 10.253.42.175"};
        String[] another = new String[]{"cmd", "/c", "arp -a"};
        SystemKit.callCmd(cmd, another);
    }

    private static String filterMacAddress(String ip, String sourceString, String macSeparator) {
        String result = "";
        String regExp = "((([0-9,A-F,a-f]{1,2}" + macSeparator + "){1,5})[0-9,A-F,a-f]{1,2})";
        Pattern pattern = Pattern.compile(regExp);
        Matcher matcher = pattern.matcher(sourceString);
        int index = sourceString.indexOf(ip);
        if (index > 0) {
            while (matcher.find()) {
                result = matcher.group(1);
                if (index <= sourceString.indexOf(result)) break;
                result = "";
            }
        }
        return result;
    }

    private static String getMacInWindows(String ip) {
        String result = "";
        String[] cmd = new String[]{"cmd", "/c", "ping " + ip};
        String[] another = new String[]{"cmd", "/c", "arp -a"};
        String cmdResult = SystemKit.callCmd(cmd, another);
        result = SystemKit.filterMacAddress(ip, cmdResult, "-");
        return result;
    }

    private static String getMacInLinux(String ip) {
        String result = "";
        String[] cmd = new String[]{"/bin/sh", "-c", "ping " + ip + " -c 2 && arp -a"};
        String cmdResult = SystemKit.callCmd(cmd);
        result = SystemKit.filterMacAddress(ip, cmdResult, ":");
        return result;
    }

    public static String getMacAddress(String ip) {
        if (SystemKit.getLocalAddress().contains(ip)) {
            return SystemKit.getLocalMac();
        }
        String macAddress = "";
        macAddress = SystemKit.getMacInWindows(ip).trim();
        if (IpUtils.isBlank(macAddress)) {
            macAddress = SystemKit.getMacInLinux(ip).trim();
        }
        return macAddress;
    }

    private static String getLocalMac() {
        try {
            InetAddress ia = InetAddress.getLocalHost();
            byte[] mac = NetworkInterface.getByInetAddress(ia).getHardwareAddress();
            StringBuffer sb = new StringBuffer("");
            int i = 0;
            while (i < mac.length) {
                sb.append(String.format("%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
                ++i;
            }
            return sb.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    private static Set<String> getLocalAddress() {
        if (_localAddress == null) {
            try {
                _localAddress = new HashSet<String>();
                InetAddress ia = InetAddress.getLocalHost();
                _localAddress.add("127.0.0.1");
                _localAddress.add("0:0:0:0:0:0:0:1");
                _localAddress.add("localhost");
                _localAddress.add(ia.getHostAddress());
                _localAddress.add(ia.getHostName());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        return _localAddress;
    }
}

